/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public class AndroidPackagingStateStorage
implements StorageOwner {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.android.AndroidPackagingStateStorage");
    private final File myFile;

    private AndroidPackagingStateStorage(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/android/AndroidPackagingStateStorage", "<init>"));
        }
        this.myFile = file;
    }

    public void flush(boolean memoryCachesOnly) {
    }

    public void clean() throws IOException {
        FileUtil.delete((File)this.myFile);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MyState read() {
        block6: {
            MyState myState;
            DataInputStream input2 = new DataInputStream(new FileInputStream(this.myFile));
            try {
                boolean release = input2.readBoolean();
                myState = new MyState(release);
            }
            catch (Throwable throwable) {
                try {
                    input2.close();
                    throw throwable;
                }
                catch (FileNotFoundException input2) {
                    break block6;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            input2.close();
            return myState;
        }
        return null;
    }

    public void saveState(@NotNull MyState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jps/android/AndroidPackagingStateStorage", "saveState"));
        }
        FileUtil.createParentDirs((File)this.myFile);
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(this.myFile));){
            output.writeBoolean(state.myRelease);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    public static class Provider
    extends StorageProvider<AndroidPackagingStateStorage> {
        public static final Provider INSTANCE = new Provider();

        private Provider() {
        }

        @NotNull
        public AndroidPackagingStateStorage createStorage(File targetDataDir) throws IOException {
            AndroidPackagingStateStorage androidPackagingStateStorage = new AndroidPackagingStateStorage(new File(targetDataDir, "android_packaging_options" + File.separator + "data"));
            if (androidPackagingStateStorage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidPackagingStateStorage$Provider", "createStorage"));
            }
            return androidPackagingStateStorage;
        }
    }

    public static class MyState {
        private final boolean myRelease;

        public MyState(boolean release) {
            this.myRelease = release;
        }

        public boolean isRelease() {
            return this.myRelease;
        }
    }
}

