/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams.beans;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapperBase;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanPointerWrapper
extends SpringElementWrapperBase<SpringBeanPointer> {
    private static final String FILESET = "fileset";
    private static final String MODULE = "module";
    private static final String LOCAL_FILE = "context";
    private static final String BEAN_CLASS = "bean_class";
    private static final String BEAN_NAME = "bean_name";
    private static final String XML_TAGNAME = "tag";
    private static final String OFFSET = "offset";
    private static final Function<Pair<String, String>, String> KEY_VALUE_JOINER = pair -> (String)pair.first + "=" + (String)pair.second;

    public static SpringBeanPointerWrapper create(SpringBeanPointer pointer) {
        return new SpringBeanPointerWrapper(pointer);
    }

    protected SpringBeanPointerWrapper(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/spring/perspectives/diagrams/beans/SpringBeanPointerWrapper", "<init>"));
        }
        super(pointer);
    }

    @Override
    public Icon getIcon() {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        return wrapped.isValid() ? SpringPresentationProvider.getSpringIcon((Object)wrapped) : null;
    }

    @Override
    public Module getModule() {
        PsiElement element = ((SpringBeanPointer)this.getWrapped()).getPsiElement();
        return element != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)element) : null;
    }

    @Override
    public String getName() {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        return wrapped.isValid() ? SpringPresentationProvider.getSpringBeanName((SpringBeanPointer)wrapped) : "";
    }

    @Override
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        SpringBeanPointer wrapped = (SpringBeanPointer)this.getWrapped();
        return wrapped.isValid() ? SpringBeanPointerWrapper.getSpringModel(wrapped) : null;
    }

    @Override
    public String getFqn() {
        SmartList pairs = new SmartList();
        SpringBeanPointer pointer = (SpringBeanPointer)this.getWrapped();
        if (!pointer.isValid()) {
            return null;
        }
        CommonSpringModel springModel = SpringBeanPointerWrapper.getSpringModel(pointer);
        Module module = springModel.getModule();
        if (module != null) {
            DomSpringBean springBean;
            XmlTag xmlTag;
            String beanName;
            PsiClass beanClass;
            VirtualFile virtualFile;
            Set configFiles;
            SpringFileSet fileSet;
            if (DumbService.isDumb((Project)module.getProject())) {
                return null;
            }
            pairs.add(Pair.create((Object)MODULE, (Object)module.getName()));
            if (springModel instanceof SpringModel && (fileSet = ((SpringModel)springModel).getFileSet()) != null) {
                pairs.add(Pair.create((Object)FILESET, (Object)fileSet.getId()));
            }
            if ((configFiles = springModel.getConfigFiles()).size() == 1 && (virtualFile = ((PsiFile)configFiles.iterator().next()).getVirtualFile()) != null) {
                pairs.add(Pair.create((Object)LOCAL_FILE, (Object)virtualFile.getPath()));
            }
            if ((beanClass = pointer.getBeanClass()) != null) {
                pairs.add(Pair.create((Object)BEAN_CLASS, (Object)beanClass.getQualifiedName()));
            }
            if (!StringUtil.isEmptyOrSpaces((String)(beanName = pointer.getName()))) {
                pairs.add(Pair.create((Object)BEAN_NAME, (Object)beanName));
            } else if (pointer instanceof DomSpringBeanPointer && (xmlTag = (springBean = (DomSpringBean)((DomSpringBeanPointer)pointer).getSpringBean()).getXmlTag()) != null) {
                pairs.add(Pair.create((Object)XML_TAGNAME, (Object)xmlTag.getName()));
                pairs.add(Pair.create((Object)OFFSET, (Object)Integer.toString(xmlTag.getTextOffset())));
            }
            return StringUtil.join((Collection)pairs, KEY_VALUE_JOINER, (String)";");
        }
        return null;
    }

    @Nullable
    public static CommonSpringModel getSpringModel(@Nullable SpringBeanPointer pointer) {
        return pointer == null ? null : SpringModelUtils.getInstance().getSpringModelByBean(pointer.getSpringBean());
    }

    @Nullable
    public static SpringElementWrapper resolveElementByFQN(String fqn, Project project) {
        Map<String, String> map = SpringBeanPointerWrapper.split(fqn);
        SpringModel springModel = SpringBeanPointerWrapper.getSpringModel(map, project);
        if (springModel != null) {
            SpringBeanPointer beanPointer;
            String beanName = map.get(BEAN_NAME);
            if (!StringUtil.isEmptyOrSpaces((String)beanName) && (beanPointer = SpringModelSearchers.findBean((CommonSpringModel)springModel, (String)beanName)) != null) {
                return new SpringBeanPointerWrapper(beanPointer);
            }
            String beanClass = map.get(BEAN_CLASS);
            if (!StringUtil.isEmptyOrSpaces((String)beanClass)) {
                PsiClass beanPsiClass = JavaPsiFacade.getInstance((Project)project).findClass(beanClass, GlobalSearchScope.allScope((Project)project));
                if (beanPsiClass == null) {
                    return null;
                }
                List pointers = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)beanPsiClass).withInheritors());
                if (pointers.size() == 1) {
                    return new SpringBeanPointerWrapper((SpringBeanPointer)pointers.get(0));
                }
                String offset = map.get(OFFSET);
                String tagName = map.get(XML_TAGNAME);
                for (SpringBeanPointer pointer : pointers) {
                    XmlTag xmlTag;
                    CommonSpringBean springBean = pointer.getSpringBean();
                    if (!(springBean instanceof DomSpringBean) || (xmlTag = springBean.getXmlTag()) == null || !Integer.toString(xmlTag.getTextOffset()).equals(offset)) continue;
                    return new SpringBeanPointerWrapper(pointer);
                }
            }
        }
        return null;
    }

    @Nullable
    private static SpringModel getSpringModel(@NotNull Map<String, String> map, Project project) {
        String path;
        XmlFile xmlFile;
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/spring/perspectives/diagrams/beans/SpringBeanPointerWrapper", "getSpringModel"));
        }
        Module module = SpringBeanPointerWrapper.getModule(map, project);
        if (module == null) {
            return null;
        }
        String fileset = map.get(FILESET);
        if (!StringUtil.isEmptyOrSpaces((String)fileset)) {
            for (SpringModel springModel : SpringManager.getInstance((Project)project).getAllModels(module)) {
                SpringFileSet set = springModel.getFileSet();
                if (set == null || !fileset.equals(set.getId())) continue;
                return springModel;
            }
        }
        if ((xmlFile = SpringBeanPointerWrapper.findFile(project, path = map.get(LOCAL_FILE))) != null) {
            return SpringManager.getInstance((Project)project).getSpringModelByFile((PsiFile)xmlFile);
        }
        return null;
    }

    @Nullable
    private static Module getModule(Map<String, String> map, Project project) {
        String moduleName = map.get(MODULE);
        if (StringUtil.isEmptyOrSpaces((String)moduleName)) {
            return null;
        }
        return ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
    }
}

