/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams.beans;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.util.containers.hash.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringElementWrapperBase<T>
extends SpringElementWrapper<T> {
    protected static final String DELIMITER = ";";

    protected SpringElementWrapperBase(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/spring/perspectives/diagrams/beans/SpringElementWrapperBase", "<init>"));
        }
        super(t);
    }

    public static Map<String, String> split(String fqn) {
        List strings = StringUtil.split((String)fqn, (String)DELIMITER);
        HashMap map = new HashMap();
        for (String string : strings) {
            Pair<String, String> pair = SpringElementWrapperBase.getPair(string);
            if (pair == null) continue;
            map.put(pair.first, pair.second);
        }
        return map;
    }

    @Nullable
    public static Pair<String, String> getPair(String str) {
        int i = str.indexOf("=");
        if (i > 0 && i < str.length() - 1) {
            String key = str.substring(0, i).trim();
            String value = str.substring(i + 1).trim();
            if (!StringUtil.isEmptyOrSpaces((String)key) && !StringUtil.isEmptyOrSpaces((String)value)) {
                return Pair.create((Object)key, (Object)value);
            }
        }
        return null;
    }

    @Nullable
    protected static XmlFile findFile(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/perspectives/diagrams/beans/SpringElementWrapperBase", "findFile"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)path)) {
            PsiFile psiFile;
            VirtualFile relativeFile;
            VirtualFile virtualFile = relativeFile = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(path) : VfsUtilCore.findRelativeFile((String)path, null);
            if (relativeFile != null && (psiFile = PsiManager.getInstance((Project)project).findFile(relativeFile)) instanceof XmlFile) {
                return (XmlFile)psiFile;
            }
        }
        return null;
    }
}

