/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.CreateConstraintValidatorFix;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ConstraintValidatorCreator
extends BaseBeanValidationInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator", "checkClass"));
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return null;
        }
        PsiAnnotation anno = modifierList.findAnnotation("javax.validation.Constraint");
        if (anno == null) {
            return null;
        }
        PsiAnnotationMemberValue value = anno.findAttributeValue("validatedBy");
        if (value instanceof PsiClassObjectAccessExpression) {
            value = ((PsiClassObjectAccessExpression)value).getOperand().getFirstChild();
        }
        if (value instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)value).resolve() == null) {
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)value, BVInspectionBundle.message("constraint.validator.does.not.exist", new Object[0]), (LocalQuickFix)new CreateConstraintValidatorFix((PsiJavaCodeReferenceElement)value, aClass), ProblemHighlightType.ERROR, isOnTheFly)};
        }
        return super.checkClass(aClass, manager, isOnTheFly);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVBundle.message("constraint.validator.creator", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/ConstraintValidatorCreator", "getDisplayName"));
        }
        return string;
    }
}

