/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFix
extends BaseBVQuickFix {
    private final PsiClass myEnum;
    private final String myConstantName;

    public CreateEnumConstantFix(PsiClass psiClass, String val) {
        super(BVBundle.message("create.enum.constant", new Object[0]));
        this.myEnum = psiClass;
        this.myConstantName = val;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/CreateEnumConstantFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/beanValidation/highlighting/fixes/CreateEnumConstantFix", "applyFix"));
        }
        assert (this.myEnum.isEnum()) : "Must be enum";
        try {
            PsiEnumConstant enumConstant = JavaPsiFacade.getInstance((Project)this.myEnum.getProject()).getElementFactory().createEnumConstantFromText(this.myConstantName, null);
            this.myEnum.add((PsiElement)enumConstant);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
    }
}

