/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model.converters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FilePathReferenceProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BvConstraintMappingConverter
extends ResolvingConverter<XmlFile>
implements CustomReferenceConverter {
    public String toString(@Nullable XmlFile xml, ConvertContext context) {
        if (xml == null) {
            return null;
        }
        VirtualFile file = xml.getVirtualFile();
        if (file == null) {
            return null;
        }
        VirtualFile root = BvConstraintMappingConverter.getRootForFile(file, context);
        if (root == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/');
    }

    @Nullable
    private static VirtualFile getRootForFile(VirtualFile file, ConvertContext context) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)context.getPsiManager().getProject()).getFileIndex();
        VirtualFile root = projectFileIndex.getSourceRootForFile(file);
        if (root == null) {
            root = projectFileIndex.getContentRootForFile(file);
        }
        return root;
    }

    public XmlFile fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        XmlElement xmlElement = context.getReferenceXmlElement();
        if (xmlElement == null) {
            return null;
        }
        PsiReference[] references = this.createReferences((GenericDomValue)context.getInvocationElement(), (PsiElement)xmlElement, context);
        if (references.length == 0) {
            return null;
        }
        PsiElement element = references[references.length - 1].resolve();
        return element instanceof XmlFile ? (XmlFile)element : null;
    }

    @NotNull
    public Collection<? extends XmlFile> getVariants(ConvertContext context) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "getVariants"));
        }
        return list;
    }

    public PsiElement resolve(XmlFile psiFile, ConvertContext context) {
        if (context.getFile().equals(psiFile)) {
            return null;
        }
        return BvConstraintMappingConverter.isFileAccepted((PsiFile)psiFile) ? super.resolve((Object)psiFile, context) : null;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull GenericDomValue genericDomValue, @NotNull PsiElement element, @NotNull ConvertContext context) {
        if (genericDomValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genericDomValue", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "createReferences"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "createReferences"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "createReferences"));
        }
        String s = genericDomValue.getStringValue();
        if (s == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        int offset = ElementManipulators.getOffsetInElement((PsiElement)element);
        PsiReference[] psiReferenceArray = new FilePathReferenceProvider(){

            protected boolean isPsiElementAccepted(PsiElement element) {
                return super.isPsiElementAccepted(element) && (!(element instanceof PsiFile) || BvConstraintMappingConverter.isFileAccepted((PsiFile)element));
            }
        }.getReferencesByElement(element, s, offset, true);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static boolean isFileAccepted(@NotNull PsiFile file) {
        XmlTag rootTag;
        XmlFile xmlFile;
        XmlDocument document;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/beanValidation/model/converters/BvConstraintMappingConverter", "isFileAccepted"));
        }
        if (file instanceof XmlFile && (document = (xmlFile = (XmlFile)file).getDocument()) != null && (rootTag = document.getRootTag()) != null) {
            return "constraint-mappings".equals(rootTag.getName());
        }
        return false;
    }

    public String getErrorMessage(@Nullable String value, ConvertContext context) {
        if (Comparing.equal((String)context.getFile().getName(), (String)value)) {
            return "Recursive inclusion of current file";
        }
        return "Cannot resolve file ''" + value + "'' (not included in file sets?)";
    }
}

