/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.model.xml.Bean;
import com.intellij.beanValidation.model.xml.ConstraintMappings;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBvXmlNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BeanNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ConstraintMappingsNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import icons.BVCoreIcons;
import java.util.ArrayList;

public class ConstraintMappingXmlFileNode
extends AbstractBvXmlNode {
    private final XmlFile myFile;
    private final Module myModule;

    public ConstraintMappingXmlFileNode(ConstraintMappingsNode parent, XmlFile file) {
        super(parent, (PsiElement)file, (XmlElement)file);
        this.myFile = file;
        this.myModule = parent.getModule();
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(BVCoreIcons.Xml);
        presentation.addText(this.myFile.getName(), this.getPlainAttributes());
    }

    @Override
    public SimpleNode[] getChildren() {
        DomFileElement root = DomManager.getDomManager((Project)this.myModule.getProject()).getFileElement(this.myFile, ConstraintMappings.class);
        ArrayList<BeanNode> beans = new ArrayList<BeanNode>();
        if (root != null) {
            for (Bean bean : ((ConstraintMappings)root.getRootElement()).getBeans()) {
                beans.add(new BeanNode(this, bean));
            }
        }
        return beans.toArray(new BeanNode[beans.size()]);
    }
}

