/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.database.DataBus;
import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.run.AbstractQueryLanguageConsole;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.engine.HibernateEngine;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackagePointer;
import icons.HibernateCoreIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConsole
extends JpaConsoleBase {
    public static final String CONSOLE_TOOLWINDOW_ID = "Hibernate Console";

    @NotNull
    public static JpaConsoleBase.Builder<HibernateConsole> newConsole(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/hibernate/engine/HibernateConsole", "newConsole"));
        }
        JpaConsoleBase.Builder<HibernateConsole> builder = new JpaConsoleBase.Builder<HibernateConsole>(unitFile){

            public HibernateConsole build() {
                SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)this.getProject(), (String)this.myUnitFile.getElementName());
                HibernateConsole console = new HibernateConsole(this.myUnitFile, this.myConfiguration, (DataBus.Consuming)broker, this.myQuery);
                HibernateEngine engine = new HibernateEngine((DataBus.Producing)broker, this.myUnitFile, this.myConfiguration);
                Disposer.register((Disposable)console, (Disposable)engine);
                return console;
            }
        };
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/engine/HibernateConsole", "newConsole"));
        }
        return builder;
    }

    public HibernateConsole(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration, @NotNull DataBus.Consuming messageBus, @Nullable String query) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/hibernate/engine/HibernateConsole", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/engine/HibernateConsole", "<init>"));
        }
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/hibernate/engine/HibernateConsole", "<init>"));
        }
        super(unitFile, configuration, messageBus, "hql", HibernateConsole.getInitialLanguage(unitFile.getPersistenceFacet()), query);
        this.getLanguageConsole().setPrompt("hql> ");
        this.getMessageBus().addAuditor((DataAuditor)new DataAuditor.Adapter(){

            public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable throwable) {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/hibernate/engine/HibernateConsole$2", "error"));
                }
                if (context.request.owner != HibernateConsole.this || throwable == null) {
                    return;
                }
                if (StringUtil.getThrowableText((Throwable)throwable).contains("org.hibernate.") || throwable instanceof IllegalStateException || throwable instanceof ClassNotFoundException) {
                    super.error(context, message, throwable);
                } else {
                    AbstractQueryLanguageConsole.LOG.error(throwable);
                }
            }
        });
    }

    public static List<HibernateConsole> getActiveConsoles(Project project) {
        return AbstractQueryLanguageConsole.getActiveConsoles((Project)project, (String)CONSOLE_TOOLWINDOW_ID);
    }

    private static Language getInitialLanguage(PersistenceFacet facet) {
        Language qlLanguage = facet.getQlLanguage();
        return qlLanguage == null ? JpqlLanguage.JPQL : qlLanguage;
    }

    public String getToolWindowId() {
        return CONSOLE_TOOLWINDOW_ID;
    }

    public Icon getToolWindowIcon() {
        return HibernateCoreIcons.HibConsoleToolWindow;
    }

    protected String getHelpID() {
        return "tool.window.reference.hibernate.console";
    }

    public boolean isStarted() {
        return HibernateConnectionManager.getInstance(this.getProject()).getActiveConfigurations((PersistencePackagePointer)this.getTarget()).contains(this.getConfiguration());
    }

    public void terminate() {
        HibernateConnectionManager.getInstance(this.getProject()).releaseConnection((PersistencePackagePointer)this.getTarget(), this.getConfiguration());
    }
}

