/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.DatabaseTopics;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.MessageBusUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class DataBus {
    public static final ExtensionPointName<DataConsumer> CONSUMER_EP = ExtensionPointName.create((String)"com.intellij.database.dataConsumer");
    public static final ExtensionPointName<DataProducer> PRODUCER_EP = ExtensionPointName.create((String)"com.intellij.database.dataProducer");
    public static final ExtensionPointName<DataAuditor> AUDITOR_EP = ExtensionPointName.create((String)"com.intellij.database.dataAuditor");
    private static final NotNullLazyKey<DataBus, Project> INSTANCE_KEY = ServiceManager.createLazyKey(DataBus.class);
    private final MessageBus myMessageBus;
    private final AtomicInteger myUseCount;

    DataBus(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "<init>"));
        }
        this.myUseCount = new AtomicInteger();
        this.myMessageBus = MessageBusFactory.newMessageBus((Object)this);
        Disposer.register((Disposable)project, (Disposable)this.newUseCountDisposable());
        for (DataConsumer dataConsumer : (DataConsumer[])Extensions.getExtensions(CONSUMER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.RESPONSE_TOPIC, (Object)dataConsumer);
        }
        for (DataProducer dataProducer : (DataProducer[])Extensions.getExtensions(PRODUCER_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.REQUEST_TOPIC, (Object)dataProducer);
        }
        for (DataAuditor dataAuditor : (DataAuditor[])Extensions.getExtensions(AUDITOR_EP)) {
            this.myMessageBus.connect().subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)dataAuditor);
        }
    }

    private static MessageBus getDataBusInner(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "getDataBusInner"));
        }
        return ((DataBus)DataBus.INSTANCE_KEY.getValue((UserDataHolder)project)).myMessageBus;
    }

    @NotNull
    public static MessageBus newDataBusChild(@NotNull Project project, @NotNull String title, @NotNull Disposable parentDisposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "newDataBusChild"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/DataBus", "newDataBusChild"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/database/DataBus", "newDataBusChild"));
        }
        MessageBus messageBus = MessageBusFactory.newMessageBus((Object)title, (MessageBus)DataBus.getDataBusInner(project));
        Disposable messageBusDisposer = MessageBusUtil.newMessageBusDisposer((MessageBus)messageBus);
        Disposable useCountDisposer = ((DataBus)INSTANCE_KEY.getValue((UserDataHolder)project)).newUseCountDisposable();
        Disposer.register((Disposable)parentDisposable, (Disposable)useCountDisposer);
        Disposer.register((Disposable)parentDisposable, (Disposable)messageBusDisposer);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)parentDisposable);
        MessageBus messageBus2 = messageBus;
        if (messageBus2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "newDataBusChild"));
        }
        return messageBus2;
    }

    @NotNull
    private Disposable newUseCountDisposable() {
        this.myUseCount.incrementAndGet();
        Disposable disposable = new Disposable(){

            public void dispose() {
                if (DataBus.this.myUseCount.decrementAndGet() == 0) {
                    DataBus.this.myMessageBus.dispose();
                }
            }
        };
        if (disposable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "newUseCountDisposable"));
        }
        return disposable;
    }

    @NotNull
    public static Producing shortCircuit(@NotNull Consuming messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/database/DataBus", "shortCircuit"));
        }
        Producing producing = (Producing)((Object)messageBus);
        if (producing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "shortCircuit"));
        }
        return producing;
    }

    public static void addRootAuditor(@NotNull Project project, DataAuditor auditor, Disposable disposable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "addRootAuditor"));
        }
        DataBus.getDataBusInner(project).connect(disposable).subscribe(DatabaseTopics.AUDIT_TOPIC, (Object)auditor);
    }

    @NotNull
    public static DataAuditor getRootAuditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "getRootAuditor"));
        }
        DataAuditor dataAuditor = (DataAuditor)DataBus.getDataBusInner(project).syncPublisher(DatabaseTopics.AUDIT_TOPIC);
        if (dataAuditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "getRootAuditor"));
        }
        return dataAuditor;
    }

    @NotNull
    public static MessageBus getDataBus(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/DataBus", "getDataBus"));
        }
        MessageBus messageBus = DataBus.getDataBusInner(project);
        if (messageBus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DataBus", "getDataBus"));
        }
        return messageBus;
    }

    public static interface Producing {
        public DataConsumer getDataConsumer();

        public DataAuditor getDataAuditor();

        public void addProducer(@NotNull DataProducer var1);

        public void beforeProducerRemove(@NotNull DataProducer var1);

        public void afterProducerRemove(@NotNull DataProducer var1);
    }

    public static interface Consuming {
        public Consuming filterFor(@NotNull DataRequest.OwnerEx var1);

        public DataProducer getDataProducer();

        public void addConsumer(@NotNull DataConsumer var1);

        public void addAuditor(@NotNull DataAuditor var1);
    }
}

