/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThrowableConsumer;
import org.jetbrains.annotations.NotNull;

public abstract class ConnectionProvider {
    private int myUseCounter;
    protected GuardedRef<DatabaseConnection> myConnection;
    protected Exception myLastException;

    public abstract GuardedRef<DatabaseConnection> acquireImpl();

    public DatabaseConnection getConnection() {
        return this.myConnection == null ? null : this.myConnection.get();
    }

    public int getUseCounter() {
        return this.myUseCounter;
    }

    public Exception getLastException() {
        Exception exception = this.myLastException;
        this.myLastException = null;
        return exception;
    }

    public boolean acquire() {
        if (this.myUseCounter++ == 0) {
            this.myConnection = this.acquireImpl();
        }
        return this.myConnection != null;
    }

    public void release() {
        if (--this.myUseCounter == 0) {
            this.forceRelease();
        }
    }

    private void forceRelease() {
        if (this.myConnection != null) {
            this.myConnection.close();
            this.myConnection = null;
        }
    }

    public static ConnectionProvider forElement(final DbElement element) {
        return new ConnectionProvider(){

            @Override
            public GuardedRef<DatabaseConnection> acquireImpl() {
                try {
                    return DbImplUtil.getDatabaseConnection(element);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    this.myLastException = e;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithProvider(@NotNull DbElement element, @NotNull ThrowableConsumer<ConnectionProvider, Exception> runnable) throws Exception {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/access/ConnectionProvider", "runWithProvider"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/access/ConnectionProvider", "runWithProvider"));
        }
        ConnectionProvider provider = ConnectionProvider.forElement(element);
        try {
            Exception exception;
            if (!provider.acquire() && (exception = provider.getLastException()) != null) {
                throw exception;
            }
            runnable.consume((Object)provider);
        }
        finally {
            provider.release();
            assert (provider.getUseCounter() == 0);
            assert (provider.getConnection() == null);
        }
    }
}

