/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0000\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DATA_SOURCE_SETTINGS_BEGIN", "", "DATA_SOURCE_SETTINGS_END", "DATA_SOURCE_SETTINGS_HEADER", "exportSettings", "", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "b", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getDataSourceManager", "Lcom/intellij/database/dataSource/DataSourceManagerEx;", "project", "Lcom/intellij/openapi/project/Project;", "importDataSourceFromSettings", "buffer", "Ljava/lang/StringBuffer;", "importDataSourcesFromSettings", "text", "database-impl"})
public final class DataSourceSettingsHelperKt {
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_HEADER = "#DataSourceSettings#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_BEGIN = "#BEGIN#";
    @NotNull
    public static final String DATA_SOURCE_SETTINGS_END = "#END#";

    public static final void exportSettings(@NotNull LocalDataSource ds, @NotNull StringBuilder b) {
        Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
        Intrinsics.checkParameterIsNotNull((Object)b, (String)"b");
        b.append("#LocalDataSource: ").append(ds.getName()).append('\n');
        StringBuffer text = ds.copySettings(null);
        b.append(DATA_SOURCE_SETTINGS_BEGIN).append('\n');
        b.append(text);
        if (b.charAt(b.length() - 1) != '\n') {
            b.append('\n');
        }
        StringBuilder stringBuilder = b.append(DATA_SOURCE_SETTINGS_END);
        char c = '\n';
        StringsKt.appendln((StringBuilder)stringBuilder.append(c));
    }

    public static final void importDataSourcesFromSettings(@NotNull String text, @Nullable Project project) {
        int q1;
        int p2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        int p1 = StringsKt.indexOf$default((CharSequence)text, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)0, (boolean)false, (int)6, null);
        while (p1 >= 0 && (p2 = StringsKt.indexOf$default((CharSequence)text, (String)DATA_SOURCE_SETTINGS_END, (int)(q1 = p1 + DATA_SOURCE_SETTINGS_BEGIN.length()), (boolean)false, (int)4, null)) >= 0) {
            p1 = StringsKt.indexOf$default((CharSequence)text, (String)DATA_SOURCE_SETTINGS_BEGIN, (int)(p2 + DATA_SOURCE_SETTINGS_END.length()), (boolean)false, (int)4, null);
            StringBuffer b = new StringBuffer();
            b.append(text, q1, p2);
            DataSourceSettingsHelperKt.importDataSourceFromSettings(b, project);
        }
    }

    public static final void importDataSourceFromSettings(@NotNull StringBuffer buffer, @Nullable Project project) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            LocalDataSource ds = LocalDataSource.createDataSourceFromSettings(buffer, project);
            ds.setGlobal(project == null);
            DataSourceManagerEx dataSourceManagerEx = DataSourceSettingsHelperKt.getDataSourceManager(project);
            if (dataSourceManagerEx == null) break block0;
            dataSourceManagerEx.addDataSource(ds);
        }
    }

    private static final DataSourceManagerEx getDataSourceManager(Project project) {
        return project != null ? DataSourceManagerEx.getInstanceEx(project) : (DataSourceManagerEx)((Object)ServiceManager.getService(DataSourceManagerEx.class));
    }
}

