/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.ui.DataSourceManagerDialog;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import javax.swing.Icon;

public class ImportDataSourceAction
extends AnAction {
    public boolean isDumbAware() {
        return false;
    }

    public void update(AnActionEvent e) {
        DataSourceDetector[] detectors = (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME);
        if (ActionPlaces.isToolbarPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(detectors.length != 0);
            return;
        }
        Set<DbElement> element = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        Object item = element.size() <= 1 ? ContainerUtil.getFirstItem(element) : Boolean.TRUE;
        boolean enabled = item == null || item instanceof DbDataSource;
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled && detectors.length != 0);
    }

    public void actionPerformed(AnActionEvent e) {
        DbPsiFacade facade = (DbPsiFacade)DatabaseDataKeys.DB_PSI_FACADE.getData(e.getDataContext());
        if (facade == null) {
            return;
        }
        ImportDataSourceAction.doImportAction(facade, false);
    }

    public static void doImportAction(DbPsiFacade facade, boolean newOnly) {
        Project project = facade.getProject();
        DataSourceRegistry registry = new DataSourceRegistry(project);
        DataSourceDetector[] detectors = (DataSourceDetector[])Extensions.getExtensions((ExtensionPointName)DataSourceDetector.EP_NAME);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            indicator.setText(DatabaseMessages.message((String)"message.discovering.datasources.to.import", (Object[])new Object[0]));
            double totalProgress = detectors.length;
            double curProgress = 0.0;
            for (DataSourceDetector detector : detectors) {
                indicator.setFraction((curProgress += 1.0) / totalProgress);
                String simpleName = StringUtil.trimEnd((String)detector.getClass().getSimpleName(), (String)DataSourceDetector.class.getSimpleName());
                indicator.setText2("Looking for " + simpleName + " connections...");
                ReadAction.run(() -> detector.collectDataSources(project, registry.getBuilder()));
            }
        }, DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), true, project);
        if (newOnly) {
            registry.retainNewOnly();
        }
        if (registry.isEmpty()) {
            Messages.showMessageDialog((Project)project, (String)DatabaseMessages.message((String)"message.no.datasources.to.import.found", (Object[])new Object[0]), (String)DatabaseMessages.message((String)"dialog.title.import.datasources", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
        } else {
            DataSourceManagerDialog.showDialog(facade, registry);
        }
    }
}

