/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbGridGotoRelatedProvider;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableChild;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseTargetElementEvaluator;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.StatePreservingNavigatable;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public abstract class OpenEditorAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction", "update"));
        }
        Project project = e.getProject();
        boolean mouseSelection = e.getInputEvent() instanceof MouseEvent && UIUtil.isToggleListSelectionEvent((MouseEvent)((MouseEvent)e.getInputEvent()));
        boolean enabled = project != null && e.getData(DatabaseView.DATABASE_VIEW_KEY) != null && !mouseSelection && this.getNavigatables(project, e, false).find(o -> o.canNavigate()) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isToolbarPlace((String)e.getPlace()));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction", "actionPerformed"));
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        for (Navigatable n : this.getNavigatables(project, e, true)) {
            if (n instanceof StatePreservingNavigatable) {
                ((StatePreservingNavigatable)n).navigate(true, true);
                continue;
            }
            n.navigate(true);
        }
    }

    @NotNull
    protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction", "getNavigatables"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction", "getNavigatables"));
        }
        JBIterable jBIterable = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY)));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/OpenEditorAction", "getNavigatables"));
        }
        return jBIterable;
    }

    static class OpenDDLGridAction
    extends AlignedIconWithTextAction
    implements DumbAware {
        OpenDDLGridAction() {
        }

        public void update(AnActionEvent e) {
            PsiElement element = (PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT);
            boolean enabled = e.getData(DatabaseDataKeys.DATA_GRID_KEY) != null && DbGridGotoRelatedProvider.getTargetElement(element) != null;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            DbElement target = DbGridGotoRelatedProvider.getTargetElement((PsiElement)e.getData(CommonDataKeys.PSI_ELEMENT));
            if (target == null) {
                return;
            }
            DatabaseTargetElementEvaluator.navigateToSource(target, true);
        }
    }

    static class OpenDDLAction
    extends OpenEditorAction {
        OpenDDLAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction$OpenDDLAction", "getNavigatables"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction$OpenDDLAction", "getNavigatables"));
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filter(DbElement.class).map(o -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction$OpenDDLAction", "lambda$getNavigatables$0"));
                }
                DbElement major = DbNodeDescriptor.adjustForNavigation(o);
                VirtualFile file = DbImplUtil.findSourceVirtualFile(major, forInvoke);
                if (file == null) {
                    return null;
                }
                if (!forInvoke) {
                    return new OpenFileDescriptor(project, file);
                }
                return DatabaseTargetElementEvaluator.createToSourceNavigatable(o);
            }).filter(Navigatable.class);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/OpenEditorAction$OpenDDLAction", "getNavigatables"));
            }
            return jBIterable;
        }
    }

    static class OpenDataAction
    extends OpenEditorAction {
        OpenDataAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction$OpenDataAction", "getNavigatables"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction$OpenDataAction", "getNavigatables"));
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).map(o -> o instanceof DbTableChild ? ((DbTableChild)o).getDbParent() : o).filter(DbTable.class).filter(o -> DbImplUtil.isDataTable(o.getKind())).map(o -> o.getVirtualFile()).filter(Conditions.notNull()).map(o -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction$OpenDataAction", "lambda$getNavigatables$3"));
                }
                return new OpenFileDescriptor(project, o);
            });
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/OpenEditorAction$OpenDataAction", "getNavigatables"));
            }
            return jBIterable;
        }
    }

    static class OpenDefaultAction
    extends OpenEditorAction {
        OpenDefaultAction() {
        }

        @Override
        @NotNull
        protected JBIterable<Navigatable> getNavigatables(@NotNull Project project, @NotNull AnActionEvent e, boolean forInvoke) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction", "getNavigatables"));
            }
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction", "getNavigatables"));
            }
            JBIterable jBIterable = super.getNavigatables(project, e, forInvoke).filter(o -> o instanceof DbElement);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/OpenEditorAction$OpenDefaultAction", "getNavigatables"));
            }
            return jBIterable;
        }
    }
}

