/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentUiType;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.argument.CliArgument;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CliArgumentGroup<T extends CliArgument> {
    private final T[] myArgs;
    private final String myName;
    private final CliArgumentUiType<T> myType;

    public CliArgumentGroup(@NotNull CliArgumentUiType<T> uiType, @NotNull String name, T ... args) {
        if (uiType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiType", "com/intellij/database/cli/CliArgumentGroup", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/CliArgumentGroup", "<init>"));
        }
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/CliArgumentGroup", "<init>"));
        }
        this.myArgs = args;
        this.myName = name;
        this.myType = uiType;
    }

    @NotNull
    public String getUiName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliArgumentGroup", "getUiName"));
        }
        return string;
    }

    @NotNull
    public T[] getArguments() {
        if (this.myArgs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliArgumentGroup", "getArguments"));
        }
        return this.myArgs;
    }

    @NotNull
    public List<CliComponent> createComponents() {
        List<CliComponent> list = this.myType.createComponents(this);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliArgumentGroup", "createComponents"));
        }
        return list;
    }
}

