/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.psi.DbElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CliComponent {
    private final List<Consumer<CliComponent>> myListeners = ContainerUtil.newArrayList();

    protected CliComponent() {
    }

    public final void addListener(@NotNull Consumer<CliComponent> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/cli/CliComponent", "addListener"));
        }
        this.myListeners.add(listener);
    }

    protected final void fireComponentChanged() {
        this.myListeners.forEach(consumer -> consumer.consume((Object)this));
    }

    public boolean isHideable() {
        return true;
    }

    @NotNull
    public abstract String getFullArgument(@NotNull CliContextDescriptor var1);

    @NotNull
    public abstract CliArgument getArgument();

    @NotNull
    public abstract JComponent getComponent();

    @Nullable
    public abstract String getLabel();

    @NotNull
    public abstract String getName();

    public abstract boolean isMyLexeme(@NotNull String var1, @NotNull CliLexeme var2, @NotNull CliLexeme var3, @NotNull CliContextDescriptor var4);

    public abstract void changeState(@NotNull String var1, @NotNull CliLexeme var2, @NotNull CliLexeme var3, @NotNull CliContextDescriptor var4);

    public abstract void reset(@NotNull CliContextDescriptor var1);

    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/CliComponent", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/CliComponent", "configure"));
        }
        return false;
    }

    public boolean isAppendInTheEnd(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/CliComponent", "isAppendInTheEnd"));
        }
        return this.getArgument().isAppendInTheEnd(cd);
    }
}

