/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliDialogValidator;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.DatabaseObjectsPreparer;
import com.intellij.database.cli.LexemeIndicators;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CliConfiguration {
    @NotNull
    public Map<String, String> getInfoMap();

    @NotNull
    public CliPanelDecorator getDecorator();

    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> var1);

    @NotNull
    public String getValidationCommand();

    @NotNull
    public String getPartOfValidationOut();

    @NotNull
    public String sanitizeArguments(@NotNull Collection<DbElement> var1, @NotNull String var2);

    @NotNull
    public String getCommand(@NotNull String var1, @NotNull Parameters var2);

    @NotNull
    public String getName();

    @NotNull
    public List<CliComponent> getComponents();

    @NotNull
    public String getPropertyKey();

    @NotNull
    public CliParameterSearcher getFileParameterSearcher();

    @NotNull
    public LexemeIndicators getPasswordIndicators();

    @NotNull
    public LexemeIndicators getUsernameIndicators();

    @NotNull
    public LexemeIndicators getHostIndicators();

    @NotNull
    public LexemeIndicators getPortIndicators();

    @Nullable
    public LexemeIndicators getSslCaIndicators();

    @Nullable
    public LexemeIndicators getSslCertIndicators();

    @Nullable
    public LexemeIndicators getSslKeyIndicators();

    @NotNull
    public String getHelpCommand();

    @Nullable
    public String getDefaultSearchPath();

    @NotNull
    public CliDialogValidator getValidator();

    @NotNull
    public List<String> getParameterizableArguments();

    @NotNull
    public CliBuilder getCliBuilder(@NotNull Project var1);

    @NotNull
    public CliParameterProcessor getParameterProcessor();

    @NotNull
    public Operation getOperation();

    @NotNull
    public DatabaseObjectsPreparer getObjectsPreparer();

    public static enum Operation {
        DUMP{

            @Override
            @NotNull
            String getTaskTitle() {
                if ("Dumping..." == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$1", "getTaskTitle"));
                }
                return "Dumping...";
            }

            @Override
            @NotNull
            String getStartMask() {
                if ("Dumping with %s..." == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$1", "getStartMask"));
                }
                return "Dumping with %s...";
            }
        }
        ,
        RESTORE{

            @Override
            @NotNull
            String getTaskTitle() {
                if ("Restoring..." == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$2", "getTaskTitle"));
                }
                return "Restoring...";
            }

            @Override
            @NotNull
            String getStartMask() {
                if ("Restoring with %s..." == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Operation$2", "getStartMask"));
                }
                return "Restoring with %s...";
            }
        };


        @NotNull
        abstract String getTaskTitle();

        @NotNull
        abstract String getStartMask();
    }

    public static interface CliParameterSearcher {
        @Nullable
        public String search(@NotNull String var1, @NotNull List<String> var2);
    }

    public static interface CliNotificationManager {
        public void start(@NotNull ProgressIndicator var1, @NotNull DatabaseSystem var2);

        public void update(@NotNull ProgressIndicator var1, @NotNull DataAuditor.PrintingAdapter var2, @NotNull String var3, @NotNull Key var4);

        public void finished(@NotNull String var1, @NotNull DataAuditor.PrintingAdapter var2, boolean var3);
    }

    public static interface CliParameterProcessor {
        @NotNull
        public String process(@NotNull CliLexeme var1, @NotNull String var2);
    }

    public static interface CliBuilder {
        @NotNull
        public GeneralCommandLine build(@NotNull List<String> var1, @NotNull String var2, @Nullable String var3);

        @NotNull
        public CliNotificationManager getNotificationManager();
    }

    public static class Parameters {
        public String username;
        public String host;
        public String port;
        public String sslCa;
        public String sslCert;
        public String sslKey;

        public Parameters(@Nullable String username, @Nullable String host, @Nullable String port, @Nullable String sslCa, @Nullable String sslCert, @Nullable String sslKey) {
            this.username = username;
            this.host = host;
            this.port = port;
            this.sslCa = sslCa;
            this.sslCert = sslCert;
            this.sslKey = sslKey;
        }

        @NotNull
        public Parameters withHost(@NotNull String host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/cli/CliConfiguration$Parameters", "withHost"));
            }
            this.host = host;
            Parameters parameters = this;
            if (parameters == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/CliConfiguration$Parameters", "withHost"));
            }
            return parameters;
        }
    }
}

