/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CliContextDescriptor {
    private final Set<Object> mySet;
    private final List<CliLexeme> myLexemes;
    private final Operation myOperation;
    private final long myNoNamedCount;

    public CliContextDescriptor(@NotNull List<CliLexeme> lexemeList, @NotNull Operation operation) {
        if (lexemeList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexemeList", "com/intellij/database/cli/CliContextDescriptor", "<init>"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/cli/CliContextDescriptor", "<init>"));
        }
        this.mySet = ContainerUtil.newHashSet();
        this.myOperation = operation;
        this.myLexemes = ContainerUtil.filter(lexemeList, CliLexeme::isArgument);
        this.myNoNamedCount = lexemeList.stream().filter(CliLexeme::isParameter).count();
    }

    public long getNoNamedCount() {
        return this.myNoNamedCount;
    }

    public boolean contains(@NotNull String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/cli/CliContextDescriptor", "contains"));
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.lexemeFinder(strings)) != null;
    }

    public boolean contains(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/CliContextDescriptor", "contains"));
        }
        return ContainerUtil.find(this.myLexemes, DbCliUtil.lexemeFinder(s)) != null;
    }

    public int getLexemeIndex(@NotNull String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/database/cli/CliContextDescriptor", "getLexemeIndex"));
        }
        int idx = Integer.MIN_VALUE;
        for (String string : strings) {
            int current = this.getLexemeIndex(string);
            idx = Math.max(idx, current);
        }
        return Math.max(idx, -1);
    }

    public int getLexemeIndex(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/cli/CliContextDescriptor", "getLexemeIndex"));
        }
        return ContainerUtil.lastIndexOf(this.myLexemes, DbCliUtil.lexemeFinder(s));
    }

    public boolean checkedOut(@NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/cli/CliContextDescriptor", "checkedOut"));
        }
        boolean result2 = this.mySet.contains(object);
        this.mySet.add(object);
        return result2;
    }

    public boolean isComponentChanged() {
        return this.myOperation.isComponentChanged();
    }

    public static enum Operation {
        UNKNOWN(false),
        COMPONENT_CHANGED(true),
        TEXT_CHANGED(false);

        private final boolean myComponentChanged;

        private Operation(boolean changed) {
            this.myComponentChanged = changed;
        }

        public boolean isComponentChanged() {
            return this.myComponentChanged;
        }
    }
}

