/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public abstract class DatabaseObjectsPreparer {
    @NotNull
    public abstract Result prepare(@NotNull Collection<DbElement> var1);

    @NotNull
    public DatabaseObjectsPreparer onlyIf(@NotNull Condition<Collection<DbElement>> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIf"));
        }
        ConditionP conditionP = new ConditionP(condition, this);
        if (conditionP == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIf"));
        }
        return conditionP;
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfSingleElement(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIfSingleElement"));
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "lambda$onlyIfSingleElement$0"));
            }
            return ContainerUtil.count((Iterable)c, (Condition)condition) == 1;
        }));
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIfSingleElement"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer onlyIfMoreThanOnce(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIfMoreThanOnce"));
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.onlyIf((Condition<Collection<DbElement>>)((Condition)c -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "lambda$onlyIfMoreThanOnce$1"));
            }
            return ContainerUtil.count((Iterable)c, (Condition)condition) > 1;
        }));
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "onlyIfMoreThanOnce"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
        if (preparer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparer", "com/intellij/database/cli/DatabaseObjectsPreparer", "then"));
        }
        TunnelP tunnelP = new TunnelP(this, preparer);
        if (tunnelP == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "then"));
        }
        return tunnelP;
    }

    @NotNull
    public DatabaseObjectsPreparer mapAppend(@NotNull Function<DbElement, DbElement> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/database/cli/DatabaseObjectsPreparer", "mapAppend"));
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP(c -> {
            if (mapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/database/cli/DatabaseObjectsPreparer", "lambda$mapAppend$2"));
            }
            return JBIterable.from((Iterable)c).map(mapper).filter(Condition.NOT_NULL).append((Iterable)c).unique().toList();
        }));
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "mapAppend"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull ObjectKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/cli/DatabaseObjectsPreparer", "filter"));
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.filter((Condition<DbElement>)DasUtil.byKind((ObjectKind)kind));
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "filter"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer endIf() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this;
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "endIf"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer filter(@NotNull Condition<DbElement> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "filter"));
        }
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new FunP(c -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer", "lambda$filter$3"));
            }
            return ContainerUtil.filter((Collection)c, (Condition)condition);
        }));
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "filter"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer requireNotEmpty() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$1", "prepare"));
                }
                ResultImpl resultImpl = new ResultImpl(elements, false, !elements.isEmpty());
                if (resultImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$1", "prepare"));
                }
                return resultImpl;
            }
        });
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "requireNotEmpty"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public DatabaseObjectsPreparer finish() {
        DatabaseObjectsPreparer databaseObjectsPreparer = this.then(new Last());
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "finish"));
        }
        return databaseObjectsPreparer;
    }

    @NotNull
    public static DatabaseObjectsPreparer idle() {
        DatabaseObjectsPreparer databaseObjectsPreparer = new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$2", "prepare"));
                }
                ResultImpl resultImpl = new ResultImpl(elements, false, true);
                if (resultImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$2", "prepare"));
                }
                return resultImpl;
            }
        };
        if (databaseObjectsPreparer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer", "idle"));
        }
        return databaseObjectsPreparer;
    }

    private static class Last
    extends DatabaseObjectsPreparer {
        private Last() {
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$Last", "prepare"));
            }
            ResultImpl resultImpl = new ResultImpl(elements, true, true);
            if (resultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$Last", "prepare"));
            }
            return resultImpl;
        }
    }

    private static class TunnelP
    extends DatabaseObjectsPreparer {
        private final DatabaseObjectsPreparer myBase;
        private final DatabaseObjectsPreparer myNext;

        private TunnelP(@NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer next) {
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP", "<init>"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP", "<init>"));
            }
            this.myBase = base;
            this.myNext = next;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP", "prepare"));
            }
            Result result2 = this.myBase.prepare(elements);
            Result result3 = result2.isFinal() || !result2.isValid() ? result2 : this.myNext.prepare(result2.get());
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$TunnelP", "prepare"));
            }
            return result3;
        }
    }

    private static class FunP
    extends DatabaseObjectsPreparer {
        private final Function<Collection<DbElement>, Collection<DbElement>> myFun;

        private FunP(@NotNull Function<Collection<DbElement>, Collection<DbElement>> fun) {
            if (fun == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/database/cli/DatabaseObjectsPreparer$FunP", "<init>"));
            }
            this.myFun = fun;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$FunP", "prepare"));
            }
            ResultImpl resultImpl = new ResultImpl((Collection)this.myFun.fun(elements), false, true);
            if (resultImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$FunP", "prepare"));
            }
            return resultImpl;
        }
    }

    private static class ConditionP
    extends DatabaseObjectsPreparer {
        private static final Result INVALID_RESULT = new ResultImpl(ContainerUtil.emptyList(), false, false);
        private static final DatabaseObjectsPreparer INVALID = new DatabaseObjectsPreparer(){

            @Override
            @NotNull
            public Result prepare(@NotNull Collection<DbElement> elements) {
                if (elements == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1", "prepare"));
                }
                Result result2 = INVALID_RESULT;
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP$1", "prepare"));
                }
                return result2;
            }
        };
        private final Condition<Collection<DbElement>> myCondition;
        private final DatabaseObjectsPreparer myBase;
        private DatabaseObjectsPreparer myOnTrue;

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "<init>"));
            }
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "<init>"));
            }
            this(condition, base, INVALID);
        }

        private ConditionP(@NotNull Condition<Collection<DbElement>> condition, @NotNull DatabaseObjectsPreparer base, @NotNull DatabaseObjectsPreparer onTrue) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "<init>"));
            }
            if (base == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "<init>"));
            }
            if (onTrue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTrue", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "<init>"));
            }
            this.myCondition = condition;
            this.myBase = base;
            this.myOnTrue = onTrue;
        }

        @Override
        @NotNull
        public Result prepare(@NotNull Collection<DbElement> elements) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "prepare"));
            }
            Result base = this.myBase.prepare(elements);
            Collection<DbElement> nextElements = base.isValid() ? base.get() : elements;
            Result result2 = base.isFinal() || !base.isValid() || !this.myCondition.value(nextElements) ? base : this.myOnTrue.prepare(nextElements);
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "prepare"));
            }
            return result2;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer then(@NotNull DatabaseObjectsPreparer preparer) {
            if (preparer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preparer", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "then"));
            }
            this.myOnTrue = this.myOnTrue == INVALID ? preparer : new TunnelP(this.myOnTrue, preparer);
            ConditionP conditionP = this;
            if (conditionP == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "then"));
            }
            return conditionP;
        }

        @Override
        @NotNull
        public DatabaseObjectsPreparer endIf() {
            DatabaseObjectsPreparer databaseObjectsPreparer = this.myBase.then(new ConditionP(this.myCondition, ConditionP.idle(), this.myOnTrue));
            if (databaseObjectsPreparer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/DatabaseObjectsPreparer$ConditionP", "endIf"));
            }
            return databaseObjectsPreparer;
        }
    }

    public static class ResultImpl
    implements Result {
        private final Collection<DbElement> myElements;
        private final boolean myFinal;
        private final boolean myValid;

        public ResultImpl(@NotNull Collection<DbElement> elements, boolean aFinal, boolean valid) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/DatabaseObjectsPreparer$ResultImpl", "<init>"));
            }
            this.myElements = elements;
            this.myFinal = aFinal;
            this.myValid = valid;
        }

        @Override
        public boolean isValid() {
            return this.myValid;
        }

        @Override
        public Collection<DbElement> get() {
            return this.myElements;
        }

        @Override
        public boolean isFinal() {
            return this.myFinal;
        }
    }

    static interface Result {
        public boolean isFinal();

        public boolean isValid();

        public Collection<DbElement> get();
    }
}

