/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliArgumentGroup;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliConfigurationBase;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonMysqlArguments;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class MysqlConfigurationBase
extends CliConfigurationBase {
    protected MysqlConfigurationBase(@NotNull CliArgumentGroup<? extends CliArgument>[] group2, @NotNull String[] fileArgs, @NotNull String propertyKey, @NotNull String name) {
        if (group2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/database/cli/MysqlConfigurationBase", "<init>"));
        }
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/MysqlConfigurationBase", "<init>"));
        }
        if (propertyKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyKey", "com/intellij/database/cli/MysqlConfigurationBase", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/cli/MysqlConfigurationBase", "<init>"));
        }
        super(group2, CommonMysqlArguments.HOST, CommonMysqlArguments.PORT, CommonMysqlArguments.USER, CommonMysqlArguments.PASSWORD_PARAMETERIZABLE, fileArgs, CommonMysqlArguments.SSL_CA, CommonMysqlArguments.SSL_CERT, CommonMysqlArguments.SSL_KEY, "MYSQL_PWD", propertyKey, name);
    }

    @Override
    @NotNull
    public List<String> tweakAutocompletion(@NotNull List<String> variants) {
        if (variants == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variants", "com/intellij/database/cli/MysqlConfigurationBase", "tweakAutocompletion"));
        }
        ArrayList result2 = ContainerUtil.newArrayList(variants);
        ContainerUtil.removeAll((Collection)result2, (Object[])CommonMysqlArguments.PASSWORD);
        ContainerUtil.addAll((Collection)result2, (Object[])CommonMysqlArguments.PASSWORD_PARAMETERIZABLE);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/MysqlConfigurationBase", "tweakAutocompletion"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getCommand(@NotNull String command, @NotNull CliConfiguration.Parameters parameters) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/cli/MysqlConfigurationBase", "getCommand"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/cli/MysqlConfigurationBase", "getCommand"));
        }
        String string = super.getCommand(command, MysqlConfigurationBase.modifyHost(parameters));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/MysqlConfigurationBase", "getCommand"));
        }
        return string;
    }

    @NotNull
    private static CliConfiguration.Parameters modifyHost(@NotNull CliConfiguration.Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/database/cli/MysqlConfigurationBase", "modifyHost"));
        }
        CliConfiguration.Parameters parameters2 = parameters.host != null && NetUtils.isLocalhost((String)parameters.host) ? parameters.withHost("127.0.0.1") : parameters;
        if (parameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/MysqlConfigurationBase", "modifyHost"));
        }
        return parameters2;
    }

    @Override
    @NotNull
    public List<String> getParameterizableArguments() {
        List list = ContainerUtil.list((Object[])new String[]{"-p", "-P", "-u", "-h"});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/MysqlConfigurationBase", "getParameterizableArguments"));
        }
        return list;
    }

    @Override
    @NotNull
    public Map<String, String> getInfoMap() {
        HashMap map = ContainerUtil.newHashMap();
        MysqlConfigurationBase.put(map, "Buffer size network communication", CommonMysqlArguments.NET_BUFFER_LENGTH);
        MysqlConfigurationBase.put(map, "Max packet length", CommonMysqlArguments.MAX_ALLOWED_PACKET);
        MysqlConfigurationBase.put(map, "Verbose mode", CommonMysqlArguments.VERBOSE);
        MysqlConfigurationBase.put(map, "Print version", CommonMysqlArguments.VERSION);
        MysqlConfigurationBase.put(map, "TLS version to use", CommonMysqlArguments.TLS_VERSION);
        MysqlConfigurationBase.put(map, "The password to use when connecting to the server", CommonMysqlArguments.PASSWORD_PARAMETERIZABLE);
        MysqlConfigurationBase.put(map, "Display a help message and exit", CommonMysqlArguments.HELP);
        MysqlConfigurationBase.put(map, "Interface for connecting to MySQL server", CommonMysqlArguments.BIND_ADDRESS);
        MysqlConfigurationBase.put(map, "Write host information, program and server version", CommonMysqlArguments.COMMENTS);
        MysqlConfigurationBase.put(map, "Compress client-server communication", CommonMysqlArguments.COMPRESS);
        MysqlConfigurationBase.put(map, "User name", CommonMysqlArguments.USER);
        MysqlConfigurationBase.put(map, "TCP port", CommonMysqlArguments.PORT);
        MysqlConfigurationBase.put(map, "Host name", CommonMysqlArguments.HOST);
        MysqlConfigurationBase.put(map, "Write a debugging log", CommonMysqlArguments.DEBUG);
        MysqlConfigurationBase.put(map, "Debug information on exit", "--debug-check");
        MysqlConfigurationBase.put(map, "Debug information and resources usage statistics", "--debug-info");
        MysqlConfigurationBase.put(map, "Hint about client-side authentication plugin", CommonMysqlArguments.DEFAULT_AUTH);
        MysqlConfigurationBase.put(map, "Use only the given option file", CommonMysqlArguments.DEFAULTS_FILE);
        MysqlConfigurationBase.put(map, "Read not only the usual option groups", CommonMysqlArguments.DEFAULTS_GROUP_SUFFIX);
        MysqlConfigurationBase.put(map, "Continue even if an SQL error occurs", CommonMysqlArguments.FORCE);
        MysqlConfigurationBase.put(map, "Enable cleartext authentication plugin", "--enable-cleartext-plugin");
        MysqlConfigurationBase.put(map, "Do not read any option files", "--no-defaults");
        MysqlConfigurationBase.put(map, "Plugins directory", CommonMysqlArguments.PLUGIN_DIR);
        MysqlConfigurationBase.put(map, "Print program name and options from option files", "--print-defaults");
        MysqlConfigurationBase.put(map, "Connection protocol to use", CommonMysqlArguments.PROTOCOL);
        MysqlConfigurationBase.put(map, "For dumping large tables", CommonMysqlArguments.QUICK);
        MysqlConfigurationBase.put(map, "Refuse connecting if server uses old protocol", "--secure-auth");
        MysqlConfigurationBase.put(map, "Unix - socket file, Windows - name of the pipe", CommonMysqlArguments.SOCKET);
        MysqlConfigurationBase.put(map, "Disable --quick", CommonMysqlArguments.SKIP_QUICK);
        MysqlConfigurationBase.put(map, "Disable --secure-auth", CommonMysqlArguments.SKIP_SECURE_AUTH);
        MysqlConfigurationBase.put(map, "Write dump output as XML", CommonMysqlArguments.XML);
        MysqlConfigurationBase.put(map, "Enable secure connection", CommonMysqlArguments.SSL);
        MysqlConfigurationBase.put(map, "Path X509 key", CommonMysqlArguments.SSL_KEY);
        MysqlConfigurationBase.put(map, "Security state of connection", CommonMysqlArguments.SSL_MODE);
        MysqlConfigurationBase.put(map, "Do not use secure connection", CommonMysqlArguments.SKIP_SSL);
        MysqlConfigurationBase.put(map, "Path list of SSL CAs", CommonMysqlArguments.SSL_CA);
        MysqlConfigurationBase.put(map, "Directory with SSL CA certificates", CommonMysqlArguments.SSL_CA_PATH);
        MysqlConfigurationBase.put(map, "Path of X509 certificate", CommonMysqlArguments.SSL_CERT);
        MysqlConfigurationBase.put(map, "Permitted ciphers for encryption", CommonMysqlArguments.SSL_CIPHER);
        MysqlConfigurationBase.put(map, "Verify server certificate", CommonMysqlArguments.SSL_VERIFY_SERVER_CERT);
        MysqlConfigurationBase.put(map, "Certificate revocation list", CommonMysqlArguments.SSL_CRL);
        MysqlConfigurationBase.put(map, "Certificate revocation list path", CommonMysqlArguments.SSL_CRL_PATH);
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/MysqlConfigurationBase", "getInfoMap"));
        }
        return hashMap;
    }
}

