/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.argument;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.CliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringCliArgumentImpl
extends CliArgumentImpl
implements StringCliArgument {
    public StringCliArgumentImpl(@NotNull String uiName, String ... options) {
        if (uiName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/StringCliArgumentImpl", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/StringCliArgumentImpl", "<init>"));
        }
        super(uiName, options);
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = DbCliUtil.extractParameterizable(this.getArguments());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getPrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public Function<String, String> getQuoter() {
        Function<String, String> function = s -> s;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getQuoter"));
        }
        return function;
    }

    @Override
    @NotNull
    public Function<String, String> getUnquoter() {
        Function<String, String> function = s -> s;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getUnquoter"));
        }
        return function;
    }

    @Override
    @Nullable
    public String getComponentValue(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getComponentValue"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getComponentValue"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getComponentValue"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getComponentValue"));
        }
        return DbCliUtil.cutParameter(text, current, next);
    }

    @Override
    @NotNull
    public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getStringsFromElements"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getStringsFromElements"));
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl", "getStringsFromElements"));
        }
        return list;
    }

    public static class MaybeUnnamedArgument
    extends ElementsStringArgument {
        public MaybeUnnamedArgument(@NotNull String uiName, @NotNull Condition<DbElement> condition, @NotNull String[] options) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "<init>"));
            }
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "<init>"));
            }
            super(uiName, condition, options);
        }

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "isMyLexeme"));
            }
            return cd.contains(this.getArguments()) ? super.isMyLexeme(text, current, next, cd) : current.isParameter() && !cd.checkedOut(this);
        }

        @Override
        @Nullable
        public String getComponentValue(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/StringCliArgumentImpl$MaybeUnnamedArgument", "getComponentValue"));
            }
            return cd.contains(this.getArguments()) ? (current.isArgument() ? DbCliUtil.cutParameter(text, current, next) : null) : current.getText();
        }
    }

    public static class ElementsStringArgument
    extends QuotedStringArgument {
        private final Condition<DbElement> myCondition;

        public ElementsStringArgument(@NotNull String uiName, @NotNull Condition<DbElement> condition, String ... options) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "<init>"));
            }
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "<init>"));
            }
            super(uiName, options);
            this.myCondition = condition;
        }

        @Override
        @NotNull
        public List<String> getStringsFromElements(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "getStringsFromElements"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "getStringsFromElements"));
            }
            List<String> list = DbCliUtil.fromElementsToSeparated(elements, this.myCondition);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl$ElementsStringArgument", "getStringsFromElements"));
            }
            return list;
        }
    }

    public static class QuotedStringArgument
    extends StringCliArgumentImpl {
        public QuotedStringArgument(@NotNull String uiName, String ... options) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument", "<init>"));
            }
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument", "<init>"));
            }
            super(uiName, options);
        }

        @Override
        @NotNull
        public Function<String, String> getQuoter() {
            Function<String, String> function = DbCliUtil::quote;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument", "getQuoter"));
            }
            return function;
        }

        @Override
        @NotNull
        public Function<String, String> getUnquoter() {
            Function<String, String> function = StringUtil::unquoteString;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/argument/StringCliArgumentImpl$QuotedStringArgument", "getUnquoter"));
            }
            return function;
        }
    }
}

