/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.CliUneditableTextField;
import com.intellij.database.dataSource.url.ui.UniformLookSettingsProvider;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.EditorTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CliMultiParametersUneditableTextField
extends CliUneditableTextField {
    private final TextFieldWithBrowseButton myFieldWithBrowseButton;
    private final List<String> myStrings = ContainerUtil.newArrayList();

    public CliMultiParametersUneditableTextField(StringCliArgument argument) {
        super(argument);
        this.myFieldWithBrowseButton = new TextFieldWithBrowseButton(this.myField, (ActionListener)new MyActionListener());
        this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                CliMultiParametersUneditableTextField.this.updateButton();
            }
        });
        this.myField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CliMultiParametersUneditableTextField.this.updateButton();
            }
        });
    }

    private void updateButton() {
        int count = this.getRowCount(this.myField.getText());
        this.myFieldWithBrowseButton.getButton().setVisible(count > 1);
    }

    private int getRowCount(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "getRowCount"));
        }
        int fieldWidth = this.myField.getWidth();
        if (fieldWidth == 0) {
            return 0;
        }
        int stringWidth = GraphicsUtil.stringWidth((String)text, (Font)this.myField.getFont());
        return Math.min(stringWidth / fieldWidth + (stringWidth % fieldWidth > 0 ? 1 : 0), 6);
    }

    @Override
    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "configure"));
        }
        this.myStrings.clear();
        this.myStrings.addAll(((StringCliArgument)this.getArgument()).getStringsFromElements(elements, cd));
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
        return true;
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        String value;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "changeState"));
        }
        if (!cd.checkedOut(this)) {
            this.myField.setText("");
            this.myStrings.clear();
        }
        if ((value = ((StringCliArgument)this.getArgument()).getComponentValue(text, current, next, cd)) == null) {
            return;
        }
        String parameter = DbCliUtil.clearString(value, ((StringCliArgument)this.getArgument()).getUnquoter());
        this.myStrings.add(parameter);
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "reset"));
        }
        super.reset(cd);
        this.myStrings.clear();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myFieldWithBrowseButton;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "getComponent"));
        }
        return textFieldWithBrowseButton;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "getFullArgument"));
        }
        Function<String, String> quoter = ((StringCliArgument)this.getArgument()).getQuoter();
        String string = this.myStrings.isEmpty() ? "" : DbCliUtil.fromListToArgument(this.myStrings, ((StringCliArgument)this.getArgument()).getPrefix(), quoter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliMultiParametersUneditableTextField", "getFullArgument"));
        }
        return string;
    }

    private void showFullText() {
        String text = this.myField.getText();
        EditorTextField field = new EditorTextField(EditorFactory.getInstance().createDocument((CharSequence)text), null, (FileType)FileTypes.PLAIN_TEXT, true, false);
        field.addSettingsProvider(editor -> {
            editor.getSettings().setUseSoftWraps(true);
            editor.setVerticalScrollbarVisible(true);
        });
        field.addSettingsProvider((EditorSettingsProvider)new UniformLookSettingsProvider());
        int count = this.getRowCount(text);
        field.setPreferredWidth(this.myField.getWidth());
        Dimension size = new Dimension(this.myField.getWidth(), this.myField.getHeight() * count);
        field.setPreferredSize(size);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)field, null).setRequestFocus(false).createPopup().showUnderneathOf((Component)this.myField);
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CliMultiParametersUneditableTextField.this.showFullText();
        }
    }
}

