/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.ArgumentComponent;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class CliPathTextField
extends ArgumentComponent<StringCliArgument> {
    private final TextFieldWithBrowseButton myField;

    public CliPathTextField(@NotNull StringCliArgument argument) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/database/cli/component/CliPathTextField", "<init>"));
        }
        super(argument);
        this.myField = new TextFieldWithBrowseButton();
        this.myField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent e) {
                CliPathTextField.this.fireComponentChanged();
            }
        });
        this.myField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor()));
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliPathTextField", "reset"));
        }
        this.myField.setText("");
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myField;
        if (textFieldWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliPathTextField", "getComponent"));
        }
        return textFieldWithBrowseButton;
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/component/CliPathTextField", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/component/CliPathTextField", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/component/CliPathTextField", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliPathTextField", "changeState"));
        }
        String value = ((StringCliArgument)this.getArgument()).getComponentValue(text, current, next, cd);
        if (value == null) {
            return;
        }
        String parameter = DbCliUtil.clearString(value, ((StringCliArgument)this.getArgument()).getUnquoter());
        if (StringUtil.equals((CharSequence)parameter, (CharSequence)this.myField.getText())) {
            return;
        }
        this.myField.setText(parameter);
    }

    @Override
    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/cli/component/CliPathTextField", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliPathTextField", "configure"));
        }
        if (this.myField.getText().isEmpty()) {
            this.myField.setText(CliPathTextField.getDefaultText());
            return true;
        }
        return false;
    }

    @NotNull
    private static String getDefaultText() {
        String string = SystemProperties.getUserHome() + File.separator + "dump.sql";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliPathTextField", "getDefaultText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/component/CliPathTextField", "getFullArgument"));
        }
        StringCliArgument argument = (StringCliArgument)this.getArgument();
        String string = StringUtil.isEmptyOrSpaces((String)this.myField.getText()) ? "" : DbCliUtil.fromListToArgument(ContainerUtil.list((Object[])new String[]{this.myField.getText()}), argument.getPrefix(), argument.getQuoter());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/component/CliPathTextField", "getFullArgument"));
        }
        return string;
    }

    @Override
    public boolean isHideable() {
        return false;
    }
}

