/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.mysql;

import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.BooleanCliArgument;
import com.intellij.database.cli.argument.BooleanCliArgumentImpl;
import com.intellij.database.cli.argument.DefaultValueCliArgument;
import com.intellij.database.cli.argument.DefaultValueCliArgumentImpl;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.argument.StringCliArgumentImpl;
import com.intellij.database.cli.dump.mysql.MysqldumpArguments;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class MysqldumpCliArguments {
    public static final BooleanCliArgument DELAYED_INSERTS = new BooleanCliArgumentImpl("Delayed inserts", "--delayed-insert");
    public static final BooleanCliArgument EXTENDED_INSERTS = new MysqldumpSkipOptBooleanArgument("Multiple rows inserts", MysqldumpArguments.EXTENDED_INSERTS, MysqldumpArguments.SKIP_EXTENDED_INSERTS);
    public static final BooleanCliArgument CREATE_OPTIONS = new MysqldumpSkipOptBooleanArgument("MySQL create table options", MysqldumpArguments.CREATE_OPTIONS, MysqldumpArguments.SKIP_CREATE_OPTIONS);
    public static final BooleanCliArgument DROP_TABLE = new MysqldumpSkipOptBooleanArgument("Add drop table", "--add-drop-table", MysqldumpArguments.SKIP_ADD_DROP_TABLE);
    public static final BooleanCliArgument ADD_LOCKS = new MysqldumpSkipOptBooleanArgument("Add locks", "--add-locks", MysqldumpArguments.SKIP_ADD_LOCKS);
    public static final BooleanCliArgument LOCK_TABLES = new MysqldumpSkipOptBooleanArgument("Lock tables", MysqldumpArguments.LOCK_TABLES, MysqldumpArguments.SKIP_LOCK_TABLES);
    public static final BooleanCliArgument DISABLE_KEYS = new MysqldumpSkipOptBooleanArgument("Disable keys", MysqldumpArguments.DISABLE_KEYS, MysqldumpArguments.SKIP_DISABLE_KEYS);
    public static final BooleanCliArgument DROP_TRIGGER = new BooleanCliArgumentImpl("Add drop trigger", "--add-drop-trigger");
    public static final DefaultValueCliArgument INSERT = new DefaultValueCliArgumentImpl("Insert", new String[0]);
    public static final DefaultValueCliArgument INSERT_WITH_COLUMNS = new DefaultValueCliArgumentImpl("Insert with columns", MysqldumpArguments.INSERTS_WITH_COLUMNS);
    public static final StringCliArgument DATABASES = new StringCliArgumentImpl.ElementsStringArgument("Databases", DasUtil.byClass(DbNamespaceImpl.class), new String[0]){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "isMyLexeme"));
            }
            return current.isParameter() && (!cd.checkedOut(this) || !MysqldumpCliArguments.isOneDatabase(cd));
        }

        @Override
        @NotNull
        public String getComponentValue(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "getComponentValue"));
            }
            String string = current.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$1", "getComponentValue"));
            }
            return string;
        }
    };
    public static final StringCliArgument TABLES = new StringCliArgumentImpl.ElementsStringArgument("Tables", DasUtil.byClass(DbTable.class), new String[0]){

        @Override
        public boolean isMyLexeme(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "isMyLexeme"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "isMyLexeme"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "isMyLexeme"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "isMyLexeme"));
            }
            return current.isParameter() && MysqldumpCliArguments.isOneDatabase(cd) && cd.checkedOut(this);
        }

        @Override
        @NotNull
        public String getComponentValue(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "getComponentValue"));
            }
            if (current == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "getComponentValue"));
            }
            if (next == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "getComponentValue"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "getComponentValue"));
            }
            String string = current.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$2", "getComponentValue"));
            }
            return string;
        }
    };
    public static final StringCliArgument PATH = new StringCliArgumentImpl.QuotedStringArgument("Out path", MysqldumpArguments.RESULT_FILE);

    private MysqldumpCliArguments() {
    }

    private static boolean isOneDatabase(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments", "isOneDatabase"));
        }
        return !cd.contains(MysqldumpArguments.DATABASES) || cd.getLexemeIndex("--tables") > cd.getLexemeIndex(MysqldumpArguments.DATABASES);
    }

    private static class MysqldumpSkipOptBooleanArgument
    extends BooleanCliArgumentImpl {
        private final String[] myArgs;
        private final String[] mySkipOptions;

        MysqldumpSkipOptBooleanArgument(@NotNull String uiName, @NotNull String arg, @NotNull String skipOption) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            if (skipOption == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipOption", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            this(uiName, (String[])ContainerUtil.ar((Object[])new String[]{arg}), (String[])ContainerUtil.ar((Object[])new String[]{skipOption}));
        }

        MysqldumpSkipOptBooleanArgument(@NotNull String uiName, @NotNull String[] args, @NotNull String[] skipOptions) {
            if (uiName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            if (skipOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipOptions", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "<init>"));
            }
            super(uiName, true, ArrayUtil.mergeArrays((String[])args, (String[])skipOptions));
            this.myArgs = args;
            this.mySkipOptions = skipOptions;
        }

        @Override
        @NotNull
        public String getTurnedOffArgument() {
            String string = MysqldumpSkipOptBooleanArgument.getArgumentsOnTurnOff(this.mySkipOptions);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "getTurnedOffArgument"));
            }
            return string;
        }

        @Override
        public boolean getCurrentState(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "getCurrentState"));
            }
            return MysqldumpSkipOptBooleanArgument.isOn(this.myArgs, this.mySkipOptions, cd);
        }

        @Override
        public boolean getStateForReset(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "getStateForReset"));
            }
            return MysqldumpSkipOptBooleanArgument.isTextNotContainsSkipOpt(cd);
        }

        @Override
        public boolean isAppendInTheEnd(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isAppendInTheEnd"));
            }
            return MysqldumpSkipOptBooleanArgument.isAppendInTheEnd(cd, this.mySkipOptions);
        }

        @NotNull
        private static String getArgumentsOnTurnOff(String ... skipArgs) {
            if (skipArgs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "getArgumentsOnTurnOff"));
            }
            String string = DbCliUtil.extractNonParameterizable(skipArgs);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "getArgumentsOnTurnOff"));
            }
            return string;
        }

        private static boolean isTextNotContainsSkipOpt(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isTextNotContainsSkipOpt"));
            }
            return MysqldumpSkipOptBooleanArgument.isNotSkipOpt(cd) && !cd.isComponentChanged();
        }

        private static boolean isNotSkipOpt(@NotNull CliContextDescriptor cd) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isNotSkipOpt"));
            }
            return cd.getLexemeIndex("--skip-opt") <= cd.getLexemeIndex("--opt");
        }

        static boolean isAppendInTheEnd(@NotNull CliContextDescriptor cd, String ... skipArgs) {
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isAppendInTheEnd"));
            }
            if (skipArgs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isAppendInTheEnd"));
            }
            return cd.contains(skipArgs) || cd.contains("--skip-opt") || cd.contains("--opt");
        }

        static boolean isOn(@NotNull String[] args, @NotNull String[] skipArgs, @NotNull CliContextDescriptor cd) {
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isOn"));
            }
            if (skipArgs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skipArgs", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isOn"));
            }
            if (cd == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/mysql/MysqldumpCliArguments$MysqldumpSkipOptBooleanArgument", "isOn"));
            }
            int argsIdx = cd.getLexemeIndex(args);
            int skipOptIdx = cd.getLexemeIndex("--skip-opt");
            int optIdx = cd.getLexemeIndex("--opt");
            int skipIdx = cd.getLexemeIndex(skipArgs);
            return argsIdx > skipIdx && argsIdx > skipOptIdx || optIdx > skipIdx && optIdx > skipOptIdx;
        }
    }
}

