/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.dump.pg;

import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.SimpleCliDialogValidator;
import com.intellij.database.cli.argument.CliArgument;
import com.intellij.database.cli.argument.CommonPgArguments;
import com.intellij.database.cli.argument.CommonPgCliArguments;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PgDialogValidator
extends SimpleCliDialogValidator {
    private static final String INVALID_FILE = "Path must point on file";
    private static final String DATA_ONLY = "Options -c/--clean and -a/--data-only cannot be used together";
    private static final String IF_EXISTS = "Option --if-exists requires option -c/--clean";

    public PgDialogValidator() {
        super(CommonPgArguments.FILE, CommonPgArguments.PASSWORD);
    }

    protected PgDialogValidator(@NotNull String[] fileArgs) {
        if (fileArgs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileArgs", "com/intellij/database/cli/dump/pg/PgDialogValidator", "<init>"));
        }
        super(fileArgs, CommonPgArguments.PASSWORD);
    }

    @Override
    @Nullable
    public ValidationInfo createInfo(@NotNull CliModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/dump/pg/PgDialogValidator", "createInfo"));
        }
        ValidationInfo info = super.createInfo(model);
        return info == null ? this.createInfoInternal(model) : info;
    }

    @Nullable
    private ValidationInfo createInfoInternal(@NotNull CliModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/cli/dump/pg/PgDialogValidator", "createInfoInternal"));
        }
        CliArgument argument = this.getFormatArgument(model.getCliComponents());
        CliComponent pathComponent = this.getPathComponent(model.getCliComponents());
        if (this.checkFileError(pathComponent, argument)) {
            return new ValidationInfo(INVALID_FILE, ((CliComponent)ObjectUtils.assertNotNull((Object)pathComponent)).getComponent());
        }
        if (this.checkDirError(pathComponent, argument)) {
            return new ValidationInfo(this.getInvalidDirectoryError(), ((CliComponent)ObjectUtils.assertNotNull((Object)pathComponent)).getComponent());
        }
        CliContextDescriptor cd = model.getContext();
        return PgDialogValidator.checkDataOnly(cd) ? new ValidationInfo(DATA_ONLY, model.getCommandComponent()) : (PgDialogValidator.checkIfExists(cd) ? new ValidationInfo(IF_EXISTS, model.getCommandComponent()) : null);
    }

    @NotNull
    protected abstract String getInvalidDirectoryError();

    @NotNull
    protected List<CliArgument> getFileArgs() {
        List list = ContainerUtil.list((Object[])new CliArgument[]{CommonPgCliArguments.F_CUSTOM, CommonPgCliArguments.F_TAR});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/dump/pg/PgDialogValidator", "getFileArgs"));
        }
        return list;
    }

    protected boolean isDirectoryWrong(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/cli/dump/pg/PgDialogValidator", "isDirectoryWrong"));
        }
        return file.isFile();
    }

    @NotNull
    protected abstract StringCliArgument getPathArgument();

    private boolean checkDirError(@Nullable CliComponent component, @Nullable CliArgument argument) {
        String text = PgDialogValidator.getText(component);
        if (text == null) {
            return false;
        }
        File file = new File(text);
        return this.isDirectoryWrong(file) && argument == CommonPgCliArguments.F_DIRECTORY;
    }

    @Nullable
    private CliArgument getFormatArgument(@NotNull List<CliComponent> components) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/intellij/database/cli/dump/pg/PgDialogValidator", "getFormatArgument"));
        }
        Condition condition = component -> ContainerUtil.containsIdentity(this.getFileArgs(), (Object)component.getArgument()) || component.getArgument() == CommonPgCliArguments.F_DIRECTORY;
        CliComponent component2 = (CliComponent)ContainerUtil.find(components, (Condition)condition);
        return component2 == null ? null : component2.getArgument();
    }

    @Nullable
    private CliComponent getPathComponent(List<CliComponent> components) {
        return (CliComponent)ContainerUtil.find(components, component -> component.getArgument() == this.getPathArgument());
    }

    private boolean checkFileError(@Nullable CliComponent component, @Nullable CliArgument argument) {
        String text = PgDialogValidator.getText(component);
        if (text == null) {
            return false;
        }
        File file = new File(text);
        return file.isDirectory() && ContainerUtil.containsIdentity(this.getFileArgs(), (Object)argument);
    }

    @Nullable
    private static String getText(@Nullable CliComponent component) {
        if (component == null) {
            return null;
        }
        JComponent swingComponent = component.getComponent();
        if (!(swingComponent instanceof TextFieldWithBrowseButton)) {
            return null;
        }
        return ((TextFieldWithBrowseButton)swingComponent).getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDataOnly(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/pg/PgDialogValidator", "checkDataOnly"));
        }
        if (ContainerUtil.find((Object[])CommonPgArguments.DATA_ONLY, cd::contains) == null) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkIfExists(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/cli/dump/pg/PgDialogValidator", "checkIfExists"));
        }
        if (!cd.contains("--if-exists")) return false;
        if (ContainerUtil.find((Object[])CommonPgArguments.CLEAN_DATABASE, cd::contains) != null) return false;
        return true;
    }
}

