/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.cli.CliConfigurationPack;
import com.intellij.openapi.util.Condition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RestoreConfigurationsHolder {
    POSTGRES((Condition<DatabaseFamilyId>)((Condition)DatabaseFamilyId::isPostgres), CliConfigurationPack.PG_RESTORE),
    MYSQL((Condition<DatabaseFamilyId>)((Condition)DatabaseFamilyId::isMysql), CliConfigurationPack.MYSQL_RESTORE);

    private final Condition<DatabaseFamilyId> myCondition;
    private final CliConfigurationPack myPack;

    private RestoreConfigurationsHolder(Condition<DatabaseFamilyId> condition, CliConfigurationPack pack) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/cli/restore/RestoreConfigurationsHolder", "<init>"));
        }
        if (pack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pack", "com/intellij/database/cli/restore/RestoreConfigurationsHolder", "<init>"));
        }
        this.myCondition = condition;
        this.myPack = pack;
    }

    @Nullable
    public static CliConfigurationPack of(@NotNull DatabaseFamilyId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/cli/restore/RestoreConfigurationsHolder", "of"));
        }
        for (RestoreConfigurationsHolder factory : RestoreConfigurationsHolder.values()) {
            if (!factory.myCondition.value((Object)id)) continue;
            return factory.myPack;
        }
        return null;
    }
}

