/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.restore.pg;

import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.CliPathTextField;
import com.intellij.database.cli.dump.pg.PgDialogValidator;
import com.intellij.database.cli.restore.pg.PgRestoreCliArguments;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgRestoreDialogValidator
extends PgDialogValidator {
    public PgRestoreDialogValidator() {
        super(ArrayUtil.EMPTY_STRING_ARRAY);
    }

    @Override
    protected boolean checkFilePath(@NotNull CliModel settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/cli/restore/pg/PgRestoreDialogValidator", "checkFilePath"));
        }
        return settings.getContext().getNoNamedCount() >= 1L;
    }

    @Override
    @Nullable
    protected JComponent findPathComponent(@NotNull CliModel settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/cli/restore/pg/PgRestoreDialogValidator", "findPathComponent"));
        }
        List<CliComponent> components = settings.getCliComponents();
        return Optional.ofNullable(JBIterable.of(components).filter(CliPathTextField.class).first()).map(CliComponent::getComponent).orElse(null);
    }

    @Override
    @NotNull
    protected StringCliArgument getPathArgument() {
        StringCliArgument stringCliArgument = PgRestoreCliArguments.PATH;
        if (stringCliArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreDialogValidator", "getPathArgument"));
        }
        return stringCliArgument;
    }

    @Override
    protected boolean isDirectoryWrong(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/cli/restore/pg/PgRestoreDialogValidator", "isDirectoryWrong"));
        }
        return super.isDirectoryWrong(file) || !file.exists();
    }

    @Override
    @NotNull
    protected String getInvalidDirectoryError() {
        if ("Path must point to an existing directory" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/cli/restore/pg/PgRestoreDialogValidator", "getInvalidDirectoryError"));
        }
        return "Path must point to an existing directory";
    }
}

