/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseTableFileEditor;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.TooLongStatementException;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunSqlScriptAction
extends DumbAwareAction {
    private static final int BATCH_MAX_SIZE = 1000;
    private static final int BATCH_MAX_LENGTH = 512000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "update"));
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean enabled = !((List)RunSqlScriptAction.getDataSources((Project)project, (JBIterable<VirtualFile>)files).second).isEmpty();
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(true);
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        e.getPresentation().setText(String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20))));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction", "actionPerformed"));
        }
        Project project = e.getProject();
        JBIterable files = JBIterable.of((Object[])((Object[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY))).filter(DbSqlUtil.SQL_FILE_FILTER(project));
        if (project == null || e.getData(PlatformDataKeys.FILE_EDITOR) instanceof DatabaseTableFileEditor || files.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String title = files.size() == 1 ? ((VirtualFile)files.iterator().next()).getName() : files.size() + " files";
        String taskName = String.format("Run '%s'... ", StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)title, (int)20)));
        Couple<List<DbDataSource>> dataSources = RunSqlScriptAction.getDataSources(project, (JBIterable<VirtualFile>)files);
        RunSqlScriptAction.chooseDataSourceAndRun(project, e.getDataContext(), (List)dataSources.first, (List)dataSources.second, (Processor<List<LocalDataSource>>)((Processor)selectedDataSources -> {
            RunSqlScriptAction.perform(project, taskName, (JBIterable<VirtualFile>)files, selectedDataSources);
            return true;
        }));
    }

    private static Couple<List<DbDataSource>> getDataSources(@NotNull Project project, @NotNull JBIterable<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "getDataSources"));
        }
        List allDataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)project).getDataSources()).filter(DbImplUtil.CAN_CONNECT_TO).toList();
        if (allDataSources.isEmpty()) {
            return Couple.of(Collections.emptyList(), Collections.emptyList());
        }
        boolean first = true;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList dataSources = ContainerUtil.newArrayList();
        for (VirtualFile file : files) {
            boolean isDbFile = DbImplUtil.isDatabaseVirtualFile(file);
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile == null) continue;
            JBIterable<DbDataSource> o = DbImplUtil.getDataSourcesForExec(psiFile, !isDbFile, isDbFile);
            if (first) {
                o.addAllTo((Collection)dataSources);
            } else {
                dataSources.retainAll(o.toList());
            }
            first = false;
        }
        return Couple.of((Object)dataSources, (Object)allDataSources);
    }

    public static void perform(final @NotNull Project project, @NotNull String taskName, final @NotNull JBIterable<VirtualFile> files, final @NotNull List<LocalDataSource> dataSources) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        if (dataSources == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/console/RunSqlScriptAction", "perform"));
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        final SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
        SqlLanguageDialect preferredDialect = DbSqlUtil.getSqlDialect(dataSources.get(0));
        SqlLanguageDialect genericDialect = DbSqlUtil.getGenericDialect();
        List remapDialect = files.filter(file -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$1"));
            }
            return LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) != preferredDialect;
        }).toList();
        if (!remapDialect.isEmpty() && preferredDialect != genericDialect) {
            WriteAction.run(() -> {
                for (VirtualFile file : remapDialect) {
                    sqlPsiFacade.setDialectMapping(file, preferredDialect);
                }
            });
        }
        final Ref reporter = Ref.create(null);
        final AtomicReference<ProgressIndicator> indicatorRef = new AtomicReference<ProgressIndicator>();
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (taskName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            if (dataSources == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSources", "com/intellij/database/console/RunSqlScriptAction", "lambda$perform$3"));
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, taskName, true, null){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$1", "run"));
                    }
                    List models = (List)ReadAction.compute(() -> {
                        if (files == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$run$2"));
                        }
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$run$2"));
                        }
                        return files.map(file -> {
                            if (project == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$1", "lambda$null$0"));
                            }
                            return PsiManager.getInstance((Project)project).findFile(file);
                        }).filter(Conditions.notNull()).map(file -> sqlPsiFacade.createScriptModel(file)).toList();
                    });
                    indicatorRef.set(indicator);
                    indicator.setFraction(0.0);
                    indicator.setIndeterminate(false);
                    for (ScriptModel scriptModel : models) {
                        VirtualFile virtualFile = scriptModel.getVirtualFile();
                        String title = "Run " + virtualFile.getPresentableUrl();
                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), MessageType.INFO, title);
                        try {
                            this.runImpl(scriptModel, indicator, models.size());
                        }
                        finally {
                            Disposer.dispose((Disposable)scriptModel);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void runImpl(@NotNull ScriptModel<?> scriptModel, @NotNull ProgressIndicator indicator, int progressMultiplier) {
                    if (scriptModel == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptModel", "com/intellij/database/console/RunSqlScriptAction$1", "runImpl"));
                    }
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/console/RunSqlScriptAction$1", "runImpl"));
                    }
                    long total = -1L;
                    long chars = -1L;
                    long executed = 0L;
                    long failed = 0L;
                    boolean aborted = false;
                    long t0 = System.currentTimeMillis();
                    for (LocalDataSource dataSource : dataSources) {
                        long t1;
                        Ref doneAnything;
                        long[] counter;
                        block12: {
                            counter = new long[]{0L, 0L, 0L};
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), MessageType.INFO, "Connecting to " + dataSource.getName() + "...");
                            doneAnything = Ref.create();
                            t1 = System.currentTimeMillis();
                            try {
                                RunSqlScriptAction.runStatements(project, dataSource, scriptModel, (DataAuditor.PrintingAdapter)reporter.get(), indicator, counter, progressMultiplier * dataSources.size(), (Ref<Boolean>)doneAnything);
                                if (total < 0L) {
                                    total = counter[0];
                                }
                                if (chars >= 0L) break block12;
                                chars = counter[2];
                            }
                            catch (ProcessCanceledException e) {
                                try {
                                    aborted = true;
                                }
                                catch (Throwable throwable) {
                                    executed += counter[0];
                                    failed += counter[1];
                                    if (dataSources.size() > 1) {
                                        long t2 = System.currentTimeMillis() - t1;
                                        MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                                        RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                                    }
                                    if (Boolean.TRUE.equals(doneAnything.get())) {
                                        DbElement element = RunSqlScriptAction.getTargetElement(project, scriptModel.getVirtualFile());
                                        DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, ObjectPath.of((DasObject)element)));
                                    }
                                    throw throwable;
                                }
                                executed += counter[0];
                                failed += counter[1];
                                if (dataSources.size() > 1) {
                                    long t2 = System.currentTimeMillis() - t1;
                                    MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                                    RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                                }
                                if (!Boolean.TRUE.equals(doneAnything.get())) break;
                                DbElement element = RunSqlScriptAction.getTargetElement(project, scriptModel.getVirtualFile());
                                DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, ObjectPath.of((DasObject)element)));
                                break;
                            }
                        }
                        executed += counter[0];
                        failed += counter[1];
                        if (dataSources.size() > 1) {
                            long t2 = System.currentTimeMillis() - t1;
                            MessageType messageType = counter[1] > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                            RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, dataSource.getName() + ": " + counter[0] + (total < 0L ? "" : " of " + total) + " statements executed" + (counter[1] > 0L ? ", " + counter[1] + " failed" : "") + " in " + StringUtil.formatDuration((long)t2) + (aborted ? " (aborted!)" : ""));
                        }
                        if (!Boolean.TRUE.equals(doneAnything.get())) continue;
                        DbElement element = RunSqlScriptAction.getTargetElement(project, scriptModel.getVirtualFile());
                        DataSourceUiUtil.performAutoSyncTask(DataSourceUiUtil.getConnectionContext(this.getProject(), dataSource, ObjectPath.of((DasObject)element)));
                    }
                    long t3 = System.currentTimeMillis() - t0;
                    MessageType messageType = failed > 0L ? MessageType.ERROR : (aborted ? MessageType.WARNING : MessageType.INFO);
                    RunSqlScriptAction.reportAndLog(project, (DataAuditor.PrintingAdapter)reporter.get(), messageType, "Summary: " + executed + (total < 0L ? "" : " of " + total * (long)dataSources.size()) + " statements executed" + (failed > 0L ? ", " + failed + " failed" : "") + " in " + StringUtil.formatDuration((long)t3) + (chars < 0L ? "" : " (" + chars + " symbols in file)") + (aborted ? " (aborted!)" : ""));
                }
            });
        };
        ConsoleView consoleView = RunSqlScriptAction.addConsole(project, taskName, files, runnable, indicatorRef);
        reporter.set((Object)new DataAuditor.ConsoleLogger(consoleView));
        runnable.run();
    }

    @Nullable
    private static DbElement getTargetElement(@NotNull Project project, VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "getTargetElement"));
        }
        return DbImplUtil.findElement(project, file);
    }

    private static void reportAndLog(@NotNull Project project, @NotNull DataAuditor.PrintingAdapter logger, @NotNull MessageType messageType, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "reportAndLog"));
        }
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/database/console/RunSqlScriptAction", "reportAndLog"));
        }
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/database/console/RunSqlScriptAction", "reportAndLog"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/console/RunSqlScriptAction", "reportAndLog"));
        }
        DatabaseNotifications.DATABASE_EXECUTION_GROUP.createNotification(message, messageType).notify(project);
        ConsoleViewContentType contentType = messageType == MessageType.ERROR ? ConsoleViewContentType.ERROR_OUTPUT : (messageType == MessageType.WARNING ? ConsoleViewContentType.LOG_WARNING_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
        logger.println(message, contentType);
    }

    @NotNull
    private static ConsoleView addConsole(@NotNull Project project, @NotNull String taskName, @NotNull JBIterable<VirtualFile> files, @NotNull Runnable rerunRunnable, @NotNull AtomicReference<ProgressIndicator> indicatorRef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        if (rerunRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rerunRunnable", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        if (indicatorRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicatorRef", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        ConsoleView consoleView = DbUIUtil.addConsole(project, taskName, () -> {
            if (files == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/database/console/RunSqlScriptAction", "lambda$addConsole$4"));
            }
            for (VirtualFile file : files) {
                if (file.isValid()) continue;
                return false;
            }
            return true;
        }, rerunRunnable, indicatorRef);
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/RunSqlScriptAction", "addConsole"));
        }
        return consoleView;
    }

    public static void runStatements(Project project, LocalDataSource dataSource, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter) {
        RunSqlScriptAction.runStatements(project, dataSource, scriptModel, reporter, (ProgressIndicator)new EmptyProgressIndicator(), new long[3], 1, null);
    }

    private static void runStatements(Project project, LocalDataSource dataSource, ScriptModel<?> scriptModel, DataAuditor.PrintingAdapter reporter, ProgressIndicator progress, long[] counter, int progressMultiplier, Ref<Boolean> doneAnything) {
        Runner r = new Runner(project, dataSource, scriptModel.getVirtualFile(), reporter);
        r.withConnected(() -> {
            try {
                r.prepare();
                progress.checkCanceled();
                progress.setText(dataSource.getName());
                if (r.connection == null) {
                    reporter.error("Unable to acquire connection", null);
                    return;
                }
                counter[2] = 0L;
                boolean inBatch = false;
                TokenSet dmlSet = TokenSet.create((IElementType[])new IElementType[]{SqlTokenRegistry.findCompositeType((String)"SQL_INSERT_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_UPDATE_STATEMENT"), SqlTokenRegistry.findCompositeType((String)"SQL_DELETE_STATEMENT")});
                Condition notDml = o -> !dmlSet.contains(o.type());
                for (JBIterable itGroup : scriptModel.statements().split(JBIterable.Split.GROUP, notDml)) {
                    if (doneAnything != null) {
                        doneAnything.set((Object)true);
                    }
                    double fraction = -1.0;
                    if (inBatch) {
                        reporter.print("");
                    }
                    inBatch = false;
                    for (ScriptModel.StatementIt it : itGroup) {
                        progress.checkCanceled();
                        String sql = it.text();
                        if (!inBatch) {
                            reporter.println(StringUtil.first((String)sql, (int)240, (boolean)true), ConsoleViewContentType.USER_INPUT);
                            progress.setText2(StringUtil.first((String)sql, (int)120, (boolean)true));
                        }
                        counter[0] = counter[0] + 1L;
                        counter[2] = counter[2] + (long)sql.length();
                        long curOffset = it.rangeOffset() + (long)it.range().getEndOffset();
                        fraction = (double)curOffset * r.averageBytesPerChar / (double)r.fileSize / (double)progressMultiplier;
                        if (!r.batchUpdatesSupported || notDml.value((Object)it)) {
                            r.runSingle(sql);
                            progress.setFraction(fraction);
                        } else {
                            if (r.batchCount % 10L == 1L) {
                                reporter.rawPrint(".", ConsoleViewContentType.USER_INPUT);
                            }
                            inBatch = true;
                            r.addBatch(sql);
                            if (r.batchCount >= 1000L || r.batchLength >= 512000L) {
                                reporter.print("");
                                r.runBatch();
                                progress.setFraction(fraction);
                            }
                        }
                        counter[1] = counter[1] + r.getAndResetFailCount();
                    }
                    if (inBatch) {
                        reporter.print("");
                        r.runBatch();
                        progress.setFraction(fraction);
                    }
                    counter[1] = counter[1] + r.getAndResetFailCount();
                }
            }
            catch (TooLongStatementException e) {
                reporter.error(e.getMessage() + ". Increasing memory via -Xmx may help. Aborting.", null);
            }
            finally {
                counter[1] = counter[1] + r.getAndResetFailCount();
                Disposer.dispose((Disposable)scriptModel);
            }
        });
    }

    private static void chooseDataSourceAndRun(Project project, DataContext context, List<DbDataSource> dataSources, List<DbDataSource> allDataSources, Processor<List<LocalDataSource>> processor) {
        ArrayList sorted = ContainerUtil.newArrayList(dataSources);
        Collections.sort(sorted, Comparator.comparing(DasObject::getName));
        if (dataSources.size() < allDataSources.size()) {
            sorted.add(null);
        }
        JBList list = new JBList((ListModel)new CollectionListModel((List)sorted));
        DatabaseColorManager.LocalColors state = (DatabaseColorManager.LocalColors)DatabaseColorManager.getLocalColorManager(project).getState();
        final boolean useColors = state.useColors && state.inDatabaseView;
        list.setVisibleRowCount(10);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<DbDataSource>(){

            protected void customizeCellRenderer(@NotNull JList list, DbDataSource dataSource, int index, boolean selected, boolean hasFocus) {
                Color bg;
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/console/RunSqlScriptAction$2", "customizeCellRenderer"));
                }
                if (dataSource == null) {
                    this.append("Other\u2026");
                    return;
                }
                this.setIcon(dataSource.getIcon());
                this.append(dataSource.getName(), DbImplUtil.isConnected((DbElement)dataSource) ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                Color color = bg = !selected && useColors ? DatabaseColorManager.getColor((DbElement)dataSource) : null;
                if (bg != null) {
                    this.setBackground(bg);
                }
            }
        });
        final Consumer otherHandler = event -> {
            if (!JBIterable.from((Iterable)list.getSelectedValuesList()).contains(null)) {
                return;
            }
            event.consume();
            ((FilteringListModel)list.getModel()).replaceAll(allDataSources);
            list.setSelectedIndex(0);
            JBPopup popup = PopupUtil.getPopupContainerFor((Component)list);
            if (popup != null) {
                popup.pack(false, true);
            }
        };
        list.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$3", "keyPressed"));
                }
                if (e.getKeyCode() == 10) {
                    otherHandler.consume((Object)e);
                }
            }
        });
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/console/RunSqlScriptAction$4", "onClick"));
                }
                otherHandler.consume((Object)e);
                return e.isConsumed();
            }
        }.installOn((Component)list);
        new PopupChooserBuilder((JList)list).setTitle("Choose Data Source").setMovable(true).setResizable(true).setItemChoosenCallback(() -> {
            JBIterable selection = JBIterable.from((Iterable)list.getSelectedValuesList());
            if (selection.contains(null)) {
                return;
            }
            processor.process((Object)selection.transform(o -> (LocalDataSource)o.getDelegate()).toList());
        }).setFilteringEnabled(o -> o == null ? "" : ((DasObject)o).getName()).createPopup().showInBestPositionFor(context);
    }

    private static class Runner {
        final Project project;
        final LocalDataSource dataSource;
        final DbElement destination;
        final DataAuditor.PrintingAdapter reporter;
        final SqlLanguageDialect dialect;
        long fileSize;
        double averageBytesPerChar;
        boolean batchUpdatesSupported;
        DatabaseConnection connection;
        Statement statement;
        long failCount;
        long batchCount;
        long batchLength;

        Runner(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull VirtualFile virtualFile, DataAuditor.PrintingAdapter reporter) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/RunSqlScriptAction$Runner", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/RunSqlScriptAction$Runner", "<init>"));
            }
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/console/RunSqlScriptAction$Runner", "<init>"));
            }
            this.fileSize = 1L;
            this.averageBytesPerChar = 1.0;
            this.project = project;
            this.dataSource = dataSource;
            this.destination = RunSqlScriptAction.getTargetElement(project, virtualFile);
            this.reporter = reporter;
            this.dialect = DbSqlUtil.getSqlDialect(dataSource);
            this.fileSize = virtualFile.getLength();
            this.averageBytesPerChar = virtualFile.getCharset().newEncoder().averageBytesPerChar();
        }

        long getAndResetFailCount() {
            long result2 = this.failCount;
            this.failCount = 0L;
            return result2;
        }

        void prepare() {
            try {
                if (!this.dialect.getDatabaseDialect().getFamilyId().isTransactSql()) {
                    DatabaseMetaData metaData = this.connection.getMetaData();
                    this.batchUpdatesSupported = metaData.supportsBatchUpdates();
                    if (this.batchUpdatesSupported) {
                        this.reporter.print("Using batch mode (1000 insert/update/delete statements max)");
                    }
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
            }
            if (this.destination != null) {
                DatabaseEditorHelper.setCurrentSchemaSafe(this.destination, this.connection);
            }
        }

        public void withConnected(@NotNull Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/RunSqlScriptAction$Runner", "withConnected"));
            }
            ErrorHandler handler = new ErrorHandler();
            try {
                DatabaseConnectionManager.getInstance().build(this.project, this.dataSource).setDestination(ObjectPath.of((DasObject)this.destination)).sync(connection -> {
                    if (r == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/console/RunSqlScriptAction$Runner", "lambda$withConnected$0"));
                    }
                    try {
                        this.connection = connection;
                        this.statement = connection.createStatement();
                        r.run();
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        this.connection = null;
                        if (this.statement != null) {
                            JdbcUtil.closeStatementSafe((Statement)this.statement);
                        }
                    }
                }, handler);
            }
            catch (ProcessCanceledException e) {
                if (handler.hasErrors()) {
                    this.reporter.error(handler.getSummary(), null);
                }
                throw e;
            }
            catch (Exception e) {
                this.reporter.error(null, e);
            }
        }

        public void runSingle(String sql) {
            try {
                int updateCount;
                long updateTotal = -1L;
                long timestamp = System.currentTimeMillis();
                boolean resultSetHere = this.statement.execute(sql);
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                int n = updateCount = resultSetHere ? -1 : JdbcEngine.getUpdateCountSafe(this.statement);
                do {
                    if (updateCount >= 0) {
                        if (updateTotal < 0L) {
                            updateTotal = 0L;
                        }
                        updateTotal += (long)updateCount;
                    }
                    int n2 = updateCount = (resultSetHere = this.statement.getMoreResults()) ? -1 : JdbcEngine.getUpdateCountSafe(this.statement);
                } while (resultSetHere || updateCount != -1);
                if (updateTotal >= 0L) {
                    this.reporter.print(updateTotal + " row(s) affected in " + executionTime);
                } else {
                    this.reporter.print("completed in " + executionTime);
                }
            }
            catch (Exception ex) {
                ++this.failCount;
                if (DbImplUtil.isRemoteProcessDown(ex)) {
                    this.reporter.error("Connection is closed", null);
                    throw new ProcessCanceledException();
                }
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
            }
        }

        public void addBatch(String sql) {
            if (!this.batchUpdatesSupported) {
                this.runSingle(sql);
                return;
            }
            try {
                this.statement.addBatch(sql);
                ++this.batchCount;
                this.batchLength += (long)sql.length();
            }
            catch (SQLException e) {
                this.batchUpdatesSupported = false;
                if (this.batchCount > 0L) {
                    this.runBatch();
                }
                this.runSingle(sql);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runBatch() {
            if (!this.batchUpdatesSupported) {
                return;
            }
            if (this.batchCount == 0L) {
                return;
            }
            try {
                int[] longs;
                long updateCount = 0L;
                long timestamp = System.currentTimeMillis();
                int[] nArray = longs = this.statement.executeBatch();
                int n = nArray.length;
                for (int j = 0; j < n; ++j) {
                    long c = nArray[j];
                    if (c >= 0L) {
                        updateCount += c;
                        continue;
                    }
                    if (c != -3L) continue;
                    ++this.failCount;
                }
                String executionTime = StringUtil.formatDuration((long)(System.currentTimeMillis() - timestamp));
                if (updateCount == 0L) {
                    this.reporter.print("completed in " + executionTime);
                } else {
                    this.reporter.print(updateCount + " row(s) affected in " + executionTime);
                }
            }
            catch (Exception ex) {
                this.reporter.error(JdbcEngine.getErrorMessage(ex, this.dataSource.getName(), DatabaseFamilyId.forDataSource((DatabaseSystem)this.dataSource)), null);
                this.failCount += this.batchCount;
            }
            finally {
                this.batchCount = 0L;
                this.batchLength = 0L;
            }
        }
    }
}

