/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableResult
implements DatabaseExpressionEvaluator.Result {
    private static final int MAX = 120;
    final ObjectFormatter myFormatter;
    final EvaluationResultFetcher myFetcher;
    final DatabaseDialectEx myDialect;
    private MyRootNodeUpdater myUpdater;
    private int myLastShown;
    EvaluationColumnsPresentation myPresentation;

    private AbstractTableResult(@NotNull DatabaseDialectEx dialect, @NotNull EvaluationResultFetcher fetcher) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult", "<init>"));
        }
        if (fetcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetcher", "com/intellij/database/console/evaluation/AbstractTableResult", "<init>"));
        }
        this.myDialect = dialect;
        this.myFetcher = fetcher;
        this.myFormatter = new ObjectFormatter();
    }

    void init() {
        this.myPresentation = this.createColumnsPresentation();
        this.myUpdater = this.createRootNodeUpdater();
    }

    @Override
    @NotNull
    public String representation() {
        this.myFetcher.fetchCached();
        StringBuilder sb = new StringBuilder();
        List<DataConsumer.Column> columns2 = this.myFetcher.getColumns();
        for (int i2 = 0; i2 < columns2.size(); ++i2) {
            DataConsumer.Column column = columns2.get(i2);
            sb.append(column.name).append(i2 < columns2.size() - 1 ? "\t" : "");
        }
        sb.append("\n");
        List<DataConsumer.Row> rows = this.myFetcher.getRows();
        for (DataConsumer.Row row : rows) {
            for (int i3 = 0; i3 < columns2.size(); ++i3) {
                DataConsumer.Column column = columns2.get(i3);
                sb.append(AbstractTableResult.notNullValue(this.myFormatter, column, this.myDialect, column.getValue(row), false)).append(i3 < columns2.size() - 1 ? "\t" : "");
            }
            sb.append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "representation"));
        }
        return string;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult", "computePresentation"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult", "computePresentation"));
        }
        this.myUpdater.update((Obsolescent)node, place, this.getResultName(), this.getResultSeparator());
    }

    @Override
    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult", "computeChildren"));
        }
        XValueChildrenList columns2 = this.columns();
        if (columns2.size() != 0) {
            node.addChildren(columns2, false);
        }
        String name = this.getResultName();
        String separator = this.getResultSeparator();
        if (this.myFetcher.isBusy()) {
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name, separator);
            return;
        }
        this.myFetcher.fetch(() -> {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult", "lambda$computeChildren$0"));
            }
            node.addChildren(this.rows(), true);
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name, separator);
        });
    }

    @NotNull
    protected abstract String getResultSeparator();

    @NotNull
    protected abstract String getResultName();

    @NotNull
    EvaluationColumnsPresentation createColumnsPresentation() {
        EvaluationColumnsPresentation evaluationColumnsPresentation = new EvaluationColumnsPresentation(this.myDialect);
        if (evaluationColumnsPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "createColumnsPresentation"));
        }
        return evaluationColumnsPresentation;
    }

    @NotNull
    MyRootNodeUpdater createRootNodeUpdater() {
        MyRootNodeUpdater myRootNodeUpdater = new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDialect);
        if (myRootNodeUpdater == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "createRootNodeUpdater"));
        }
        return myRootNodeUpdater;
    }

    @NotNull
    private XValueChildrenList rows() {
        XValueChildrenList list = new XValueChildrenList();
        List<DataConsumer.Row> rows = this.myFetcher.getRows();
        for (int i2 = this.myLastShown; i2 < rows.size(); ++i2) {
            final DataConsumer.Row row = rows.get(i2);
            list.add(new XNamedValue(String.valueOf(i2 + 1)){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$1", "computePresentation"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$1", "computePresentation"));
                    }
                    Function converter = c -> AbstractTableResult.cut(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, c, AbstractTableResult.this.myDialect, c.getValue(row), true));
                    String type = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), (Function)converter, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", AbstractTableResult.cut(type), " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$1", "computeChildren"));
                    }
                    node.addChildren(AbstractTableResult.this.rowValuesList(row), true);
                }
            });
        }
        this.myLastShown = rows.size();
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "rows"));
        }
        return xValueChildrenList;
    }

    private boolean hasChildren() {
        return !this.myFetcher.getColumns().isEmpty();
    }

    @NotNull
    private XValueChildrenList rowValuesList(@NotNull DataConsumer.Row row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/console/evaluation/AbstractTableResult", "rowValuesList"));
        }
        XValueChildrenList rowChildren = new XValueChildrenList();
        for (final DataConsumer.Column column : this.myFetcher.getColumns()) {
            final Object value = column.getValue(row);
            final String originalValue = AbstractTableResult.notNullValue(this.myFormatter, column, this.myDialect, value, true);
            final String stringValue = AbstractTableResult.cut(originalValue);
            rowChildren.add(new XNamedValue(column.name){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$2", "computePresentation"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$2", "computePresentation"));
                    }
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation(stringValue, AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).typeName), false);
                    if (!AbstractTableResult.this.setImageEvaluator(node, value) && stringValue.length() < originalValue.length()) {
                        node.setFullValueEvaluator(new XFullValueEvaluator(){

                            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                if (callback == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$2$1", "startEvaluation"));
                                }
                                callback.evaluated(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, column, AbstractTableResult.this.myDialect, value, true, false));
                            }
                        });
                    }
                }
            });
        }
        XValueChildrenList xValueChildrenList = rowChildren;
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "rowValuesList"));
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columns() {
        XValueChildrenList list = new XValueChildrenList();
        if (this.myFetcher.getRows().size() == 0) {
            list.add(new XNamedValue("columns"){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$3", "computePresentation"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$3", "computePresentation"));
                    }
                    String columns2 = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), ColumnDescriptor::getName, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", columns2, " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$3", "computeChildren"));
                    }
                    node.addChildren(AbstractTableResult.this.columnsList(), true);
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "columns"));
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columnsList() {
        XValueChildrenList list = new XValueChildrenList();
        for (final DataConsumer.Column column : this.myFetcher.getColumns()) {
            list.add(new XNamedValue(column.name){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$4", "computePresentation"));
                    }
                    if (place == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$4", "computePresentation"));
                    }
                    XRegularValuePresentation presentation = new XRegularValuePresentation("", AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).typeName, " ");
                    node.setPresentation(AbstractTableResult.this.myPresentation.compute((DataConsumer.Column)column).icon, (XValuePresentation)presentation, false);
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "columnsList"));
        }
        return xValueChildrenList;
    }

    private boolean setImageEvaluator(@NotNull XValueNode node, @Nullable Object value) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult", "setImageEvaluator"));
        }
        if (!(value instanceof ObjectFormatter.ImageInfo)) {
            return false;
        }
        ObjectFormatter.ImageInfo info = (ObjectFormatter.ImageInfo)value;
        final BufferedImage image = info.createImage();
        if (image == null) {
            return false;
        }
        XFullValueEvaluator evaluator = new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$5", "startEvaluation"));
                }
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$5", "lambda$startEvaluation$0"));
                    }
                    if (callback.isObsolete()) {
                        return;
                    }
                    ImageEditorUI ui = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
                    JBPopup popup = DebuggerUIUtil.createValuePopup((Project)AbstractTableResult.this.myFetcher.getProject(), (JComponent)ui, null);
                    JFrame frame = (JFrame)ObjectUtils.notNull((Object)WindowManager.getInstance().getFrame(AbstractTableResult.this.myFetcher.getProject()));
                    Dimension frameSize = frame.getSize();
                    Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
                    popup.setSize(size);
                    callback.evaluated("");
                    popup.show(new RelativePoint((Component)frame, new Point(size.width / 2, size.height / 2)));
                });
            }
        };
        evaluator.setShowValuePopup(false);
        node.setFullValueEvaluator(evaluator);
        return true;
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialectEx dialect, @Nullable Object value, boolean quoteIfEmpty) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        String string = AbstractTableResult.notNullValue(formatter, column, dialect, value, quoteIfEmpty, true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        return string;
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull DataConsumer.Column column, @NotNull DatabaseDialectEx dialect, @Nullable Object value, boolean quoteIfEmpty, boolean forDisplay) {
        if (formatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        String result2 = StringUtil.notNullize((String)formatter.objectToString(value, column, dialect, forDisplay), (String)"null");
        String string = quoteIfEmpty && StringUtil.isEmptyOrSpaces((String)result2) ? StringUtil.wrapWithDoubleQuote((String)result2) : result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "notNullValue"));
        }
        return string;
    }

    @NotNull
    public static String cut(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/database/console/evaluation/AbstractTableResult", "cut"));
        }
        String string = StringUtil.shortenTextWithEllipsis((String)s, (int)120, (int)0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult", "cut"));
        }
        return string;
    }

    private static class EvaluationColumnsPresentation {
        private final Map<DataConsumer.Column, Presentation> myMap;
        private final DatabaseDialectEx myDialect;

        EvaluationColumnsPresentation(@NotNull DatabaseDialectEx dialect) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation", "<init>"));
            }
            this.myDialect = dialect;
            this.myMap = ContainerUtil.newHashMap();
        }

        @NotNull
        final Presentation compute(@NotNull DataConsumer.Column column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation", "compute"));
            }
            Presentation presentation = this.myMap.computeIfAbsent(column, c -> this.computeInner((DataConsumer.Column)c));
            if (presentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation", "compute"));
            }
            return presentation;
        }

        @NotNull
        Presentation computeInner(@NotNull DataConsumer.Column column) {
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation", "computeInner"));
            }
            Domain domain = DomainRegistry.getDomain(this.myDialect, null, column, false);
            String typeName = domain == null ? column.typeName : domain.name();
            Presentation presentation = new Presentation(DatabaseIcons.Col, typeName);
            if (presentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation", "computeInner"));
            }
            return presentation;
        }

        private static class Presentation {
            public final Icon icon;
            public final String typeName;

            Presentation(@NotNull Icon icon, @NotNull String typeName) {
                if (icon == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$Presentation", "<init>"));
                }
                if (typeName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$Presentation", "<init>"));
                }
                this.icon = icon;
                this.typeName = typeName;
            }
        }

        private static class DasPresentation
        extends EvaluationColumnsPresentation {
            private final DasTable myTable;

            DasPresentation(@NotNull DatabaseDialectEx dialect, @NotNull DasTable table) {
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation", "<init>"));
                }
                if (table == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation", "<init>"));
                }
                super(dialect);
                this.myTable = table;
            }

            @Override
            @NotNull
            Presentation computeInner(@NotNull DataConsumer.Column column) {
                if (column == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation", "computeInner"));
                }
                JBIterable children = this.myTable.getDbChildren(DasColumn.class, ObjectKind.COLUMN);
                for (DasColumn child : children) {
                    if (!StringUtil.equals((CharSequence)child.getName(), (CharSequence)column.name)) continue;
                    Presentation presentation = new Presentation((Icon)ObjectUtils.notNull((Object)DbPresentation.getIcon((DasObject)child), (Object)DatabaseIcons.Col), child.getDataType().getSpecification());
                    if (presentation == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation", "computeInner"));
                    }
                    return presentation;
                }
                Presentation presentation = super.computeInner(column);
                if (presentation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation", "computeInner"));
                }
                return presentation;
            }
        }
    }

    private static class MyPresentation
    extends XRegularValuePresentation {
        private final int myRowCount;

        MyPresentation(@NotNull String name, @NotNull String separator, int count) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyPresentation", "<init>"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyPresentation", "<init>"));
            }
            super(name, null, separator);
            this.myRowCount = count;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/console/evaluation/AbstractTableResult$MyPresentation", "renderValue"));
            }
            super.renderValue(renderer);
            String text = String.format(" (%s %s)", this.myRowCount, StringUtil.pluralize((String)"row", (int)this.myRowCount));
            renderer.renderComment(text);
        }
    }

    private static class MyRootNodeUpdater {
        private final EvaluationResultFetcher myFetcher;
        private final EvaluationColumnsPresentation myPresentation;
        private final ObjectFormatter myFormatter;
        private final DatabaseDialectEx myDialect;

        private MyRootNodeUpdater(@NotNull EvaluationResultFetcher fetcher, @NotNull EvaluationColumnsPresentation presentation, @NotNull ObjectFormatter formatter, @NotNull DatabaseDialectEx dialect) {
            if (fetcher == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetcher", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "<init>"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "<init>"));
            }
            if (formatter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "<init>"));
            }
            this.myFetcher = fetcher;
            this.myPresentation = presentation;
            this.myFormatter = formatter;
            this.myDialect = dialect;
        }

        @NotNull
        public XRegularValuePresentation createRegularPresentation(@NotNull String name, @NotNull String separator) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "createRegularPresentation"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "createRegularPresentation"));
            }
            MyPresentation myPresentation = this.myFetcher.isRowCountPrecise() ? new MyPresentation(name, separator, this.myFetcher.getRowCount()) : new XRegularValuePresentation(name, null, separator);
            if (myPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "createRegularPresentation"));
            }
            return myPresentation;
        }

        void update(@NotNull Obsolescent node, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "update"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "update"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "update"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "update"));
            }
            if (this.isSingleValue()) {
                this.updateSingleValue((XValueNode)node);
                return;
            }
            ObjectUtils.consumeIfCast((Object)node, XValueNode.class, n -> {
                if (place == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "lambda$update$0"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "lambda$update$0"));
                }
                if (separator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "lambda$update$0"));
                }
                this.updateEvaluator((XValueNode)n, place, name, separator);
                this.updatePresentation((XValueNode)n, place, name, separator);
            });
            if (!this.isTree(place) || !this.myFetcher.canFetch()) {
                return;
            }
            ObjectUtils.consumeIfCast((Object)node, XCompositeNode.class, n -> n.tooManyChildren(this.myFetcher.isRowCountPrecise() ? this.myFetcher.getRowCount() - this.myFetcher.getRows().size() : -1));
        }

        boolean isSingleValue() {
            return this.myFetcher.getColumns().size() == 1 && this.myFetcher.getRowCount() == 1;
        }

        private void updateEvaluator(@NotNull XValueNode n, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            if (n == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "n", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updateEvaluator"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updateEvaluator"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updateEvaluator"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updateEvaluator"));
            }
            if (!this.isTree(place) || this.myFetcher.isRowCountPrecise()) {
                return;
            }
            n.setFullValueEvaluator((XFullValueEvaluator)new MyCountEvaluator(n, name, separator, this.myFetcher.getRowCount()));
        }

        private void updateSingleValue(@NotNull XValueNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updateSingleValue"));
            }
            this.myFetcher.fetchCached();
            final DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            final Object value = column.getValue(row);
            String representation2 = AbstractTableResult.notNullValue(this.myFormatter, column, this.myDialect, value, true);
            String stringValue = AbstractTableResult.cut(representation2);
            if (representation2.length() > stringValue.length()) {
                node.setFullValueEvaluator(new XFullValueEvaluator(){

                    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                        if (callback == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$1", "startEvaluation"));
                        }
                        callback.evaluated(AbstractTableResult.notNullValue(myFormatter, column, myDialect, value, true, false));
                    }
                });
            }
            node.setPresentation(null, this.myPresentation.compute((DataConsumer.Column)column).typeName, stringValue, false);
        }

        private boolean isTree(@NotNull XValuePlace place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "isTree"));
            }
            return this.myFetcher.getRowCount() == 0 || this.myFetcher.getColumns().isEmpty() || place == XValuePlace.TREE;
        }

        private void updatePresentation(@NotNull XValueNode node, @NotNull XValuePlace place, @NotNull String name, @NotNull String separator) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updatePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updatePresentation"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updatePresentation"));
            }
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater", "updatePresentation"));
            }
            boolean tree = this.isTree(place);
            TablePresentation presentation = tree ? this.createRegularPresentation(name, separator) : new TablePresentation(this.myDialect, this.myFetcher, this.myPresentation);
            node.setPresentation(DatabaseIcons.Table, (XValuePresentation)presentation, tree);
        }

        private class MyCountEvaluator
        extends XFullValueEvaluator {
            private final XValueNode myNode;
            private final String myName;
            private final String mySeparator;

            private MyCountEvaluator(@NotNull XValueNode node, @NotNull String name, String separator, int rows) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator", "<init>"));
                }
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator", "<init>"));
                }
                if (separator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator", "<init>"));
                }
                super("(" + rows + "+ " + StringUtil.pluralize((String)"row", (int)rows) + ")");
                this.myNode = node;
                this.myName = name;
                this.mySeparator = separator;
                this.setShowValuePopup(false);
            }

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator", "startEvaluation"));
                }
                MyRootNodeUpdater.this.myFetcher.count(() -> {
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator", "lambda$startEvaluation$0"));
                    }
                    if (callback.isObsolete()) {
                        return;
                    }
                    MyRootNodeUpdater.this.update((Obsolescent)this.myNode, XValuePlace.TREE, this.myName, this.mySeparator);
                    this.myNode.setFullValueEvaluator(new XFullValueEvaluator(""){

                        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                            if (callback == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator$1", "startEvaluation"));
                            }
                        }
                    });
                    callback.evaluated("");
                });
            }
        }
    }

    private static class MyFormatter
    extends ObjectFormatter {
        private MyFormatter() {
        }

        @Override
        @Nullable
        public String objectToString(@Nullable Object o, DataConsumer.Column column, DatabaseDialect dialect, boolean forDisplay) {
            return AbstractTableResult.cut(StringUtil.notNullize((String)super.objectToString(o, column, dialect, true), (String)"null"));
        }
    }

    public static class DasTableResult
    extends AbstractTableResult {
        private final DasTable myTable;

        public DasTableResult(@NotNull DatabaseDialectEx dialect, @NotNull EvaluationResultFetcher support, @NotNull DasTable table) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "<init>"));
            }
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "<init>"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "<init>"));
            }
            super(dialect, support);
            this.myTable = table;
            this.init();
        }

        @Override
        @NotNull
        protected String getResultName() {
            String string = this.myTable.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "getResultName"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            if (" = " == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "getResultSeparator"));
            }
            return " = ";
        }

        @Override
        @NotNull
        EvaluationColumnsPresentation createColumnsPresentation() {
            EvaluationColumnsPresentation.DasPresentation dasPresentation = new EvaluationColumnsPresentation.DasPresentation(this.myDialect, this.myTable);
            if (dasPresentation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "createColumnsPresentation"));
            }
            return dasPresentation;
        }

        @Override
        @NotNull
        MyRootNodeUpdater createRootNodeUpdater() {
            MyRootNodeUpdater myRootNodeUpdater = new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDialect){

                @Override
                boolean isSingleValue() {
                    return false;
                }
            };
            if (myRootNodeUpdater == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult", "createRootNodeUpdater"));
            }
            return myRootNodeUpdater;
        }
    }

    public static class TableResult
    extends AbstractTableResult {
        public TableResult(@NotNull DatabaseDialectEx dialect, @NotNull EvaluationResultFetcher support) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "<init>"));
            }
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "<init>"));
            }
            super(dialect, support);
            this.init();
        }

        @Override
        @NotNull
        public String representation() {
            if (this.myFetcher.getRowCount() != 1 || this.myFetcher.getColumns().size() != 1) {
                String string = super.representation();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "representation"));
                }
                return string;
            }
            this.myFetcher.fetchCached();
            DataConsumer.Column column = (DataConsumer.Column)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            DataConsumer.Row row = (DataConsumer.Row)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            String string = TableResult.notNullValue(this.myFormatter, column, this.myDialect, column.getValue(row), true);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "representation"));
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "getResultSeparator"));
            }
            return "";
        }

        @Override
        @NotNull
        protected String getResultName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TableResult", "getResultName"));
            }
            return "";
        }
    }

    public static class TablePresentation
    extends XValuePresentation {
        private final DatabaseDialectEx myDialect;
        private final EvaluationResultFetcher myFetcher;
        private final ObjectFormatter myFormatter;
        private final EvaluationColumnsPresentation myPresentation;

        TablePresentation(@NotNull DatabaseDialectEx dialect, @NotNull EvaluationResultFetcher support, @NotNull EvaluationColumnsPresentation presentation) {
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "<init>"));
            }
            if (support == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "<init>"));
            }
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "<init>"));
            }
            this.myPresentation = presentation;
            this.myFormatter = new MyFormatter();
            this.myDialect = dialect;
            this.myFetcher = support;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "renderValue"));
            }
            renderer.renderValue(this.getText());
        }

        @NotNull
        public JComponent presentationComponent(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "presentationComponent"));
            }
            Ref consumerRef = Ref.create();
            Ref scrollPaneRef = Ref.create();
            this.myFetcher.fetchCached();
            MyHyperlinkListener listener = new MyHyperlinkListener((Ref<JScrollPane>)scrollPaneRef, (Ref<Consumer<String>>)consumerRef);
            JComponent label = HintUtil.createInformationLabel((String)this.getText(), (HyperlinkListener)listener, null, (Ref)consumerRef);
            Dimension preferredSize = label.getPreferredSize();
            JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)label, (boolean)true);
            Dimension cropped = TablePresentation.cropToFitScreen(editor, pane, preferredSize);
            if (!cropped.equals(preferredSize)) {
                pane.setPreferredSize(cropped);
            }
            scrollPaneRef.set((Object)pane);
            JComponent jComponent = (JComponent)scrollPaneRef.get();
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "presentationComponent"));
            }
            return jComponent;
        }

        @NotNull
        private static Dimension cropToFitScreen(@NotNull Editor editor, @NotNull JScrollPane pane, @NotNull Dimension preferredSize) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "cropToFitScreen"));
            }
            if (pane == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pane", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "cropToFitScreen"));
            }
            if (preferredSize == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredSize", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "cropToFitScreen"));
            }
            Rectangle screenRect = ScreenUtil.getScreenRectangle((Component)editor.getComponent());
            int width = Math.min(preferredSize.width, (int)((double)screenRect.width * 0.9));
            int height = Math.min(preferredSize.height, (int)((double)screenRect.height * 0.9));
            boolean widthChanged = width < preferredSize.width;
            JScrollBar bar = pane.getHorizontalScrollBar();
            int hsbHeight = bar == null || !widthChanged || SystemInfo.isMac ? 0 : bar.getPreferredSize().height;
            Dimension dimension = new Dimension(width, height + hsbHeight);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "cropToFitScreen"));
            }
            return dimension;
        }

        @NotNull
        private String getText() {
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(HintUtil.getInformationColor(), this.myFormatter, 99){

                @Override
                @NotNull
                protected String getName(@NotNull DataConsumer.Column column) {
                    if (column == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$1", "getName"));
                    }
                    String string = super.getName(column) + ": " + ((TablePresentation)this).myPresentation.compute((DataConsumer.Column)column).typeName;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$1", "getName"));
                    }
                    return string;
                }
            };
            StringBuilder builder = new StringBuilder(this.getHeader());
            List<DataConsumer.Row> rows = this.myFetcher.getRows();
            List<DataConsumer.Column> columns2 = this.myFetcher.getColumns();
            CharOut out = CharOut.Util.newSink(builder);
            int[] columnsToExtract = columns2.stream().mapToInt(c -> c.columnNum).toArray();
            ExtractorsUtil.extract(out, this.myDialect, false, columns2, extractor, rows, columnsToExtract);
            if (this.myFetcher.canFetch()) {
                builder.append("<div style='margin-top: 3px;margin-bottom: 2px;'>").append(TablePresentation.getLink("More...", "more")).append("</div>");
            }
            String string = builder.append(DisplayHtmlValuesExtractor.getTail()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getText"));
            }
            return string;
        }

        @NotNull
        private String getHeader() {
            StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
            if (!this.myFetcher.canFetch() && this.myFetcher.getRows().size() <= this.myFetcher.getFetchSize()) {
                String string = sb.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getHeader"));
                }
                return string;
            }
            int rowsCount = this.myFetcher.getRowCount();
            sb.append("<div style='margin-bottom: 3px; margin-top: 2px'>Rows: <b>");
            if (this.myFetcher.isRowCountPrecise()) {
                sb.append(rowsCount);
            } else {
                sb.append(TablePresentation.getLink(rowsCount + "+", "count"));
            }
            sb.append("</b></div>");
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getHeader"));
            }
            return string;
        }

        @NotNull
        private static String getLink(@NotNull String text, @NotNull String url) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getLink"));
            }
            if (url == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getLink"));
            }
            String string = String.format("<a href='%s'>%s</a>", url, text);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation", "getLink"));
            }
            return string;
        }

        private class MyHyperlinkListener
        implements HyperlinkListener {
            private final Ref<JScrollPane> myScrollPaneRef;
            private final Ref<Consumer<String>> myConsumerRef;

            public MyHyperlinkListener(@NotNull Ref<JScrollPane> scrollPaneRef, Ref<Consumer<String>> consumerRef) {
                if (scrollPaneRef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollPaneRef", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$MyHyperlinkListener", "<init>"));
                }
                if (consumerRef == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRef", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$MyHyperlinkListener", "<init>"));
                }
                this.myScrollPaneRef = scrollPaneRef;
                this.myConsumerRef = consumerRef;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || TablePresentation.this.myFetcher.isBusy()) {
                    return;
                }
                String link = e.getDescription();
                LinkRunner runner = LinkRunner.get(link);
                if (runner == null) {
                    return;
                }
                runner.run(TablePresentation.this.myFetcher, () -> {
                    JViewport viewport = ((JScrollPane)this.myScrollPaneRef.get()).getViewport();
                    Point position = viewport.getViewPosition();
                    ((Consumer)this.myConsumerRef.get()).consume((Object)TablePresentation.this.getText());
                    if (runner == LinkRunner.COUNT) {
                        DbUIUtil.invokeLater(() -> {
                            if (viewport.isShowing()) {
                                viewport.setViewPosition(position);
                            }
                        });
                    }
                });
            }
        }

        private static enum LinkRunner {
            COUNT{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetcher", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$1", "run"));
                    }
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$1", "run"));
                    }
                    fetcher.count(() -> {
                        if (callback == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$1", "lambda$run$0"));
                        }
                        callback.run();
                    });
                }
            }
            ,
            MORE{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fetcher", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$2", "run"));
                    }
                    if (callback == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$2", "run"));
                    }
                    fetcher.fetch(() -> {
                        if (callback == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$2", "lambda$run$0"));
                        }
                        callback.run();
                    });
                }
            };


            abstract void run(@NotNull EvaluationResultFetcher var1, @NotNull Runnable var2);

            @Nullable
            static LinkRunner get(@NotNull String link) {
                if (link == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner", "get"));
                }
                for (LinkRunner runner : LinkRunner.values()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)runner.name(), (CharSequence)link)) continue;
                    return runner;
                }
                return null;
            }
        }
    }
}

