/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.console.evaluation.OwnerBasedEvaluationRequestor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DasObjectRequestor
extends OwnerBasedEvaluationRequestor {
    private final DasObject myObject;

    protected DasObjectRequestor(@NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source, @NotNull DasObject object) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/DasObjectRequestor", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/DasObjectRequestor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/DasObjectRequestor", "<init>"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor", "<init>"));
        }
        super(project, dialect, source);
        this.myObject = object;
    }

    @Override
    @Nullable
    public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/DasObjectRequestor", "createRequest"));
        }
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/DasObjectRequestor", "createRequest"));
        }
        Optional<String> query = this.getQueryIfAny();
        return query.map(s -> {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/DasObjectRequestor", "lambda$createRequest$0"));
            }
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/DasObjectRequestor", "lambda$createRequest$0"));
            }
            return new MyRequest(owner, this.myProject, this.myDialect, future, (String)s, this.myObject, this.mySource);
        }).orElse(null);
    }

    @Override
    @NotNull
    public String getQuery() {
        String string = this.getQueryIfAny().orElse(this.myObject.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor", "getQuery"));
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        return QueryBuilder.of(this.myObject) == null;
    }

    @NotNull
    private Optional<String> getQueryIfAny() {
        QueryBuilder builder = QueryBuilder.of(this.myObject);
        Optional<Object> optional = Optional.ofNullable(builder == null ? null : builder.build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, 0, 10));
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor", "getQueryIfAny"));
        }
        return optional;
    }

    private static enum QueryBuilder {
        TABLE{

            @Override
            boolean canBuild(@NotNull DasObject object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1", "canBuild"));
                }
                return object instanceof DasTable;
            }

            @Override
            @NotNull
            String build(@NotNull DasObject object, @NotNull DatabaseDialectEx dialect, @NotNull DatabaseSystem system, int start, int load) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1", "build"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1", "build"));
                }
                if (system == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1", "build"));
                }
                String string = DbImplUtil.createSelectAllQuery((DasTable)object, dialect, system, start + load + 1).getStatement();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$1", "build"));
                }
                return string;
            }
        }
        ,
        COLUMN{

            @Override
            boolean canBuild(@NotNull DasObject object) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2", "canBuild"));
                }
                return object instanceof DasColumn && object.getDbParent() instanceof DasTable;
            }

            @Override
            @NotNull
            String build(@NotNull DasObject object, @NotNull DatabaseDialectEx dialect, @NotNull DatabaseSystem system, int start, int load) {
                if (object == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2", "build"));
                }
                if (dialect == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2", "build"));
                }
                if (system == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "system", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2", "build"));
                }
                DasTable table = (DasTable)ObjectUtils.notNull((Object)((DasTable)object.getDbParent()));
                String string = dialect.sqlSelectColumns(DbImplUtil.createBuilderForUIExec(dialect, (DasObject)table), table, system, null, null, ContainerUtil.list((Object[])new DasColumn[]{(DasColumn)object}), false, start == -1 ? -1 : start + load + 1).getStatement();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder$2", "build"));
                }
                return string;
            }
        };


        @NotNull
        abstract String build(@NotNull DasObject var1, @NotNull DatabaseDialectEx var2, @NotNull DatabaseSystem var3, int var4, int var5);

        abstract boolean canBuild(@NotNull DasObject var1);

        @Nullable
        static QueryBuilder of(@NotNull DasObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$QueryBuilder", "of"));
            }
            for (QueryBuilder builder : QueryBuilder.values()) {
                if (!builder.canBuild(object)) continue;
                return builder;
            }
            return null;
        }
    }

    private static class MyFetcher
    extends EvaluationResultFetcher {
        private final DasObject myObject;

        MyFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, @NotNull Project project, @NotNull DataRequest.OwnerEx ex, @NotNull DbDataSource source, @NotNull DatabaseDialectEx dialect, @NotNull String query, @NotNull DasObject object, boolean loaded) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (columns2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (ex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "<init>"));
            }
            super(rows, columns2, project, ex, source, dialect, query, loaded);
            this.myObject = object;
        }

        @Override
        @NotNull
        protected String getQuery(int start, int load) {
            String string = ((QueryBuilder)((Object)ObjectUtils.notNull((Object)((Object)QueryBuilder.of(this.myObject))))).build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, start, load);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "getQuery"));
            }
            return string;
        }

        @Override
        @Nullable
        protected String getCountQuery(@NotNull String alias) {
            if (alias == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/database/console/evaluation/DasObjectRequestor$MyFetcher", "getCountQuery"));
            }
            String query = ((QueryBuilder)((Object)ObjectUtils.notNull((Object)((Object)QueryBuilder.of(this.myObject))))).build(this.myObject, this.myDialect, (DatabaseSystem)this.mySource, -1, -1);
            return DbImplUtil.createSelectCountQuery(this.myProject, this.myDialect, query, this.mySource);
        }
    }

    private static class MyRequest
    extends EvaluationRequest {
        private final DasObject myObject;

        MyRequest(@NotNull DataRequest.OwnerEx owner, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future, @NotNull String query, @NotNull DasObject object, @NotNull DbDataSource source) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "<init>"));
            }
            super(owner, project, dialect, future, query, source);
            this.myObject = object;
        }

        @Override
        @NotNull
        protected EvaluationResultFetcher createFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, boolean loaded) {
            if (rows == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "createFetcher"));
            }
            if (columns2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "createFetcher"));
            }
            MyFetcher myFetcher = new MyFetcher(rows, columns2, this.myProject, (DataRequest.OwnerEx)this.owner, this.mySource, this.myDialect, this.query, this.myObject, loaded);
            if (myFetcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/DasObjectRequestor$MyRequest", "createFetcher"));
            }
            return myFetcher;
        }
    }
}

