/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluationResultFetcher {
    private static final int FETCH_SIZE = 2;
    public static final int BATCH_SIZE = 10;
    protected final DbDataSource mySource;
    protected final DatabaseDialectEx myDialect;
    protected final Project myProject;
    private final List<DataConsumer.Row> myRows;
    private final List<DataConsumer.Column> myColumns;
    private final DataRequest.OwnerEx myOwnerEx;
    private final String myQuery;
    private final AtomicReference<DataRequest> myCurrentRequest;
    private boolean myLoaded;
    private int myFetched;
    private int myCount;

    EvaluationResultFetcher(@NotNull List<DataConsumer.Row> rows, @NotNull List<DataConsumer.Column> columns2, @NotNull Project project, @NotNull DataRequest.OwnerEx ex, @NotNull DbDataSource source, @NotNull DatabaseDialectEx dialect, @NotNull String query, boolean loaded) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (columns2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (ex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "<init>"));
        }
        this.myRows = rows;
        this.myColumns = columns2;
        this.myProject = project;
        this.myOwnerEx = ex;
        this.mySource = source;
        this.myDialect = dialect;
        this.myQuery = query;
        this.myLoaded = loaded;
        this.myCurrentRequest = new AtomicReference();
        this.myCount = -1;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "getProject"));
        }
        return project;
    }

    @NotNull
    public List<DataConsumer.Row> getRows() {
        List<DataConsumer.Row> list = this.myRows.subList(0, Math.min(this.myFetched, this.myRows.size()));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "getRows"));
        }
        return list;
    }

    public int getRowCount() {
        return this.myLoaded || this.myCount == -1 ? this.myRows.size() : this.myCount;
    }

    public boolean isRowCountPrecise() {
        return this.myCount != -1 || this.myLoaded;
    }

    public int getFetchSize() {
        return 2;
    }

    @NotNull
    public List<DataConsumer.Column> getColumns() {
        List<DataConsumer.Column> list = this.myColumns;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "getColumns"));
        }
        return list;
    }

    public void fetchCached() {
        this.fetchCached(null);
    }

    public void fetch(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "fetch"));
        }
        if (this.isBusy(callback) || this.fetchCached(callback)) {
            return;
        }
        RowsLoadRequest request = this.resetStateOnProcessed(new RowsLoadRequest(this.myOwnerEx, this.getQuery(this.myFetched, 10), this.myFetched, 10));
        this.myCurrentRequest.set(request);
        request.getPromise().processed(v -> {
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "lambda$fetch$1"));
            }
            DbUIUtil.invokeLaterIfNeeded(() -> {
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "lambda$null$0"));
                }
                this.myFetched = Math.min(this.myFetched + 2, this.myRows.size());
                callback.run();
            });
        });
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest(request);
    }

    public void count(final @NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "count"));
        }
        if (this.isBusy(callback)) {
            return;
        }
        this.myCurrentRequest.set(this.resetStateOnProcessed(new DataRequest.RawRequest(this.myOwnerEx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnection connection) throws Exception {
                try {
                    String t = DbImplUtil.findFreeAlias(EvaluationResultFetcher.this.myProject, EvaluationResultFetcher.this.myDialect, EvaluationResultFetcher.this.myQuery, "t");
                    String query = EvaluationResultFetcher.this.getCountQuery(t);
                    if (query != null) {
                        EvaluationResultFetcher.this.myCount = DbImplUtil.getCount(connection, query);
                    }
                }
                finally {
                    DbUIUtil.invokeLaterIfNeeded(callback);
                }
            }
        }));
        this.myOwnerEx.getMessageBus().getDataProducer().processRequest(this.myCurrentRequest.get());
    }

    @NotNull
    protected String getQuery(int start, int load) {
        String string = this.myQuery;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "getQuery"));
        }
        return string;
    }

    @Nullable
    protected String getCountQuery(@NotNull String alias) {
        if (alias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "alias", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "getCountQuery"));
        }
        return DbImplUtil.createSelectCountQuery(this.myProject, this.myDialect, this.myQuery, this.mySource, alias);
    }

    public boolean canFetch() {
        return this.myRows.size() > this.myFetched || !this.myLoaded;
    }

    public boolean isBusy() {
        return this.myCurrentRequest.get() != null;
    }

    private boolean fetchCached(@Nullable Runnable callback) {
        if (this.myFetched < this.myRows.size() || this.myLoaded) {
            this.myFetched = Math.min(this.myFetched + 2, this.myRows.size());
            if (callback != null) {
                callback.run();
            }
            return true;
        }
        return false;
    }

    private boolean isBusy(@NotNull Runnable callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "isBusy"));
        }
        if (this.isBusy()) {
            callback.run();
            return true;
        }
        return false;
    }

    @NotNull
    private <T extends DataRequest> T resetStateOnProcessed(@NotNull T request) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "resetStateOnProcessed"));
        }
        request.getPromise().processed(v -> this.myCurrentRequest.set(null));
        T t = request;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/EvaluationResultFetcher", "resetStateOnProcessed"));
        }
        return t;
    }

    protected class RowsLoadRequest
    extends DataRequest.IsolatedQueryRequest {
        private int myCount;

        protected RowsLoadRequest(@NotNull DataRequest.OwnerEx owner, String query, int loaded, int toLoad) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest", "<init>"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest", "<init>"));
            }
            super(owner, owner.getCurrentTx(), query, DataRequest.newConstraints(loaded + 1, toLoad, 0), null);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, DataConsumer.Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest", "setColumns"));
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<DataConsumer.Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest", "addRows"));
            }
            ObjectFormatter.convertRows(rows, EvaluationResultFetcher.this.myColumns);
            EvaluationResultFetcher.this.myRows.addAll(rows);
            this.myCount += rows.size();
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/EvaluationResultFetcher$RowsLoadRequest", "afterLastRowAdded"));
            }
            EvaluationResultFetcher.this.myLoaded = total <= EvaluationResultFetcher.this.myRows.size();
        }

        public int getCount() {
            return this.myCount;
        }
    }
}

