/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.DataBus;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.DasObjectRequestor;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.EvaluationRequestor;
import com.intellij.database.console.evaluation.EvaluationRequestorFactory;
import com.intellij.database.console.evaluation.PsiRequestor;
import com.intellij.database.console.evaluation.TextRequestor;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.sql.psi.SqlElement;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OwnerBasedExpressionEvaluator<T>
implements DatabaseExpressionEvaluator<T> {
    protected final DataRequest.OwnerEx myOwner;
    protected final DatabaseDialectEx myDialect;
    protected final DbDataSource myDataSource;
    protected final List<DasNamespace> mySearchPath;
    protected final Project myProject;
    private final Disposable myParent;

    public OwnerBasedExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull Project project, @Nullable Disposable parent) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "<init>"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "<init>"));
        }
        this.myOwner = owner;
        this.myDialect = dialect;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myProject = project;
        this.myParent = parent;
    }

    @NotNull
    public CompletableFuture<DatabaseExpressionEvaluator.Result> evaluate(@NotNull T value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "evaluate"));
        }
        CompletableFuture<DatabaseExpressionEvaluator.Result> future = new CompletableFuture<DatabaseExpressionEvaluator.Result>();
        EvaluationRequestor<DataRequest.OwnerEx> requestor = this.createRequestor(value);
        EvaluationRequest request = requestor.createRequest(this.myOwner, future);
        if (request == null) {
            future.completeExceptionally(new RuntimeException("Can't evaluate: " + requestor.getQuery()));
            CompletableFuture<DatabaseExpressionEvaluator.Result> completableFuture = future;
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "evaluate"));
            }
            return completableFuture;
        }
        if (this.myParent != null) {
            Disposer.register((Disposable)this.myParent, (Disposable)request);
        }
        DataBus.Consuming bus = this.myOwner.getMessageBus();
        MyAuditor auditor = new MyAuditor(future, request);
        bus.addAuditor(auditor);
        bus.getDataProducer().processRequest(request);
        CompletableFuture<DatabaseExpressionEvaluator.Result> completableFuture = future;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator", "evaluate"));
        }
        return completableFuture;
    }

    @NotNull
    protected abstract EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull T var1);

    public static class PsiExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<SqlElement> {
        private final JdbcConsole myConsole;

        public PsiExpressionEvaluator(@NotNull JdbcConsole console, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull Project project, @Nullable Disposable parent) {
            if (console == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "console", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "<init>"));
            }
            super(console, dialect, dataSource, searchPath, project, parent);
            this.myConsole = console;
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull SqlElement value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "createRequestor"));
            }
            PsiRequestor psiRequestor = new PsiRequestor(this.myConsole, value, this.myProject, this.myDialect, this.myDataSource);
            if (psiRequestor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$PsiExpressionEvaluator", "createRequestor"));
            }
            return psiRequestor;
        }
    }

    public static class ImmutableTextExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<String> {
        public ImmutableTextExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull Project project, @Nullable Disposable parent) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "<init>"));
            }
            super(owner, dialect, dataSource, searchPath, project, parent);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "createRequestor"));
            }
            TextRequestor textRequestor = new TextRequestor(this.myProject, this.myDialect, value, this.myDataSource);
            if (textRequestor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$ImmutableTextExpressionEvaluator", "createRequestor"));
            }
            return textRequestor;
        }
    }

    public static class TextExpressionEvaluator
    extends OwnerBasedExpressionEvaluator<String> {
        public TextExpressionEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull Project project, @Nullable Disposable parent) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "<init>"));
            }
            super(owner, dialect, dataSource, searchPath, project, parent);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "createRequestor"));
            }
            EvaluationRequestor<DataRequest.OwnerEx> evaluationRequestor = EvaluationRequestorFactory.create(this.myProject, this.myDialect, value, this.myDataSource, this.mySearchPath);
            if (evaluationRequestor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$TextExpressionEvaluator", "createRequestor"));
            }
            return evaluationRequestor;
        }
    }

    public static class DasObjectEvaluator
    extends OwnerBasedExpressionEvaluator<DasObject> {
        public DasObjectEvaluator(@NotNull DataRequest.OwnerEx owner, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource dataSource, @Nullable List<DasNamespace> searchPath, @NotNull Project project, @Nullable Disposable parent) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "<init>"));
            }
            if (dialect == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "<init>"));
            }
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "<init>"));
            }
            super(owner, dialect, dataSource, searchPath, project, parent);
        }

        @Override
        @NotNull
        protected EvaluationRequestor<DataRequest.OwnerEx> createRequestor(@NotNull DasObject value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "createRequestor"));
            }
            DasObjectRequestor dasObjectRequestor = new DasObjectRequestor(this.myProject, this.myDialect, this.myDataSource, value);
            if (dasObjectRequestor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$DasObjectEvaluator", "createRequestor"));
            }
            return dasObjectRequestor;
        }
    }

    private static class MyAuditor
    extends DataAuditor.Adapter
    implements Disposable {
        private final CompletableFuture<DatabaseExpressionEvaluator.Result> myFuture;
        private final EvaluationRequest myRequest;

        private MyAuditor(@NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future, @NotNull EvaluationRequest request) {
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$MyAuditor", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$MyAuditor", "<init>"));
            }
            this.myFuture = future;
            this.myRequest = request;
            Disposer.register((Disposable)request, (Disposable)this);
        }

        @Override
        public void error(@NotNull DataRequest.Context context, @Nullable String message, @Nullable Throwable th) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$MyAuditor", "error"));
            }
            if (this.myRequest.isDisposed() || context.request != this.myRequest) {
                return;
            }
            if (!this.myFuture.isDone()) {
                this.myFuture.completeExceptionally(th == null ? new RuntimeException(message) : th);
            }
            Disposer.dispose((Disposable)this.myRequest);
        }

        public void dispose() {
        }
    }

    public static class EmptyResult
    implements DatabaseExpressionEvaluator.Result {
        @Override
        @NotNull
        public String representation() {
            if ("empty" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult", "representation"));
            }
            return "empty";
        }

        @Override
        public void computeChildren(@NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult", "computeChildren"));
            }
        }

        @Override
        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/database/console/evaluation/OwnerBasedExpressionEvaluator$EmptyResult", "computePresentation"));
            }
            node.setPresentation(null, null, "\"\"", false);
        }
    }
}

