/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationRequest;
import com.intellij.database.console.evaluation.JdbcConsoleEvaluationSupport;
import com.intellij.database.console.evaluation.OwnerBasedEvaluationRequestor;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBetweenExpression;
import com.intellij.sql.psi.SqlCaseExpression;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiRequestor
extends OwnerBasedEvaluationRequestor {
    private static final List<Class<? extends SqlExpression>> UNSUPPORTED_EXPRESSIONS = ContainerUtil.list((Object[])new Class[]{SqlTableExpression.class, SqlBetweenExpression.class, SqlCaseExpression.class, SqlReferenceExpression.class, SqlJoinExpression.class, SqlTableColumnsList.class});
    private final JdbcConsole myConsole;
    private final SqlElement myElement;

    protected PsiRequestor(@Nullable JdbcConsole console, @NotNull SqlElement expression, @NotNull Project project, @NotNull DatabaseDialectEx dialect, @NotNull DbDataSource source) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/PsiRequestor", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/PsiRequestor", "<init>"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/console/evaluation/PsiRequestor", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/PsiRequestor", "<init>"));
        }
        super(project, dialect, source);
        this.myConsole = console;
        this.myElement = expression;
    }

    @Override
    @Nullable
    public EvaluationRequest createRequest(@NotNull DataRequest.OwnerEx owner, @NotNull CompletableFuture<DatabaseExpressionEvaluator.Result> future) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/console/evaluation/PsiRequestor", "createRequest"));
        }
        if (future == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/console/evaluation/PsiRequestor", "createRequest"));
        }
        return new EvaluationRequest(owner, this.myProject, this.myDialect, future, this.getQuery(), this.mySource);
    }

    @Override
    @NotNull
    public String getQuery() {
        String string = PsiRequestor.getQuery(this.myConsole, this.myElement, this.mySource);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        return string;
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull DbDataSource source) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        String string = PsiRequestor.getQuery(console, element, DatabaseFamilyId.forDataSource((DatabaseSystem)source));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        return string;
    }

    @NotNull
    public static String getQuery(@Nullable JdbcConsole console, @NotNull SqlElement element, @NotNull DatabaseFamilyId id) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        String string = (String)PsiRequestor.traverse(element, e -> {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/evaluation/PsiRequestor", "lambda$getQuery$0"));
            }
            return e instanceof SqlExpression && PsiRequestor.isSufficientExpression((SqlExpression)e) ? PsiRequestor.getText(console, e) : PsiRequestor.createSelectStatement(id, PsiRequestor.getText(console, e));
        });
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "getQuery"));
        }
        return string;
    }

    @Nullable
    public static SqlExpression getExpression(@NotNull EditorEx editor, @NotNull Project project, @NotNull JdbcConsoleEvaluationSupport.PositionInfo position) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/console/evaluation/PsiRequestor", "getExpression"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/evaluation/PsiRequestor", "getExpression"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/console/evaluation/PsiRequestor", "getExpression"));
        }
        VirtualFile file = editor.getVirtualFile();
        if (file == null) {
            return null;
        }
        PsiFile psiFile = PsiUtilCore.getPsiFile((Project)project, (VirtualFile)file);
        int start = position.offset;
        return position.range != null ? PsiRequestor.getSelectedExpression(position.range, psiFile) : PsiRequestor.getExpressionAtCaret(psiFile, start);
    }

    @Override
    public boolean isEmpty() {
        return !(this.myElement instanceof SqlExpression);
    }

    public static boolean isUnsupportedExpression(@Nullable SqlExpression expression) {
        return expression == null || (Boolean)PsiRequestor.traverse((SqlElement)expression, e -> e == null || ContainerUtil.exists(UNSUPPORTED_EXPRESSIONS, c -> c.isInstance(e))) != false;
    }

    @Nullable
    private static SqlExpression getSelectedExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/console/evaluation/PsiRequestor", "getSelectedExpression"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/console/evaluation/PsiRequestor", "getSelectedExpression"));
        }
        int start = range.getStartOffset();
        SqlExpression expression = (SqlExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)start, (int)(end = range.getEndOffset()), SqlExpression.class);
        return PsiRequestor.isUnsupportedExpression(expression) ? PsiRequestor.getAsExpression(range, psiFile) : expression;
    }

    @Nullable
    private static SqlExpression getAsExpression(@NotNull TextRange range, @NotNull PsiFile psiFile) {
        int end;
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/database/console/evaluation/PsiRequestor", "getAsExpression"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/database/console/evaluation/PsiRequestor", "getAsExpression"));
        }
        int start = range.getStartOffset();
        SqlIdentifier identifier = (SqlIdentifier)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile, (int)start, (int)(end = range.getEndOffset()), SqlIdentifier.class);
        SqlAsExpression asExpression = (SqlAsExpression)PsiTreeUtil.getParentOfType((PsiElement)identifier, SqlAsExpression.class);
        return PsiRequestor.isUnsupportedExpression((SqlExpression)asExpression) ? null : asExpression;
    }

    @Nullable
    private static SqlExpression getExpressionAtCaret(@NotNull PsiFile file, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/evaluation/PsiRequestor", "getExpressionAtCaret"));
        }
        PsiElement element = file.findElementAt(offset);
        SqlExpression expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlExpression.class, (boolean)false);
        while (expression != null && PsiRequestor.isUnsupportedExpression(expression)) {
            expression = (SqlExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, SqlExpression.class);
        }
        return expression;
    }

    private static boolean isParenthesized(@NotNull SqlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/PsiRequestor", "isParenthesized"));
        }
        PsiElement[] children = element.getChildren();
        return element instanceof SqlParenthesizedExpression && children.length == 1 && children[0] instanceof SqlElement;
    }

    public static boolean isSufficientExpression(@Nullable SqlExpression expression) {
        return expression instanceof SqlResultSetExpression;
    }

    @NotNull
    public static String createSelectStatement(@NotNull DatabaseFamilyId id, @NotNull String expression) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/evaluation/PsiRequestor", "createSelectStatement"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/PsiRequestor", "createSelectStatement"));
        }
        String string = SelectStatementBuildingRule.of(id).apply(expression);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "createSelectStatement"));
        }
        return string;
    }

    @NotNull
    private static String getText(@Nullable JdbcConsole console, @NotNull SqlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/PsiRequestor", "getText"));
        }
        String string = StringUtil.convertLineSeparators((String)StringUtil.notNullize((String)(console == null ? null : JdbcConsole.getQueryText(console, element.getTextRange())), (String)element.getText()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "getText"));
        }
        return string;
    }

    @NotNull
    private static <T> T traverse(@NotNull SqlElement element, @NotNull Function<SqlElement, T> function) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/evaluation/PsiRequestor", "traverse"));
        }
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/database/console/evaluation/PsiRequestor", "traverse"));
        }
        Object object = element instanceof SqlAsExpression ? PsiRequestor.traverse((SqlElement)((SqlAsExpression)element).getExpression(), function) : (PsiRequestor.isParenthesized(element) ? PsiRequestor.traverse((SqlElement)element.getChildren()[0], function) : function.fun((Object)element));
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor", "traverse"));
        }
        return object;
    }

    private static enum SelectStatementBuildingRule {
        VALUES(new Processor[]{DatabaseFamilyId::isDb2, DatabaseFamilyId::isDerby, DatabaseFamilyId::isHsqldb}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$1", "apply"));
                }
                String string = "VALUES " + expression;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$1", "apply"));
                }
                return string;
            }
        }
        ,
        SELECT_FROM_DUAL(new Processor[]{DatabaseFamilyId::isOracle}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$2", "apply"));
                }
                String string = "SELECT " + expression + " FROM dual";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$2", "apply"));
                }
                return string;
            }
        }
        ,
        SELECT(new Processor[]{id -> true}){

            @Override
            @NotNull
            String apply(@NotNull String expression) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$3", "apply"));
                }
                String string = "SELECT " + expression;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule$3", "apply"));
                }
                return string;
            }
        };

        private final Processor<DatabaseFamilyId>[] myProcessors;

        private SelectStatementBuildingRule(Processor<DatabaseFamilyId> ... processors) {
            if (processors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processors", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule", "<init>"));
            }
            this.myProcessors = processors;
        }

        boolean canApply(@NotNull DatabaseFamilyId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule", "canApply"));
            }
            for (Processor<DatabaseFamilyId> processor : this.myProcessors) {
                if (!processor.process((Object)id)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        abstract String apply(@NotNull String var1);

        @NotNull
        static SelectStatementBuildingRule of(@NotNull DatabaseFamilyId id) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule", "of"));
            }
            for (SelectStatementBuildingRule rule : SelectStatementBuildingRule.values()) {
                if (!rule.canApply(id)) continue;
                SelectStatementBuildingRule selectStatementBuildingRule = rule;
                if (selectStatementBuildingRule == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/evaluation/PsiRequestor$SelectStatementBuildingRule", "of"));
                }
                return selectStatementBuildingRule;
            }
            throw new IllegalArgumentException("Can't find rule for family: " + id.getName());
        }
    }
}

