/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.registry;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;
import com.intellij.database.data.types.registry.PostgresBaseDomains;
import com.intellij.database.dialects.PostgresDialect;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PostgresDomains
extends PostgresBaseDomains {
    private static final int MAX_BIT = 0x5000000;
    private static final int MONEY_SCALE = 2;
    private static final int MAX_PRECISION = 1000;
    private static final int MAX_CHAR = 0xA00000;

    public PostgresDomains() {
        super(PostgresDialect.INSTANCE, 1000, 1000, 0xA00000, 0xA00000);
        this.add(new PostgresBaseDomains.MyZonedDomain(new FractionDomain("time with time zone", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true), "TIME"));
        this.add(new PostgresBaseDomains.MyZonedDomain(new FractionDomain("timestamp with time zone", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true), "timestamp"));
        this.add(new FractionDomain("timestamp", ConversionPoint.TIMESTAMP, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new FractionDomain("timestamptz", ConversionPoint.TIMESTAMP_WITH_TIMEZONE, PhysicalDomainType.TIMESTAMP, 6, 6, true));
        this.add(new Number2Domain("money", ConversionPoint.MONEY, 1000, 2, false));
        this.add(new IntegerDomain("serial", ConversionPoint.SERIAL_NUMBER, -2.147483648E9, 2.147483647E9));
        this.add(new IntegerDomain("smallserial", ConversionPoint.SERIAL_NUMBER, -32768.0, 32767.0));
        this.add(new IntegerDomain("bigserial", ConversionPoint.SERIAL_NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add(new MyTextLikeDomain("int4range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("int8range", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("numrange", ConversionPoint.NUMBER_RANGE, PhysicalDomainType.TEXT));
        this.add(new SimpleDomain("json", ConversionPoint.JSON, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("daterange", ConversionPoint.DATE_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("tsrange", ConversionPoint.TIMESTAMP_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("tstzrange", ConversionPoint.TIMESTAMP_TZ_RANGE, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("point", ConversionPoint.POINT, PhysicalDomainType.TEXT));
        this.add(new MyTextLikeDomain("interval", ConversionPoint.INTERVAL, PhysicalDomainType.TEXT));
        this.add(new FractionDomain("time", ConversionPoint.TIME, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new FractionDomain("timetz", ConversionPoint.TIME_WITH_TIMEZONE, PhysicalDomainType.TIME, 6, 6, true));
        this.add(new BinaryDomain("bytea", ConversionPoint.BLOB, Integer.MAX_VALUE));
        this.add(new TextDomain("bit", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("bit varying", ConversionPoint.BINARY_STRING, 0x5000000L, -1L, true));
        this.add(new TextDomain("xml", ConversionPoint.XML, Integer.MAX_VALUE));
        this.add(new TextDomain("tid", ConversionPoint.TEXT_ID, Integer.MAX_VALUE));
        this.add(new SimpleDomain("uuid", ConversionPoint.UUID, PhysicalDomainType.TEXT));
    }

    private static class MyTextLikeDomain
    extends SimpleDomain
    implements TextDomain.TextPreferrable {
        public MyTextLikeDomain(@NotNull String name, @NotNull ConversionPoint descriptor, @NotNull PhysicalDomainType type) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "<init>"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "<init>"));
            }
            super(name, descriptor, type);
        }

        @Override
        @NotNull
        public LogicalType getFakeType() {
            LogicalType logicalType = LogicalType.TEXT;
            if (logicalType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "getFakeType"));
            }
            return logicalType;
        }

        @Override
        @NotNull
        public Compatibility getCompatibility(@NotNull Domain domain) {
            if (domain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "getCompatibility"));
            }
            Compatibility compatibility = domain instanceof MyTextLikeDomain ? (StringUtil.equals((CharSequence)this.simpleName(), (CharSequence)domain.simpleName()) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.uncompatible()) : super.getCompatibility(domain);
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/registry/PostgresDomains$MyTextLikeDomain", "getCompatibility"));
            }
            return compatibility;
        }
    }
}

