/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceTemplate;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.StatelessTemplateJdbcUrlParser;
import com.intellij.database.dataSource.url.template.StatelessTextDecomposition;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import icons.DatabaseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDriverImpl
implements DatabaseDriver {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverImpl.class);
    private final boolean myPredefined;
    private final String myId;
    private String myName;
    private String myDriverClass;
    private String mySqlDialect;
    private Icon myIcon;
    private String myIconName;
    private String myVmOptions;
    @NotNull
    private Map<String, String> myVmEnv = ContainerUtil.newLinkedHashMap();
    private final List<UrlTemplate> myUrlTemplates = ContainerUtil.newArrayList();
    private final List<Pair<UrlTemplate, String>> myTemplatesErrors = ContainerUtil.newArrayList();
    private final Map<String, String> myDriverProperties = ContainerUtil.newLinkedHashMap();
    private final Map<DatabaseDriver.Option, String> myOptions = ContainerUtil.newLinkedHashMap();
    private ArtifactRefImpl myArtifactRef;
    private DatabaseDriver.Bounds myBounds;
    private final List<SimpleClasspathElement> myAdditionalClasspathElements = ContainerUtil.newArrayList();
    private List<StatelessJdbcUrlParser> myJdbcUrlParsers = Collections.emptyList();
    private final EnumSet<StatelessJdbcUrlParser.LocationType> mySupportedLocations = EnumSet.noneOf(StatelessJdbcUrlParser.LocationType.class);

    public DatabaseDriverImpl(@Nullable String id, boolean predefined) {
        this.myId = StringUtil.isEmpty((String)id) ? UUID.randomUUID().toString() : id;
        this.myPredefined = predefined;
    }

    public DatabaseDriverImpl(@Nullable String id, @Nullable String name, @Nullable String driverClass, @Nullable UrlTemplate urlTemplate) {
        this(id, false);
        this.myName = name;
        this.myDriverClass = driverClass;
        if (urlTemplate != null) {
            this.setURLTemplates(Collections.singletonList(urlTemplate));
        }
    }

    @NotNull
    public List<Pair<UrlTemplate, String>> getTemplatesErrors() {
        List<Pair<UrlTemplate, String>> list = this.myTemplatesErrors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getTemplatesErrors"));
        }
        return list;
    }

    @Override
    public boolean isPredefined() {
        return this.myPredefined;
    }

    @Override
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = !StringUtil.isEmpty((String)this.myName) ? this.myName : "?";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFullName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getFullName"));
        }
        return string;
    }

    @NotNull
    public List<DataSourceTemplate> getSubConfigurations() {
        List<DataSourceTemplate> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSubConfigurations"));
        }
        return list;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public List<StatelessJdbcUrlParser> getJDBCUrlParsers() {
        List<StatelessJdbcUrlParser> list = this.myJdbcUrlParsers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getJDBCUrlParsers"));
        }
        return list;
    }

    @Override
    @Nullable
    public DatabaseDriver.Bounds getConnectionBounds() {
        return this.myBounds;
    }

    @Override
    @NotNull
    public EnumSet<StatelessJdbcUrlParser.LocationType> getSupportedLocations() {
        EnumSet<StatelessJdbcUrlParser.LocationType> enumSet = this.mySupportedLocations;
        if (enumSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSupportedLocations"));
        }
        return enumSet;
    }

    @NotNull
    public DatabaseSystem createDataSource(@NotNull Project project, @Nullable DatabaseSystem copyFrom, @Nullable String newName) {
        LocalDataSource result2;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        if (copyFrom instanceof LocalDataSource) {
            result2 = ((LocalDataSource)copyFrom).copy(project);
        } else {
            result2 = new LocalDataSource(this, this.getSampleUrl());
            if (DbImplUtil.supportsDomainAuth(this)) {
                result2.setDomainAuthentication(true);
            }
        }
        if (copyFrom == null) {
            this.setDefaultProperties(result2);
        } else {
            result2.setFirstSync(ThreeState.NO);
            DatabaseCredentials.getInstance().copyCredentials(copyFrom, (DatabaseSystem)result2);
        }
        result2.setName(StringUtil.notNullize((String)newName, (String)""));
        LocalDataSource localDataSource = result2;
        if (localDataSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "createDataSource"));
        }
        return localDataSource;
    }

    public void setDefaultProperties(@NotNull LocalDataSource result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/DatabaseDriverImpl", "setDefaultProperties"));
        }
        result2.getDriverProperties().putAll(this.myDriverProperties);
        result2.setDriverClass(this.myDriverClass);
        result2.setVmOptions(this.myVmOptions);
        result2.setVmEnv(this.myVmEnv);
        result2.setAutoSynchronize(DatabaseDriver.OPTION_AUTO_SYNC.get(this));
        result2.setAutoCommit(DatabaseDriver.OPTION_AUTO_COMMIT.get(this));
    }

    @Override
    public String getDriverClass() {
        return this.myDriverClass;
    }

    public void setDriverClass(String driverClass) {
        this.myDriverClass = driverClass;
    }

    @NotNull
    public Collection<UrlTemplate> getUrlTemplates() {
        List<UrlTemplate> list = this.myUrlTemplates;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getUrlTemplates"));
        }
        return list;
    }

    public void setURLTemplates(@NotNull Collection<UrlTemplate> templates) {
        if (templates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templates", "com/intellij/database/dataSource/DatabaseDriverImpl", "setURLTemplates"));
        }
        this.myUrlTemplates.clear();
        this.myTemplatesErrors.clear();
        this.myUrlTemplates.addAll(templates);
        this.myJdbcUrlParsers = ContainerUtil.newArrayListWithCapacity((int)templates.size());
        for (UrlTemplate template : templates) {
            try {
                StatelessTextDecomposition decomposition = StatelessTextDecomposition.build(template.getTemplate(), TypesRegistry.INSTANCE);
                this.myJdbcUrlParsers.add(new StatelessTemplateJdbcUrlParser(template.getName(), decomposition));
            }
            catch (StatelessTextDecomposition.InvalidTemplateException e) {
                this.myTemplatesErrors.add((Pair<UrlTemplate, String>)Pair.create((Object)template, (Object)e.getMessage()));
            }
        }
        this.mySupportedLocations.clear();
        for (StatelessJdbcUrlParser p : this.myJdbcUrlParsers) {
            this.mySupportedLocations.addAll(p.getPossibleLocations());
        }
    }

    @Override
    public boolean matchesUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/database/dataSource/DatabaseDriverImpl", "matchesUrl"));
        }
        return JdbcUrlParserUtil.select(this.myJdbcUrlParsers, url) != null;
    }

    @Override
    @NotNull
    public String getSampleUrl() {
        StatelessJdbcUrlParser sparser = null;
        for (StatelessJdbcUrlParser parser : this.myJdbcUrlParsers) {
            if (!parser.getName().equals("default")) continue;
            sparser = parser;
            break;
        }
        if (sparser == null) {
            sparser = (StatelessJdbcUrlParser)ContainerUtil.getFirstItem(this.myJdbcUrlParsers);
        }
        if (sparser == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
            }
            return "";
        }
        JdbcUrlParser parser = sparser.createStatefull();
        for (String p : parser.getParameters()) {
            String def = parser.getParameterDefValue(p);
            parser.setParameter(p, StringUtil.notNullize((String)def));
        }
        String string = parser.getUrlText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getSampleUrl"));
        }
        return string;
    }

    @Override
    public String getSqlDialect() {
        return this.mySqlDialect;
    }

    public void setSqlDialect(String dialect) {
        if (Comparing.equal((String)dialect, (String)this.getSqlDialect())) {
            return;
        }
        this.mySqlDialect = dialect;
    }

    @NotNull
    public Icon getIcon(@Iconable.IconFlags int flags) {
        Icon icon = this.myIcon != null ? this.myIcon : DatabaseIcons.UserDriver;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getIcon"));
        }
        return icon;
    }

    @Override
    public String getIconName() {
        return this.myIconName;
    }

    @Override
    public Map<String, String> getDriverProperties() {
        return this.myDriverProperties;
    }

    @Override
    public <T> T getOption(@NotNull DatabaseDriver.Option<T> option) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "getOption"));
        }
        String value = this.myOptions.get(option);
        return option.fromString(value);
    }

    @Override
    public <T> void setOption(@NotNull DatabaseDriver.Option<T> option, T value) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/database/dataSource/DatabaseDriverImpl", "setOption"));
        }
        if (value == null) {
            this.myOptions.remove(option);
        } else {
            this.myOptions.put(option, String.valueOf(value));
        }
    }

    @Override
    public String getVmOptions() {
        return this.myVmOptions;
    }

    public void setVmOptions(String vmOptions) {
        this.myVmOptions = vmOptions;
    }

    @NotNull
    public Map<String, String> getVmEnv() {
        Map<String, String> map = this.myVmEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getVmEnv"));
        }
        return map;
    }

    public void setVmEnv(@NotNull Map<String, String> vmEnv) {
        if (vmEnv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmEnv", "com/intellij/database/dataSource/DatabaseDriverImpl", "setVmEnv"));
        }
        this.myVmEnv.clear();
        this.myVmEnv.putAll(vmEnv);
    }

    public String getArtifactName() {
        return this.myArtifactRef == null ? null : this.myArtifactRef.getName();
    }

    @Override
    @Nullable
    public DatabaseDriver.ArtifactRef getArtifact() {
        return this.myArtifactRef;
    }

    @Override
    public List<SimpleClasspathElement> getClasspathElements() {
        if (this.myArtifactRef == null || !this.myArtifactRef.isUsed()) {
            return Collections.unmodifiableList(this.myAdditionalClasspathElements);
        }
        return JBIterable.from(this.myArtifactRef.getElements()).append(this.myAdditionalClasspathElements).toList();
    }

    @NotNull
    public DatabaseDriverImpl loadState(@NotNull Element config, boolean merge, boolean overrideName, int format) {
        String optionName;
        Element env;
        PathMacroManager pathMacroManager;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/dataSource/DatabaseDriverImpl", "loadState"));
        }
        Application app = ApplicationManager.getApplication();
        PathMacroManager pathMacroManager2 = pathMacroManager = app == null ? null : PathMacroManager.getInstance((ComponentManager)app);
        if (overrideName || this.myName == null) {
            this.myName = DatabaseDriverImpl.getOverride(config.getAttributeValue("name"), this.myName, merge);
        }
        this.myDriverClass = DatabaseDriverImpl.getOverride(config.getAttributeValue("driver-class"), this.myDriverClass, merge);
        Element bounds = config.getChild("connection-bounds");
        if (!merge) {
            this.myBounds = null;
        }
        if (bounds != null) {
            String readOnly = bounds.getAttributeValue("in-read-only");
            String boundTo = bounds.getAttributeValue("bound-to");
            LinkedHashSet rewriteParameters = ContainerUtil.newLinkedHashSet();
            for (Element param : bounds.getChildren("rewrite-parameter")) {
                String name = param.getAttributeValue("name");
                boolean inUrl = "true".equals(param.getAttributeValue("in-url"));
                if (!StringUtil.isNotEmpty((String)name)) continue;
                rewriteParameters.add(Pair.create((Object)name, (Object)inUrl));
            }
            String defaultValue = bounds.getAttributeValue("default-value");
            if (!merge || this.myBounds == null) {
                if (this.myBounds == null) {
                    this.myBounds = new DatabaseDriver.Bounds();
                }
                this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                this.myBounds.rewriteParameters = ContainerUtil.newArrayList((Iterable)rewriteParameters);
                this.myBounds.defaultValue = defaultValue;
            } else {
                if (readOnly != null) {
                    this.myBounds.inReadOnlyMode = "true".equals(readOnly);
                }
                if (boundTo != null) {
                    ObjectKind objectKind = this.myBounds.boundTo = "schema".equals(boundTo) ? ObjectKind.SCHEMA : ObjectKind.DATABASE;
                }
                if (!rewriteParameters.isEmpty()) {
                    rewriteParameters.addAll(this.myBounds.rewriteParameters);
                    this.myBounds.rewriteParameters = ContainerUtil.newArrayList((Iterable)rewriteParameters);
                }
                if (defaultValue != null) {
                    this.myBounds.defaultValue = defaultValue;
                }
            }
        }
        this.mySqlDialect = DatabaseDriverImpl.getOverride(config.getAttributeValue("dialect"), this.mySqlDialect, merge);
        this.myIconName = DatabaseDriverImpl.getOverride(config.getAttributeValue("icon"), this.myIconName, merge);
        if (!StringUtil.isEmpty((String)this.myIconName)) {
            this.myIcon = IconLoader.findIcon((String)this.myIconName);
        }
        ArrayList templates = ContainerUtil.newArrayList();
        if (merge) {
            templates.addAll(this.myUrlTemplates);
        }
        for (Object element : config.getChildren("url-template")) {
            String name = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("name"), "default");
            String template = DatabaseDriverImpl.getIfNotNull(element.getAttributeValue("template"), element.getValue());
            if (StringUtil.isEmpty((String)template)) continue;
            templates.add(new UrlTemplate(name, template));
        }
        this.setURLTemplates(templates);
        if (!merge) {
            this.myVmEnv.clear();
        }
        if ((env = config.getChild("vm-env")) != null) {
            for (Element property : env.getChildren("property")) {
                this.myVmEnv.put(property.getAttributeValue("name"), property.getAttributeValue("value"));
            }
        }
        for (Element element : config.getChildren("vm-options")) {
            this.myVmOptions = DatabaseDriverImpl.getOverride(element.getTextTrim(), this.myVmOptions, merge);
        }
        for (Element element : config.getChildren("artifact")) {
            String name = DatabaseDriverImpl.getOverride(element.getAttributeValue("name"), this.myArtifactRef == null ? null : this.myArtifactRef.getName(), merge);
            String version = DatabaseDriverImpl.getOverride(element.getAttributeValue("version"), this.myArtifactRef == null ? null : this.myArtifactRef.getVersion(), merge);
            String rolling = DatabaseDriverImpl.getOverride(element.getAttributeValue("rolling"), this.myArtifactRef == null ? null : Boolean.toString(this.myArtifactRef.isRolling()), merge);
            this.myArtifactRef = ArtifactRefImpl.update(this.myArtifactRef, merge, name, version, !Boolean.FALSE.toString().equals(rolling));
            if (this.myArtifactRef == null) continue;
            this.myArtifactRef.setUseArtifact(Boolean.TRUE.toString().equals(element.getAttributeValue("use")));
            for (Element lib : element.getChildren("library")) {
                if (pathMacroManager != null) {
                    pathMacroManager.expandPaths(lib);
                }
                this.myArtifactRef.appendLegacy(SimpleClasspathElementFactory.createElements(null, (Element)lib));
            }
        }
        if (!merge) {
            this.myOptions.clear();
        }
        for (Element element : config.getChildren("option")) {
            optionName = element.getAttributeValue("name");
            String value = element.getAttributeValue("value");
            DatabaseDriver.Option option = DatabaseDriver.Option.byName(optionName);
            if (option == null) continue;
            this.myOptions.put(option, value);
        }
        if (!merge) {
            this.myDriverProperties.clear();
        }
        for (Element element : config.getChildren("property")) {
            optionName = element.getAttributeValue("name");
            if (StringUtil.isEmpty((String)optionName)) continue;
            this.myDriverProperties.put(optionName, element.getAttributeValue("value"));
        }
        if (!merge) {
            this.myAdditionalClasspathElements.clear();
        }
        String downloadRoot = VfsUtilCore.pathToUrl((String)DatabaseDriverImpl.getDriverDownloadDirectory());
        for (Element element : config.getChildren("library")) {
            ArrayList artifact = ContainerUtil.newArrayList();
            ArrayList additional = ContainerUtil.newArrayList();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(element);
            }
            for (SimpleClasspathElement e : SimpleClasspathElementFactory.createElements(null, (Element)element)) {
                boolean downloaded = false;
                if (format < 163 && this.myArtifactRef != null) {
                    downloaded = true;
                    for (String root2 : e.getClassesRootUrls()) {
                        if (root2.startsWith(downloadRoot)) continue;
                        downloaded = false;
                        break;
                    }
                }
                (downloaded ? artifact : additional).add(e);
            }
            if (this.myArtifactRef != null && !artifact.isEmpty()) {
                this.myArtifactRef.appendLegacy(artifact);
            }
            this.myAdditionalClasspathElements.addAll(additional);
        }
        DatabaseDriverImpl databaseDriverImpl = this;
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "loadState"));
        }
        return databaseDriverImpl;
    }

    public Element getState(@Nullable DatabaseDriver predef) {
        DatabaseDriver.Bounds preBounds;
        boolean allOptions;
        Element result2 = new Element("driver");
        result2.setAttribute("id", this.myId);
        boolean bl = allOptions = !this.myPredefined || predef == null;
        if (allOptions || !Comparing.equal((String)predef.getName(), (String)this.myName)) {
            result2.setAttribute("name", StringUtil.notNullize((String)this.myName));
        }
        if (this.mySqlDialect != null && (allOptions || !Comparing.equal((String)predef.getSqlDialect(), (String)this.mySqlDialect))) {
            result2.setAttribute("dialect", this.mySqlDialect);
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)(predef == null ? null : predef.getDriverClass()))) {
            result2.setAttribute("driver-class", this.myDriverClass);
        }
        if (allOptions && StringUtil.isNotEmpty((String)this.myIconName)) {
            result2.setAttribute("icon", this.myIconName);
        }
        HashSet predefTemplates = predef == null ? Collections.emptySet() : ContainerUtil.newHashSet(((DatabaseDriverImpl)predef).myUrlTemplates);
        for (UrlTemplate template : this.myUrlTemplates) {
            if (predefTemplates.contains(template)) continue;
            Element tplElement = new Element("url-template");
            tplElement.setAttribute("name", template.getName());
            tplElement.setAttribute("template", template.getTemplate());
            result2.addContent(tplElement);
        }
        DatabaseDriver.Bounds bounds = preBounds = predef == null ? null : predef.getConnectionBounds();
        if (!Comparing.equal((Object)this.myBounds, (Object)preBounds)) {
            Element bounds2 = new Element("connection-bounds");
            if (preBounds == null) {
                preBounds = new DatabaseDriver.Bounds();
            }
            if (!Comparing.equal((Object)this.myBounds.inReadOnlyMode, (Object)preBounds.inReadOnlyMode)) {
                bounds2.setAttribute("in-read-only", Boolean.toString(this.myBounds.inReadOnlyMode));
            }
            if (!Comparing.equal((Object)this.myBounds.boundTo, (Object)preBounds.boundTo)) {
                bounds2.setAttribute("bound-to", this.myBounds.boundTo.code());
            }
            if (!Comparing.equal(this.myBounds.rewriteParameters, preBounds.rewriteParameters)) {
                for (Pair pair : this.myBounds.rewriteParameters) {
                    Element param = new Element("rewrite-parameter");
                    param.setAttribute("name", (String)pair.first);
                    if (((Boolean)pair.second).booleanValue()) {
                        param.setAttribute("in-url", "true");
                    }
                    bounds2.addContent(param);
                }
            }
            if (!Comparing.equal((String)this.myBounds.defaultValue, (String)preBounds.defaultValue)) {
                bounds2.setAttribute("default-value", StringUtil.notNullize((String)this.myBounds.defaultValue));
            }
            result2.addContent(bounds2);
        }
        if (this.myArtifactRef != null) {
            Element artifactElement = new Element("artifact");
            artifactElement.setAttribute("name", this.myArtifactRef.getName());
            if (!this.myArtifactRef.isRolling()) {
                artifactElement.setAttribute("rolling", Boolean.FALSE.toString());
            }
            if (this.myArtifactRef.isUsed()) {
                artifactElement.setAttribute("use", Boolean.TRUE.toString());
            }
            if (this.myArtifactRef.getVersion() != null) {
                artifactElement.setAttribute("version", this.myArtifactRef.getVersion());
            } else {
                DatabaseDriverImpl.serializeClassPathElements(artifactElement, this.myArtifactRef.getElements());
            }
            result2.addContent(artifactElement);
        }
        for (DatabaseDriver.Option option : this.myOptions.keySet()) {
            if (!allOptions && option.isFixed()) continue;
            Element element = new Element("option");
            element.setAttribute("name", option.getName());
            element.setAttribute("value", this.myOptions.get(option));
            result2.addContent(element);
        }
        if (StringUtil.isNotEmpty((String)this.myVmOptions)) {
            Element e = new Element("vm-options");
            e.setText(this.myVmOptions);
            result2.addContent(e);
        }
        if (!this.myVmEnv.isEmpty()) {
            Element env = new Element("vm-env");
            for (String string : this.myVmEnv.keySet()) {
                Element prop = new Element("property");
                prop.setAttribute("name", string);
                prop.setAttribute("value", this.myVmEnv.get(string));
                env.addContent(prop);
            }
            result2.addContent(env);
        }
        Map<Object, Object> predefProps = predef == null ? Collections.emptyMap() : predef.getDriverProperties();
        for (Map.Entry entry : this.myDriverProperties.entrySet()) {
            if (Comparing.equal((String)((String)predefProps.get(entry.getKey())), (String)((String)entry.getValue()))) continue;
            Element optionElement = new Element("property");
            optionElement.setAttribute("name", (String)entry.getKey());
            optionElement.setAttribute("value", (String)entry.getValue());
            result2.addContent(optionElement);
        }
        DatabaseDriverImpl.serializeClassPathElements(result2, this.myAdditionalClasspathElements);
        return result2;
    }

    private static void serializeClassPathElements(Element result2, List<SimpleClasspathElement> classpathElements) {
        for (SimpleClasspathElement cpe : classpathElements) {
            Element libraryElement = new Element("library");
            try {
                cpe.serialize(libraryElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            result2.addContent(libraryElement);
        }
    }

    private static String getIfNotNull(String value, String defaultValue) {
        return StringUtil.isEmpty((String)value) ? defaultValue : value;
    }

    private static String getOverride(String value, String oldValue, boolean merge) {
        return merge ? DatabaseDriverImpl.getIfNotNull(value, oldValue) : value;
    }

    public void setAdditionalClasspathElements(List<SimpleClasspathElement> classpathElements) {
        this.myAdditionalClasspathElements.clear();
        this.myAdditionalClasspathElements.addAll(classpathElements);
    }

    @Override
    @NotNull
    public List<SimpleClasspathElement> getAdditionalClasspathElements() {
        List<SimpleClasspathElement> list = this.myAdditionalClasspathElements;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getAdditionalClasspathElements"));
        }
        return list;
    }

    public static String getDriverDownloadDirectory() {
        String configPath = PathManager.getConfigPath();
        File config = new File(configPath + "/jdbc-drivers");
        if (!config.exists() && !config.mkdirs()) {
            LOG.warn("Unable to create directory: " + config.getAbsolutePath());
        }
        return config.getPath();
    }

    @NotNull
    public DatabaseDriverImpl copy(@Nullable String newName, boolean withId) {
        DatabaseDriverImpl result2 = new DatabaseDriverImpl(withId ? this.myId : null, (String)ObjectUtils.chooseNotNull((Object)newName, (Object)this.myName), null, null);
        DatabaseDriverImpl databaseDriverImpl = result2.loadState(this.getState(null), false, false, Integer.MAX_VALUE);
        if (databaseDriverImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "copy"));
        }
        return databaseDriverImpl;
    }

    public boolean equalConfiguration(DatabaseDriverImpl o, boolean ignoreClassPath) {
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myName), (String)StringUtil.nullize((String)o.myName))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myArtifactRef, (Object)o.myArtifactRef)) {
            return false;
        }
        if (!ignoreClassPath && !this.myAdditionalClasspathElements.equals(o.myAdditionalClasspathElements)) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.mySqlDialect), (String)StringUtil.nullize((String)o.mySqlDialect))) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myDriverClass), (String)StringUtil.nullize((String)o.myDriverClass))) {
            return false;
        }
        if (!Comparing.equal((Object)this.myBounds, (Object)o.myBounds)) {
            return false;
        }
        if (!this.myDriverProperties.equals(o.myDriverProperties)) {
            return false;
        }
        for (DatabaseDriver.Option<?> option : DatabaseDriver.Option.enumerate()) {
            if (Comparing.equal(this.getOption(option), o.getOption(option))) continue;
            return false;
        }
        if (this.myUrlTemplates != null ? !this.myUrlTemplates.equals(o.myUrlTemplates) : o.myUrlTemplates != null) {
            return false;
        }
        if (!Comparing.equal((String)StringUtil.nullize((String)this.myVmOptions), (String)StringUtil.nullize((String)o.myVmOptions))) {
            return false;
        }
        return ContainerUtil.diff(this.myVmEnv, o.myVmEnv).isEmpty();
    }

    public boolean equalConfiguration(DatabaseDriverImpl o) {
        return this.equalConfiguration(o, false);
    }

    public String toString() {
        return "LocalDatabaseDriver{myId='" + this.myId + '\'' + ", myName='" + this.myName + '\'' + '}';
    }

    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/database/dataSource/DatabaseDriverImpl", "dump"));
        }
        sb.append("Id - ").append(this.getId()).append("\n");
        sb.append("Name - ").append(this.getName()).append("\n");
        sb.append("DriverClass - ").append(this.getDriverClass()).append("\n");
        sb.append("Dialect - ").append(this.getSqlDialect()).append("\n");
        sb.append("IconName - ").append(this.getIconName()).append("\n");
        sb.append("VmOptions - ").append(this.getVmOptions()).append("\n");
        sb.append("Predefined - ").append(this.isPredefined()).append("\n");
        sb.append("UrlTemplates").append("\n");
        for (UrlTemplate urlTemplate : this.getUrlTemplates()) {
            sb.append(" * ").append(urlTemplate.getName()).append(" - ").append(urlTemplate.getTemplate()).append("\n");
        }
        sb.append("DriverProperties").append("\n");
        for (Map.Entry entry : this.getDriverProperties().entrySet()) {
            sb.append(" * ").append((String)entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("Option").append("\n");
        for (Map.Entry entry : this.myOptions.entrySet()) {
            sb.append(" * ").append(entry.getKey()).append(" - ").append((String)entry.getValue()).append("\n");
        }
        sb.append("ArtifactName - ").append(this.getArtifactName()).append("\n");
        if (this.myArtifactRef != null) {
            for (SimpleClasspathElement simpleClasspathElement : this.myArtifactRef.getElements()) {
                sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
            }
        }
        sb.append("Bounds - ");
        if (this.myBounds != null) {
            sb.append("boundTo: ").append(this.myBounds.boundTo);
            sb.append("defaultValue: ").append(this.myBounds.defaultValue);
            sb.append("inReadOnlyMode: ").append(this.myBounds.inReadOnlyMode);
            sb.append("rewriteParameters:");
            for (Pair pair : this.myBounds.rewriteParameters) {
                sb.append(" ").append((String)pair.first);
                if (!((Boolean)pair.second).booleanValue()) continue;
                sb.append(":in-url");
            }
        } else {
            sb.append("null");
        }
        sb.append("\n");
        sb.append("ClasspathElements").append("\n");
        for (SimpleClasspathElement simpleClasspathElement : this.getAdditionalClasspathElements()) {
            sb.append(" * ").append(simpleClasspathElement.getPresentableName()).append("\n");
        }
    }

    @Nullable
    public static SqlLanguageDialect getLanguage(@Nullable DatabaseDriver driver) {
        if (driver == null || driver.getSqlDialect() == null) {
            return null;
        }
        return (SqlLanguageDialect)ObjectUtils.tryCast((Object)Language.findLanguageByID((String)driver.getSqlDialect()), SqlLanguageDialect.class);
    }

    @NotNull
    public List<SimpleClasspathElement> getArtifactClasspathElements() {
        List<SimpleClasspathElement> list = this.myArtifactRef == null ? Collections.emptyList() : this.myArtifactRef.getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl", "getArtifactClasspathElements"));
        }
        return list;
    }

    public void setArtifact(@Nullable String name, @Nullable String version, boolean rolling) {
        this.myArtifactRef = ArtifactRefImpl.update(this.myArtifactRef, true, name, version, rolling);
    }

    public void setUseArtifact(boolean use) {
        if (this.myArtifactRef != null) {
            this.myArtifactRef.setUseArtifact(use);
        }
    }

    private static class ArtifactRefImpl
    implements DatabaseDriver.ArtifactRef {
        private Boolean myUseArtifact;
        private final boolean myRolling;
        private final String myName;
        private final String myVersion;
        private final List<SimpleClasspathElement> myLegacyElements;

        @Nullable
        public static ArtifactRefImpl create(@Nullable String name, @Nullable String version, boolean rolling) {
            return StringUtil.isEmpty((String)name) ? null : new ArtifactRefImpl(name, version, rolling);
        }

        @Nullable
        public static ArtifactRefImpl update(@Nullable ArtifactRefImpl prev, boolean merge, @Nullable String name, @Nullable String version, boolean rolling) {
            boolean changed;
            if (!merge) {
                return ArtifactRefImpl.create(name, version, rolling);
            }
            boolean bl = changed = prev == null || !Comparing.equal((String)prev.getName(), (String)name) || !Comparing.equal((String)prev.getVersion(), (String)version) || !Comparing.equal((Object)prev.isRolling(), (Object)rolling);
            if (!changed) {
                return prev;
            }
            ArtifactRefImpl res = ArtifactRefImpl.create(name, version, rolling);
            if (res != null && prev != null) {
                if (version == null) {
                    res.appendLegacy(prev.myLegacyElements);
                }
                if (prev.isUsed()) {
                    res.setUseArtifact(true);
                }
            }
            return res;
        }

        public ArtifactRefImpl(@NotNull String name, @Nullable String version, boolean rolling) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl", "<init>"));
            }
            this.myUseArtifact = null;
            this.myLegacyElements = ContainerUtil.newArrayList();
            if ("latest".equals(version)) {
                throw new AssertionError((Object)"Should be concrete version");
            }
            this.myName = name;
            this.myVersion = version;
            this.myRolling = rolling;
        }

        @Override
        public boolean isUsed() {
            if (this.myUseArtifact == null) {
                return !this.myLegacyElements.isEmpty();
            }
            return this.myUseArtifact;
        }

        public void setUseArtifact(boolean useArtifact) {
            this.myUseArtifact = useArtifact;
        }

        public void appendLegacy(@NotNull List<SimpleClasspathElement> items) {
            if (items == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl", "appendLegacy"));
            }
            if (items.isEmpty()) {
                return;
            }
            this.myLegacyElements.addAll(items);
            if (this.myUseArtifact == null) {
                this.myUseArtifact = true;
            }
        }

        @NotNull
        public List<SimpleClasspathElement> getElements() {
            if (this.myVersion == null) {
                List<SimpleClasspathElement> list = this.myLegacyElements;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl", "getElements"));
                }
                return list;
            }
            VirtualFile[] files = DatabaseArtifactManager.getInstance().getFiles(this.myName, this.myVersion);
            String[] urls = new String[files.length];
            for (int i2 = 0; i2 < files.length; ++i2) {
                urls[i2] = files[i2].getUrl();
            }
            List list = SimpleClasspathElementFactory.createElements((String[])urls);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl", "getElements"));
            }
            return list;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseDriverImpl$ArtifactRefImpl", "getName"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArtifactRefImpl ref = (ArtifactRefImpl)o;
            if (this.myRolling != ref.myRolling) {
                return false;
            }
            if (!Comparing.equal((Object)this.isUsed(), (Object)ref.isUsed())) {
                return false;
            }
            if (!this.myName.equals(ref.myName)) {
                return false;
            }
            return !(this.myVersion != null ? !this.myVersion.equals(ref.myVersion) : ref.myVersion != null);
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.isUsed());
            result2 = 31 * result2 + (this.myRolling ? 1 : 0);
            result2 = 31 * result2 + this.myName.hashCode();
            result2 = 31 * result2 + (this.myVersion != null ? this.myVersion.hashCode() : 0);
            return result2;
        }

        @Override
        @Nullable
        public String getVersion() {
            return this.myVersion;
        }

        @Override
        public boolean isRolling() {
            return this.myRolling;
        }
    }
}

