/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcMapping {
    private static final DbSrcMapping INSTANCE = new DbSrcMapping();

    @NotNull
    public static DbSrcMapping getInstance() {
        DbSrcMapping dbSrcMapping = INSTANCE;
        if (dbSrcMapping == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "getInstance"));
        }
        return dbSrcMapping;
    }

    @Nullable
    public DbElement getDbElement(@NotNull PsiObject object) {
        VirtualFile vfile;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "getDbElement"));
        }
        if (object instanceof DbElement) {
            return (DbElement)object;
        }
        PsiFile file = object.getContainingFile();
        file = file == null ? null : file.getOriginalFile();
        VirtualFile virtualFile = vfile = file == null ? null : file.getVirtualFile();
        if (vfile == null || !(vfile.getFileSystem() instanceof DbSrcFileSystem)) {
            return null;
        }
        return DbSrcUtils.findObject(vfile.getPath(), (PairFunction<Project, String, DasModel>)((PairFunction)(p, id) -> {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "lambda$getDbElement$0"));
            }
            DbDataSource ds = DbPsiFacade.getInstance((Project)object.getProject()).findDataSource(id);
            return ds == null ? null : ds.getModel();
        }), DbElement.class, false);
    }

    @Nullable
    public static DbElement getElement(@Nullable DbSrcStorageLayout.Item path, @NotNull DbDataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ds", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "getElement"));
        }
        return path == null ? null : DbSrcUtils.findObject(path.getObject(), ds.getModel(), DbElement.class, false);
    }

    public boolean processSources(@NotNull DbElement el, @NotNull Consumer<PsiElement> consumer) {
        PsiObject psiSrc;
        DbDataSource ds;
        LocalDataSource local;
        if (el == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "el", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "processSources"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dataSource/srcStorage/DbSrcMapping", "processSources"));
        }
        boolean result2 = false;
        PsiElement delegate = (PsiElement)ObjectUtils.tryCast((Object)el.getDelegate(), PsiElement.class);
        if (delegate != null) {
            consumer.consume((Object)delegate);
            result2 = true;
        }
        if ((local = (LocalDataSource)ObjectUtils.tryCast((Object)(ds = el.getDataSource()).getDelegate(), LocalDataSource.class)) == null || !DbSrcStorage.isEnabled()) {
            return false;
        }
        Project project = local.isGlobal() ? null : ds.getProject();
        VirtualFile file = DbSrcFileSystem.getInstance().findFileByPath(DbSrcFileSystem.getPath(project, ds.getUniqueId(), DbSrcPath.of((DasObject)el), true));
        PsiFile psiFile = file == null ? null : el.getManager().findFile(file);
        PsiObject psiObject = psiSrc = psiFile == null ? null : (PsiObject)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)psiFile).expand(psi -> !(psi instanceof SqlStatement))).filter(PsiObject.class).filter(DasUtil.byKind((ObjectKind)el.getKind())).first();
        if (psiSrc != null) {
            consumer.consume(psiSrc);
            result2 = true;
        }
        return result2;
    }
}

