/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.ui.SsrpHostParamEditor;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.PopupHandler;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpPortParamEditor
extends TextParamEditor {
    private final AnAction myDetectAction;

    public SsrpPortParamEditor(@NotNull DataInterchange interchange, @NotNull String caption) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor", "<init>"));
        }
        if (caption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caption", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor", "<init>"));
        }
        super(interchange, caption, TypesRegistry.ParamEditor.FieldSize.SMALL, new AnAction[0]);
        this.myDetectAction = new AnAction("Detect", "Detect from instance", AllIcons.Actions.Install){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(true);
                e.getPresentation().setEnabled(SsrpPortParamEditor.getSsrpPort(SsrpPortParamEditor.this.getInterchange()) != null);
            }

            public void actionPerformed(AnActionEvent e) {
                String port = SsrpPortParamEditor.getSsrpPort(SsrpPortParamEditor.this.getInterchange());
                if (port != null) {
                    SsrpPortParamEditor.this.setText(port);
                }
            }
        };
        PopupHandler.installPopupHandler(this.getEditorComponent(), (ActionGroup)new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = (AnAction[])ContainerUtil.ar((Object[])new AnAction[]{SsrpPortParamEditor.this.myDetectAction});
                if (anActionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor$2", "getChildren"));
                }
                return anActionArray;
            }
        }, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @Nullable
    private static SsrpInfo.SsrpServer getSsrpServer(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor", "getSsrpServer"));
        }
        SsrpInfo info = (SsrpInfo)SsrpHostParamEditor.SSRP_INFO.get((UserDataHolder)interchange);
        if (info == null) {
            return null;
        }
        String host = interchange.getProperty("host");
        return host == null ? null : info.getServer(host);
    }

    @Nullable
    private static SsrpInfo.SsrpInstance getSsrpInstance(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor", "getSsrpInstance"));
        }
        SsrpInfo.SsrpServer server = SsrpPortParamEditor.getSsrpServer(interchange);
        if (server == null) {
            return null;
        }
        String instance = interchange.getProperty("instance");
        return instance == null ? null : server.getInstance(instance);
    }

    @Nullable
    public static String getSsrpPort(@NotNull DataInterchange interchange) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/SsrpPortParamEditor", "getSsrpPort"));
        }
        SsrpInfo.SsrpInstance instance = SsrpPortParamEditor.getSsrpInstance(interchange);
        return instance == null ? null : instance.getAttribute("tcp");
    }
}

