/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseConfigValidator<T> {
    public static final ExtensionPointName<DatabaseConfigValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.configValidator");

    public static Set<DataSourceProblem> getProblems(@NotNull Object target, @Nullable DatabaseConfigEditor editor) {
        DatabaseConfigValidator[] extensions;
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/database/dataSource/validation/DatabaseConfigValidator", "getProblems"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        Consumer consumer = result2::add;
        for (DatabaseConfigValidator extension : extensions = (DatabaseConfigValidator[])Extensions.getExtensions(EP_NAME)) {
            if (!extension.getTargetClass().isInstance(target)) continue;
            extension.collectProblems(target, (Consumer<DataSourceProblem>)consumer, editor);
        }
        return result2;
    }

    public abstract Class<? extends T> getTargetClass();

    public abstract void collectProblems(@NotNull T var1, @NotNull Consumer<DataSourceProblem> var2, @Nullable DatabaseConfigEditor var3);
}

