/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.editor.GotoRowAction;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.UIBundle;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridPositionWidget
implements StatusBarWidget,
Consumer<MouseEvent>,
StatusBarWidget.TextPresentation,
StatusBarWidget.Multiframe,
FileEditorManagerListener {
    public static final Topic<Listener> TOPIC = new Topic("Grid Position", Listener.class);
    private final Project myProject;
    private DataGrid myGrid;
    private GotoRowAction.Counter myCounter;

    public GridPositionWidget(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridPositionWidget", "<init>"));
        }
        this.myProject = project;
    }

    @NotNull
    public String ID() {
        if ("GridPosition" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "ID"));
        }
        return "GridPosition";
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/GridPositionWidget", "getPresentation"));
        }
        return this;
    }

    public void install(final @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/database/datagrid/GridPositionWidget", "install"));
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(TOPIC, (Object)new Listener(){

            @Override
            public void changed(@NotNull DataGrid grid) {
                if (grid == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridPositionWidget$1", "changed"));
                }
                GridPositionWidget.this.set(grid, statusBar);
            }

            @Override
            public void closed() {
                GridPositionWidget.this.set(null, statusBar);
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/datagrid/GridPositionWidget$2", "selectionChanged"));
                }
                DataGrid grid = GridPositionWidget.this.getDataGrid(statusBar);
                GridPositionWidget.this.set(grid, statusBar);
            }
        });
    }

    public void dispose() {
    }

    public void consume(MouseEvent event) {
        if (!this.isReady()) {
            return;
        }
        GotoRowAction.showGoToDialog(this.myGrid);
    }

    @Nullable
    public String getTooltipText() {
        return !this.isReady() ? null : UIBundle.message((String)"go.to.line.command.double.click", (Object[])new Object[0]);
    }

    @Nullable
    public Consumer<MouseEvent> getClickConsumer() {
        return this;
    }

    @NotNull
    public String getText() {
        if (this.myGrid == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        SelectionModel model = this.myGrid.getSelectionModel();
        int cellCount = model.getSelectedColumnCount() * model.getSelectedRowCount();
        if (cellCount == 0) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
            }
            return "";
        }
        boolean editing = this.myGrid.isEditing();
        if (cellCount > 1) {
            sb.append(cellCount).append(" ").append(StringUtil.pluralize((String)"cell", (int)cellCount));
            if (editing) {
                String string = sb.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
                }
                return string;
            }
            sb.append("     ");
        }
        if (editing) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
            }
            return "";
        }
        int minRow = this.myCounter.verticalUnit(this.myGrid);
        int minColumn = this.myCounter.horizontalUnit(this.myGrid);
        if (minColumn == -1 || minRow == -1) {
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
            }
            return string;
        }
        sb.append(minRow + 1).append(":").append(minColumn + 1);
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getText"));
        }
        return string;
    }

    @NotNull
    public String getMaxPossibleText() {
        if ("0000000000000" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPositionWidget", "getMaxPossibleText"));
        }
        return "0000000000000";
    }

    public float getAlignment() {
        return 1.0f;
    }

    public StatusBarWidget copy() {
        return new GridPositionWidget(this.myProject);
    }

    @Nullable
    private DataGrid getDataGrid(@NotNull StatusBar bar) {
        if (bar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bar", "com/intellij/database/datagrid/GridPositionWidget", "getDataGrid"));
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((Project)this.myProject, (StatusBar)bar);
        return fileEditor instanceof TableEditorBase ? ((TableEditorBase)fileEditor).getDataGrid() : null;
    }

    private boolean isReady() {
        return this.myGrid != null && !this.myGrid.isEditing() && this.myGrid.getVisibleRowsCount() * this.myGrid.getVisibleColumns().size() > 0;
    }

    private void set(@Nullable DataGrid grid, @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/intellij/database/datagrid/GridPositionWidget", "set"));
        }
        if (grid != null && !this.isOurGrid(grid, statusBar)) {
            return;
        }
        this.myGrid = grid;
        this.myCounter = grid == null ? null : GotoRowAction.Counter.get(grid);
        statusBar.updateWidget(this.ID());
    }

    private boolean isOurGrid(@NotNull DataGrid grid, @NotNull StatusBar bar) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridPositionWidget", "isOurGrid"));
        }
        if (bar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bar", "com/intellij/database/datagrid/GridPositionWidget", "isOurGrid"));
        }
        return GridPositionWidget.isOurComponent(grid.getComponent(), this.myProject, bar);
    }

    private static boolean isOurComponent(@NotNull JComponent component, @NotNull Project project, @NotNull StatusBar bar) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/datagrid/GridPositionWidget", "isOurComponent"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridPositionWidget", "isOurComponent"));
        }
        if (bar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bar", "com/intellij/database/datagrid/GridPositionWidget", "isOurComponent"));
        }
        return WindowManager.getInstance().getStatusBar((Component)component, project) == bar;
    }

    static class Installer
    implements StartupActivity {
        Installer() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/datagrid/GridPositionWidget$Installer", "runActivity"));
            }
            StatusBar bar = WindowManager.getInstance().getStatusBar(project);
            if (bar != null) {
                bar.addWidget((StatusBarWidget)new GridPositionWidget(project), "before Position", (Disposable)project);
            }
        }
    }

    public static interface Listener {
        public void changed(@NotNull DataGrid var1);

        public void closed();
    }
}

