/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.CellMutation;
import com.intellij.database.datagrid.mutating.MutationData;
import gnu.trove.TIntHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutationsStorage
implements Iterable<Integer> {
    private static final double MULTIPLIER = 1.5;
    private final double myMultiplier;
    private final GridModel<DataConsumer.Row, DataConsumer.Column> myModel;
    private final TIntHashSet myModifiedRows;
    private MutationData[][] myValues;
    private int[] myModificationCount;
    private int myMaxRows;
    private int myRows;
    private int myMaxColumns;
    private int myColumns;

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns2) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/MutationsStorage", "<init>"));
        }
        this(model, rows, columns2, 1.5);
    }

    public MutationsStorage(@NotNull GridModel<DataConsumer.Row, DataConsumer.Column> model, int rows, int columns2, double multiplier) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/datagrid/MutationsStorage", "<init>"));
        }
        this.myMultiplier = multiplier;
        this.myRows = rows;
        this.myColumns = columns2;
        this.myMaxRows = this.getIncreasedValue(rows);
        this.myMaxColumns = this.getIncreasedValue(columns2);
        this.myModel = model;
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModificationCount = new int[this.myMaxRows];
        this.myModifiedRows = new TIntHashSet();
    }

    public void set(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable CellMutation value) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/MutationsStorage", "set"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/MutationsStorage", "set"));
        }
        if (!this.isValid(row, column)) {
            return;
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        if (rowIdx >= this.myMaxRows || colIdx >= this.myMaxColumns) {
            this.reallocate(Math.max(rowIdx, this.myMaxRows), Math.max(colIdx, this.myMaxColumns));
        }
        this.increase(rowIdx, colIdx);
        if (this.myValues[rowIdx] == null) {
            this.myValues[rowIdx] = new MutationData[this.myMaxColumns];
        }
        this.countModifications(value, rowIdx, colIdx);
        this.myValues[rowIdx][colIdx] = value == null ? null : new MutationData(value.getValue(), value.getType());
    }

    public void shiftUp(@NotNull ModelIndex<DataConsumer.Row> row) {
        int[] oldModifiedRows;
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/MutationsStorage", "shiftUp"));
        }
        int idx = row.asInteger();
        System.arraycopy(this.myValues, idx + 1, this.myValues, idx, this.myRows - 1 - idx);
        System.arraycopy(this.myModificationCount, idx + 1, this.myModificationCount, idx, this.myRows - 1 - idx);
        this.myValues[this.myRows - 1] = null;
        this.myModificationCount[this.myRows - 1] = 0;
        this.myModifiedRows.remove(idx);
        TIntHashSet newModifiedRows = new TIntHashSet();
        for (int oldRowIdx : oldModifiedRows = this.myModifiedRows.toArray()) {
            if (oldRowIdx > idx) {
                newModifiedRows.add(oldRowIdx - 1);
                continue;
            }
            newModifiedRows.add(oldRowIdx);
        }
        this.myModifiedRows.clear();
        this.myModifiedRows.addAll(newModifiedRows.toArray());
    }

    public int rowCount() {
        return this.myRows;
    }

    public int columnCount() {
        return this.myColumns;
    }

    @NotNull
    public int[] getAffectedRows() {
        int[] nArray = this.myModifiedRows.toArray();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/MutationsStorage", "getAffectedRows"));
        }
        return nArray;
    }

    public void delete(@NotNull ModelIndexSet<DataConsumer.Row> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/MutationsStorage", "delete"));
        }
        this.delete(rows.asList());
    }

    public void delete(@NotNull List<ModelIndex<DataConsumer.Row>> rows) {
        if (rows == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rows", "com/intellij/database/datagrid/MutationsStorage", "delete"));
        }
        rows.forEach(this::delete);
    }

    public void delete(@NotNull ModelIndex<DataConsumer.Row> rowIdx) {
        if (rowIdx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowIdx", "com/intellij/database/datagrid/MutationsStorage", "delete"));
        }
        if (!this.isValid(rowIdx)) {
            return;
        }
        int i2 = rowIdx.asInteger();
        if (i2 < this.myRows) {
            this.myValues[i2] = null;
            this.myModificationCount[i2] = 0;
        }
        this.myModifiedRows.remove(i2);
    }

    public boolean isModified(@NotNull ModelIndex<DataConsumer.Row> row) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/MutationsStorage", "isModified"));
        }
        return this.isValid(row) && this.isModified(row.asInteger());
    }

    @Nullable
    public MutationData get(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/MutationsStorage", "get"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/MutationsStorage", "get"));
        }
        int rowIdx = row.asInteger();
        int colIdx = column.asInteger();
        return !this.isValid(row, column) || rowIdx >= this.myRows || colIdx >= this.myColumns || this.myValues[rowIdx] == null ? null : this.myValues[rowIdx][colIdx];
    }

    public boolean isModified() {
        return !this.myModifiedRows.isEmpty();
    }

    public void clear() {
        this.myValues = new MutationData[this.myMaxRows][];
        this.myModificationCount = new int[this.myMaxRows];
        this.myModifiedRows.clear();
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row) {
        return this.isValid(row, null);
    }

    private boolean isValid(@Nullable ModelIndex<DataConsumer.Row> row, @Nullable ModelIndex<DataConsumer.Column> column) {
        return !(row != null && !row.isValid(this.myModel) || column != null && !column.isValid(this.myModel));
    }

    private void increase(int rows, int columns2) {
        this.myRows = rows >= this.myRows ? rows + 1 : this.myRows;
        this.myColumns = columns2 >= this.myColumns ? columns2 + 1 : this.myColumns;
    }

    private boolean isModified(int row) {
        return this.myModifiedRows.contains(row);
    }

    private void countModifications(@Nullable Object value, int rowIdx, int colIdx) {
        int count = value != null && this.myValues[rowIdx][colIdx] == null ? 1 : (this.myValues[rowIdx][colIdx] != null && value == null ? -1 : 0);
        int n = rowIdx;
        this.myModificationCount[n] = this.myModificationCount[n] + count;
        if (this.myModificationCount[rowIdx] > 0) {
            this.myModifiedRows.add(rowIdx);
            return;
        }
        this.myModifiedRows.remove(rowIdx);
    }

    private void reallocate(int rows, int columns2) {
        this.myMaxRows = rows >= this.myMaxRows ? this.getIncreasedValue(rows) : this.myMaxRows;
        this.myMaxColumns = columns2 >= this.myMaxColumns ? this.getIncreasedValue(columns2) : this.myMaxColumns;
        this.increase(rows, columns2);
        this.myValues = MutationsStorage.copy(this.myValues, this.myMaxRows, this.myMaxColumns);
        int[] newModificationCount = new int[this.myMaxRows];
        System.arraycopy(this.myModificationCount, 0, newModificationCount, 0, this.myModificationCount.length);
        this.myModificationCount = newModificationCount;
    }

    @Override
    public Iterator<Integer> iterator() {
        return Arrays.stream(this.myModifiedRows.toArray()).iterator();
    }

    @NotNull
    private static MutationData[][] copy(@NotNull MutationData[][] from, int rows, int columns2) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/datagrid/MutationsStorage", "copy"));
        }
        MutationData[][] newArray = new MutationData[rows][];
        for (int i2 = 0; i2 < from.length; ++i2) {
            if (from[i2] == null) continue;
            newArray[i2] = new MutationData[columns2];
            System.arraycopy(from[i2], 0, newArray[i2], 0, from[i2].length);
        }
        if (newArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/MutationsStorage", "copy"));
        }
        return newArray;
    }

    private int getIncreasedValue(int value) {
        return (int)Math.round((double)value * this.myMultiplier);
    }
}

