/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.datagrid.CsvLexer;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.OffsetBatchRecords;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamCsvFormatParser {
    private static final int ERROR_TEXT_SIZE = 15;
    private static final int NOT_IMPORTANT = -1;
    private final int myMaxChars;
    private final CsvFormat myDataFormat;
    private final CsvLexer myLexer;
    private List<ErrorRecord> myErrors;
    private Token[] myHeader;

    public StreamCsvFormatParser(@NotNull CsvFormat format, int maxChars) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "<init>"));
        }
        this.myDataFormat = format;
        this.myMaxChars = maxChars;
        this.myLexer = new CsvLexer();
        this.myLexer.setCsvFormat((CsvRecordFormat)ObjectUtils.chooseNotNull((Object)format.headerRecord, (Object)format.dataRecord));
    }

    @Nullable
    public CsvParserResult parse(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "parse"));
        }
        long startCharacters = this.myLexer.getCharacters();
        if (startCharacters != 0L && this.myHeader == null) {
            return null;
        }
        this.myErrors = ContainerUtil.newArrayList();
        ArrayList result2 = ContainerUtil.newArrayList();
        if (!this.parseHeader(reader, startCharacters)) {
            if (this.myErrors.isEmpty()) {
                this.myErrors.add(new MyRecord());
            }
            return new CsvParserResult(null, ContainerUtil.emptyList(), this.myErrors, this.myLexer.getCharacters() - startCharacters);
        }
        if (startCharacters == 0L && this.myDataFormat.headerRecord == null) {
            result2.add(this.myHeader);
        }
        this.parseRecords(reader, result2, startCharacters);
        return !result2.isEmpty() || !this.myErrors.isEmpty() ? new CsvParserResult(this.myHeader, result2, this.myErrors, this.myLexer.getCharacters() - startCharacters) : null;
    }

    private void parseRecords(@NotNull Reader reader, @NotNull List<Token[]> result2, long startCharacters) throws IOException {
        Token[] e;
        int count;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecords"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecords"));
        }
        int n = count = this.myDataFormat.rowNumbers ? this.myHeader.length + 1 : this.myHeader.length;
        while (CsvLexer.isReady(reader) && (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxChars || result2.isEmpty()) && (e = this.getRecord(reader, this.myDataFormat.dataRecord, count)) != null) {
            result2.add(e);
        }
    }

    private boolean parseHeader(@NotNull Reader reader, long startCharacters) throws IOException {
        CsvRecordFormat headerFormat;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseHeader"));
        }
        if (this.myHeader != null) {
            return true;
        }
        CsvRecordFormat csvRecordFormat = headerFormat = this.myDataFormat.headerRecord == null ? this.myDataFormat.dataRecord : this.myDataFormat.headerRecord;
        while (this.myLexer.getCharacters() - startCharacters < (long)this.myMaxChars && CsvLexer.isReady(reader) && this.myHeader == null) {
            this.myHeader = this.getRecord(reader, headerFormat, -1);
        }
        this.myLexer.setCsvFormat(this.myDataFormat.dataRecord);
        return this.myHeader != null;
    }

    @Nullable
    private Token[] getRecord(@NotNull Reader reader, @NotNull CsvRecordFormat format, int count) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "getRecord"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "getRecord"));
        }
        List<Token> record = null;
        while (CsvLexer.isReady(reader) && record == null) {
            try {
                record = this.parseRecord(reader, this.myLexer, format, count);
            }
            catch (CsvParserException e) {
                this.myErrors.add((ErrorRecord)new OffsetBatchRecords.OffsetRecord((Exception)e, e.getLine(), e.getOffset()));
            }
        }
        return record == null ? null : (Token[])ContainerUtil.toArray(record, Token[]::new);
    }

    @NotNull
    private List<Token> parseRecord(@NotNull Reader reader, @NotNull CsvLexer lexer, @NotNull CsvRecordFormat format, int count) throws IOException, CsvParserException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecord"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecord"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecord"));
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        ParserChain chain = new ParserChain(format).advance().maybe(CsvLexer.TokenType.PREFIX).stopIfNull().member(this.valuesChain(format, lexer, result2, count)).member((r, l) -> {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "lambda$parseRecord$1"));
            }
            StreamCsvFormatParser.checkUnexpectedCount(format, result2, r, l, count);
        }).maybe(CsvLexer.TokenType.SUFFIX).typesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR);
        chain.keep(reader, lexer);
        List list = result2.isEmpty() || !this.myDataFormat.rowNumbers ? result2 : ContainerUtil.subList((List)result2, (int)1);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser", "parseRecord"));
        }
        return list;
    }

    @NotNull
    private ParserChain valuesChain(@NotNull CsvRecordFormat format, @NotNull CsvLexer lexer, @NotNull List<Token> result2, int count) throws CsvParserException, IOException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "valuesChain"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "valuesChain"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/datagrid/StreamCsvFormatParser", "valuesChain"));
        }
        ParserChain valueChain = new ParserChain(format);
        ParserChain chain = new ParserChain(format).memberWhile((Condition<CsvLexer>)((Condition)StreamCsvFormatParser::shouldReadValue), valueChain);
        ParserChain countChain = new ParserChain(format).maybe(CsvLexer.TokenType.SUFFIX).typesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR);
        valueChain.types(CsvLexer.TokenType.VALUE, CsvLexer.TokenType.QUOTED_VALUE).member((r, l) -> {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/datagrid/StreamCsvFormatParser", "lambda$valuesChain$2"));
            }
            result2.add(this.createValueToken(l));
        }).advance().memberIf((Condition<CsvLexer>)((Condition)l -> {
            if (result2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/datagrid/StreamCsvFormatParser", "lambda$valuesChain$3"));
            }
            if (lexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "lambda$valuesChain$3"));
            }
            return count != -1 && count == result2.size() && lexer.getType() != null;
        }), countChain).stopIfTypesOrNull(CsvLexer.TokenType.RECORD_SEPARATOR, CsvLexer.TokenType.SUFFIX).types(CsvLexer.TokenType.VALUE_SEPARATOR).advance();
        ParserChain parserChain = chain;
        if (parserChain == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser", "valuesChain"));
        }
        return parserChain;
    }

    @Nullable
    private Token createValueToken(@NotNull CsvLexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "createValueToken"));
        }
        String text = lexer.getText();
        if (text == null) {
            return null;
        }
        if (text.length() >= 0x500000) {
            this.myErrors.add((ErrorRecord)new OffsetBatchRecords.OffsetRecord((Exception)new MaxCharactersReachedException(StreamCsvFormatParser.cut(text)), lexer.getTokenLine(), lexer.getOffset()));
        }
        return StreamCsvFormatParser.createToken(lexer);
    }

    private static void checkUnexpectedCount(@NotNull CsvRecordFormat format, @NotNull List<Token> result2, @NotNull Reader r, @NotNull CsvLexer l, int count) throws CsvParserException, IOException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "checkUnexpectedCount"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/datagrid/StreamCsvFormatParser", "checkUnexpectedCount"));
        }
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/datagrid/StreamCsvFormatParser", "checkUnexpectedCount"));
        }
        if (l == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "l", "com/intellij/database/datagrid/StreamCsvFormatParser", "checkUnexpectedCount"));
        }
        if (count != -1 && result2.size() < count) {
            throw StreamCsvFormatParser.newParserException(format, r, l, CsvLexer.TokenType.VALUE);
        }
    }

    private static boolean shouldReadValue(@NotNull CsvLexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "shouldReadValue"));
        }
        CsvLexer.TokenType type = lexer.getType();
        return type != null && type != CsvLexer.TokenType.SUFFIX && type != CsvLexer.TokenType.RECORD_SEPARATOR;
    }

    @NotNull
    private static CsvParserException newParserException(@NotNull CsvRecordFormat format, @NotNull Reader reader, @NotNull CsvLexer lexer, CsvLexer.TokenType ... types) throws IOException {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser", "newParserException"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "newParserException"));
        }
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "newParserException"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser", "newParserException"));
        }
        CsvLexer.TokenType type = lexer.getType();
        boolean hasToken = type == null;
        String text = hasToken ? StreamCsvFormatParser.cut(CsvLexer.readAhead(reader, 15)) : lexer.getText();
        long character = hasToken ? lexer.getLineCharacters() : lexer.getOffset();
        long line = hasToken ? lexer.getLine() : lexer.getTokenLine();
        CsvParserException csvParserException = new CsvParserException(text == null ? null : StringUtil.wrapWithDoubleQuote((String)text), StreamCsvFormatParser.createToken(lexer), format, character, line, types);
        if (csvParserException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser", "newParserException"));
        }
        return csvParserException;
    }

    @Contract(value="null -> null; !null -> !null")
    private static String cut(@Nullable String text) {
        return text == null ? null : text.substring(0, Math.min(text.length(), 15)) + "...";
    }

    @Nullable
    private static Token createToken(@NotNull CsvLexer lexer) {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "createToken"));
        }
        return lexer.hasToken() ? new Token((String)ObjectUtils.assertNotNull((Object)lexer.getText()), (CsvLexer.TokenType)ObjectUtils.assertNotNull((Object)lexer.getType()), lexer.getTokenLine(), lexer.getOffset(), lexer.getStart(), lexer.getEnd()) : null;
    }

    private static void restore(@NotNull CsvLexer lexer, @NotNull Reader reader) throws IOException {
        if (lexer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser", "restore"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser", "restore"));
        }
        while (CsvLexer.isReady(reader) && lexer.getType() != CsvLexer.TokenType.RECORD_SEPARATOR) {
            lexer.advance(reader);
        }
    }

    private static class MyRecord
    extends ErrorRecord {
        protected MyRecord() {
            super(0L);
        }

        @NotNull
        public String getMessage() {
            if ("couldn't parse header" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$MyRecord", "getMessage"));
            }
            return "couldn't parse header";
        }
    }

    public static class MaxCharactersReachedException
    extends Exception {
        public MaxCharactersReachedException(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/StreamCsvFormatParser$MaxCharactersReachedException", "<init>"));
            }
            super(String.format("too long value: \"%s\"", StringUtil.escapeStringCharacters((String)text)));
        }
    }

    private static interface Member {
        public void keep(@NotNull Reader var1, @NotNull CsvLexer var2) throws IOException, CsvParserException;
    }

    private static class ParserChain
    implements Member {
        private final List<Member> myMembers;
        private final CsvRecordFormat myFormat;

        public ParserChain(@NotNull CsvRecordFormat format) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "<init>"));
            }
            this.myFormat = format;
            this.myMembers = ContainerUtil.newArrayList();
        }

        @Override
        public void keep(@NotNull Reader reader, @NotNull CsvLexer lexer) throws IOException, CsvParserException {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "keep"));
            }
            if (lexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "keep"));
            }
            try {
                for (Member member : this.myMembers) {
                    member.keep(reader, lexer);
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @NotNull
        public ParserChain stopIfNull() {
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (lexer.getType() == null) {
                    throw new IllegalStateException();
                }
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "stopIfNull"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain stopIfTypesOrNull(CsvLexer.TokenType ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "stopIfTypesOrNull"));
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$stopIfTypesOrNull$1"));
                }
                if (lexer.getType() == null || ArrayUtil.contains((Object)lexer.getType(), (Object[])types)) {
                    throw new IllegalStateException();
                }
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "stopIfTypesOrNull"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain memberWhile(@NotNull Condition<CsvLexer> lexerCondition, @NotNull ParserChain resultChain) {
            if (lexerCondition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexerCondition", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "memberWhile"));
            }
            if (resultChain == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultChain", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "memberWhile"));
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (lexerCondition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexerCondition", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$memberWhile$2"));
                }
                if (resultChain == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultChain", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$memberWhile$2"));
                }
                while (lexerCondition.value((Object)lexer)) {
                    resultChain.keep(reader, lexer);
                }
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "memberWhile"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain maybe(@NotNull CsvLexer.TokenType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "maybe"));
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$maybe$3"));
                }
                CsvLexer.TokenType tokenType = lexer.getType();
                if (tokenType == type) {
                    lexer.advance(reader);
                }
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "maybe"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain member(@NotNull Member member) {
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "member"));
            }
            this.myMembers.add(member);
            ParserChain parserChain = this;
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "member"));
            }
            return parserChain;
        }

        public ParserChain memberIf(@NotNull Condition<CsvLexer> condition, @NotNull Member member) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "memberIf"));
            }
            if (member == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "memberIf"));
            }
            return this.member((reader, lexer) -> {
                if (condition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$memberIf$4"));
                }
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$memberIf$4"));
                }
                if (condition.value((Object)lexer)) {
                    member.keep(reader, lexer);
                }
            });
        }

        @NotNull
        public ParserChain typesOrNull(CsvLexer.TokenType ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "typesOrNull"));
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$typesOrNull$5"));
                }
                if (lexer.getType() == null) {
                    return;
                }
                ParserChain.assertTokenType(this.myFormat, lexer, reader, types);
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "typesOrNull"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain types(CsvLexer.TokenType ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "types"));
            }
            ParserChain parserChain = this.member((reader, lexer) -> {
                if (types == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "lambda$types$6"));
                }
                ParserChain.assertTokenType(this.myFormat, lexer, reader, types);
            });
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "types"));
            }
            return parserChain;
        }

        @NotNull
        public ParserChain advance() {
            ParserChain parserChain = this.member((reader, lexer) -> lexer.advance(reader));
            if (parserChain == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "advance"));
            }
            return parserChain;
        }

        private static void assertTokenType(@NotNull CsvRecordFormat format, @NotNull CsvLexer lexer, @NotNull Reader reader, CsvLexer.TokenType ... types) throws IOException, CsvParserException {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "assertTokenType"));
            }
            if (lexer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lexer", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "assertTokenType"));
            }
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "assertTokenType"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$ParserChain", "assertTokenType"));
            }
            CsvLexer.TokenType type = lexer.getType();
            if (type != null && ArrayUtil.contains((Object)type, (Object[])types)) {
                return;
            }
            CsvParserException e = StreamCsvFormatParser.newParserException(format, reader, lexer, types);
            if (type != null && type == CsvLexer.TokenType.RECORD_SEPARATOR) {
                throw e;
            }
            StreamCsvFormatParser.restore(lexer, reader);
            throw e;
        }
    }

    public static class Token {
        private final String myText;
        private final CsvLexer.TokenType myType;
        private final long myLine;
        private final long myOffset;
        private final long myStart;
        private final long myEnd;

        /*
         * WARNING - void declaration
         */
        public Token(@NotNull String text, @NotNull CsvLexer.TokenType type, long line, long offset, long l, long l2) {
            void end;
            void start;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/datagrid/StreamCsvFormatParser$Token", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/datagrid/StreamCsvFormatParser$Token", "<init>"));
            }
            this.myText = text;
            this.myType = type;
            this.myLine = line;
            this.myOffset = offset;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$Token", "getText"));
            }
            return string;
        }

        @NotNull
        public String getRepresentation() {
            String string = this.myType.getTokenRepresentation(this.myText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$Token", "getRepresentation"));
            }
            return string;
        }

        @NotNull
        public CsvLexer.TokenType getType() {
            CsvLexer.TokenType tokenType = this.myType;
            if (tokenType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$Token", "getType"));
            }
            return tokenType;
        }

        public long getStart() {
            return this.myStart;
        }

        public long getEnd() {
            return this.myEnd;
        }

        public long getLine() {
            return this.myLine;
        }

        public long getOffset() {
            return this.myOffset;
        }
    }

    public static class CsvParserResult {
        private final Token[] myHeader;
        private final List<Token[]> myRecords;
        private final List<ErrorRecord> myErrors;
        private final long myCharacters;

        public CsvParserResult(@Nullable Token[] header, @NotNull List<Token[]> records, @NotNull List<ErrorRecord> errors, long characters) {
            if (records == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult", "<init>"));
            }
            if (errors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult", "<init>"));
            }
            this.myHeader = header;
            this.myRecords = records;
            this.myErrors = errors;
            this.myCharacters = characters;
        }

        @Nullable
        public Token[] getHeader() {
            return this.myHeader;
        }

        @NotNull
        public List<Token[]> getRecords() {
            List<Token[]> list = this.myRecords;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult", "getRecords"));
            }
            return list;
        }

        public long getCharacters() {
            return this.myCharacters;
        }

        @NotNull
        public List<ErrorRecord> getErrors() {
            List<ErrorRecord> list = this.myErrors;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult", "getErrors"));
            }
            return list;
        }

        @NotNull
        public String getErrorText() {
            String string = StringUtil.join(this.myErrors, ErrorRecord::getMessage, (String)"\n");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserResult", "getErrorText"));
            }
            return string;
        }
    }

    public static class CsvParserException
    extends Exception {
        public static final String END_OF_FILE = "end of file";
        private static final String MASK = "actual: %s, expected: %s";
        private final long myCharacter;
        private final long myLine;

        /*
         * WARNING - void declaration
         */
        CsvParserException(@Nullable String text, @Nullable Token actual, @NotNull CsvRecordFormat format, long character, long line, CsvLexer.TokenType ... tokenTypeArray) {
            void expected;
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "<init>"));
            }
            if (tokenTypeArray == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "<init>"));
            }
            super(CsvParserException.getMessageText(format, actual, text, (CsvLexer.TokenType[])expected));
            this.myCharacter = character;
            this.myLine = line;
        }

        public long getOffset() {
            return this.myCharacter;
        }

        public long getLine() {
            return this.myLine;
        }

        @NotNull
        private static String getMessageText(@NotNull CsvRecordFormat format, @Nullable Token token, @Nullable String text, CsvLexer.TokenType ... types) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getMessageText"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getMessageText"));
            }
            String string = String.format(MASK, CsvParserException.getActualText(token, text), CsvParserException.getExpected(format, types));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getMessageText"));
            }
            return string;
        }

        @NotNull
        private static String getExpected(@NotNull CsvRecordFormat format, CsvLexer.TokenType ... types) {
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getExpected"));
            }
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getExpected"));
            }
            String string = StringUtil.escapeStringCharacters((String)StringUtil.join((Object[])types, type -> {
                if (format == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "lambda$getExpected$0"));
                }
                return type.getDebugName(format);
            }, (String)", "));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getExpected"));
            }
            return string;
        }

        @NotNull
        private static String getActualText(@Nullable Token token, @Nullable String text) {
            String string = token != null ? token.getType().getTokenRepresentation(token.getText()) : (text == null ? END_OF_FILE : StringUtil.wrapWithDoubleQuote((String)StringUtil.escapeStringCharacters((String)text)));
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/StreamCsvFormatParser$CsvParserException", "getActualText"));
            }
            return string;
        }
    }
}

