/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.Grid;
import com.intellij.database.datagrid.IndexSet;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ViewIndexSet<S>
extends IndexSet<ViewIndex<S>> {
    public static <Row> ViewIndexSet<Row> forRows(Grid<Row, ?> grid, int ... rows) {
        return new ViewIndexSet<Row>(rows){

            @Override
            @NotNull
            public ModelIndexSet<Row> toModel(@NotNull Grid<?, ?> grid) {
                if (grid == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ViewIndexSet$1", "toModel"));
                }
                ModelIndexSet<?> modelIndexSet = ModelIndexSet.forRows(grid, 1.convert(ViewIndex.row2Model(grid), this.asArray()));
                if (modelIndexSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ViewIndexSet$1", "toModel"));
                }
                return modelIndexSet;
            }

            @Override
            protected ViewIndex<Row> forValue(int value) {
                return ViewIndex.forRow(null, value);
            }
        };
    }

    public static <Column> ViewIndexSet<Column> forColumns(Grid<?, Column> grid, int ... columns2) {
        return new ViewIndexSet<Column>(columns2){

            @Override
            @NotNull
            public ModelIndexSet<Column> toModel(@NotNull Grid<?, ?> grid) {
                if (grid == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/ViewIndexSet$2", "toModel"));
                }
                ModelIndexSet<?> modelIndexSet = ModelIndexSet.forColumns(grid, 2.convert(ViewIndex.col2Model(grid), this.asArray()));
                if (modelIndexSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/ViewIndexSet$2", "toModel"));
                }
                return modelIndexSet;
            }

            @Override
            protected ViewIndex<Column> forValue(int value) {
                return ViewIndex.forColumn(null, value);
            }
        };
    }

    ViewIndexSet(int ... indices) {
        super(indices);
    }

    @NotNull
    public abstract ModelIndexSet<S> toModel(@NotNull Grid<?, ?> var1);

    public String toString() {
        return "ViewIndexSet{" + StringUtil.join((int[])this.values, (String)",") + "}";
    }
}

