/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.color;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.run.ui.grid.CellAttributes;
import com.intellij.database.run.ui.grid.GridMarkupModel;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupColorLayer
implements ColorLayer {
    @Override
    @Nullable
    public Color getCellBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/MarkupColorLayer", "getCellBackground"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/MarkupColorLayer", "getCellBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MarkupColorLayer", "getCellBackground"));
        }
        GridMarkupModel<DataConsumer.Row, DataConsumer.Column> model = grid.getMarkupModel();
        CellAttributes attributes = model.getCellAttributes(row, column, grid.getColorsScheme());
        Color bg = attributes == null ? null : attributes.getBackgroundColor();
        return bg == null ? color : bg;
    }

    @Override
    @Nullable
    public Color getRowHeaderBackground(@NotNull ModelIndex<DataConsumer.Row> row, @NotNull DataGrid grid, @Nullable Color color) {
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/color/MarkupColorLayer", "getRowHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MarkupColorLayer", "getRowHeaderBackground"));
        }
        GridMarkupModel model = grid.getMarkupModel();
        CellAttributes attributes = model.getRowHeaderAttributes(row, grid.getColorsScheme());
        Color bg = attributes == null ? null : attributes.getBackgroundColor();
        return bg == null ? color : bg;
    }

    @Override
    @Nullable
    public Color getColumnHeaderBackground(@NotNull ModelIndex<DataConsumer.Column> column, @NotNull DataGrid grid, @Nullable Color color) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/datagrid/color/MarkupColorLayer", "getColumnHeaderBackground"));
        }
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/color/MarkupColorLayer", "getColumnHeaderBackground"));
        }
        GridMarkupModel model = grid.getMarkupModel();
        CellAttributes attributes = model.getColumnHeaderAttributes(column, grid.getColorsScheme());
        Color bg = attributes == null ? null : attributes.getBackgroundColor();
        return bg == null ? color : bg;
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

