/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.model.DasTable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DmlMutationContext {
    private final List<RowMutation> myMutations;
    private final List<DataConsumer.Column> myColumns;
    private final DasTable myTable;

    public DmlMutationContext(@NotNull List<RowMutation> mutations, @Nullable List<DataConsumer.Column> columns2, @NotNull DasTable table) {
        if (mutations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mutations", "com/intellij/database/datagrid/mutating/DmlMutationContext", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/datagrid/mutating/DmlMutationContext", "<init>"));
        }
        this.myMutations = mutations;
        this.myColumns = columns2;
        this.myTable = table;
    }

    @Nullable
    public List<DataConsumer.Column> getColumns() {
        return this.myColumns;
    }

    @NotNull
    public List<RowMutation> getMutations() {
        List<RowMutation> list = this.myMutations;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/DmlMutationContext", "getMutations"));
        }
        return list;
    }

    @NotNull
    public DasTable getTable() {
        DasTable dasTable = this.myTable;
        if (dasTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/DmlMutationContext", "getTable"));
        }
        return dasTable;
    }
}

