/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DatabaseTableInput;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.ui.ImportSettingsComponent;
import com.intellij.database.dbimport.ui.component.DdlPreviewComponent;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.database.DatabaseDataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseInputType
implements ImportAction.InputType {
    private static final String TITLE_MASK = "Import \"%s\" Table";
    private final LocalDataSource myProducerLocalDataSource;
    private final String myQueryText;
    private final String myProducerName;
    private final SearchPath myPath;
    private final DasTable myTable;
    private final Project myProject;
    private final DbDataSource myProducerSource;

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource producerDataSource, @NotNull DasTable table, @NotNull Project project) {
        if (producerLocalDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerLocalDataSource", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (producerDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerDataSource", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        this(producerLocalDataSource, producerDataSource, table.getName(), DatabaseInputType.getQueryText(table, producerLocalDataSource, DbImplUtil.getDatabaseDialect((DbElement)producerDataSource)), project, DatabaseInputType.getSearchPath(producerDataSource, table), table);
    }

    public DatabaseInputType(@NotNull LocalDataSource producerLocalDataSource, @NotNull DbDataSource source, @NotNull String producerName, @NotNull String queryText, @NotNull Project project, @Nullable SearchPath path, @Nullable DasTable table) {
        if (producerLocalDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerLocalDataSource", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (producerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerName", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/DatabaseInputType", "<init>"));
        }
        this.myProducerLocalDataSource = producerLocalDataSource;
        this.myProducerName = producerName;
        this.myQueryText = queryText;
        this.myProject = project;
        this.myProducerSource = source;
        this.myPath = path;
        this.myTable = table;
    }

    @Override
    @NotNull
    public ReaderTask.Input createInput(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/DatabaseInputType", "createInput"));
        }
        DatabaseTableInput databaseTableInput = new DatabaseTableInput(this.myProducerSource, this.myProducerLocalDataSource, this.myPath, this.myQueryText, this.myProject);
        if (databaseTableInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "createInput"));
        }
        return databaseTableInput;
    }

    @Override
    @NotNull
    public List<ImportComponent<?, ?>> getComponents(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/DatabaseInputType", "getComponents"));
        }
        List list = ContainerUtil.list((Object[])new ImportComponent[]{new DatabaseDataPreviewComponent(context, this.myProducerLocalDataSource, this.myPath, this.myQueryText), new ImportSettingsComponent(context), new DdlPreviewComponent(context), new DatabaseTableEditorComponent(context)});
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getComponents"));
        }
        return list;
    }

    @Override
    @NotNull
    public String getDialogTitle() {
        String string = String.format(TITLE_MASK, this.myProducerName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getDialogTitle"));
        }
        return string;
    }

    @Override
    @Nullable
    public DatabaseSystem getProducerSystem() {
        return this.myProducerLocalDataSource;
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getDialect"));
        }
        return databaseDialectEx;
    }

    @Override
    @NotNull
    public DeTable createNewTable(@NotNull ImportAction.ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        DatabaseEditorContext editorContext = new DatabaseEditorContext((DbElement)this.myProducerSource, null);
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        DeTable table = ImportUtil.createDeTableFromColumns(model, producers, this.myProducerName);
        table.parent = context.getNamespace();
        table.name = context.getTableName();
        table.comment = this.myTable == null ? table.comment : this.myTable.getComment();
        table.editedObject = null;
        table.getChildren().forEach(child -> {
            child.editedObject = null;
        });
        for (int i2 = 0; i2 < Math.min(producers.size(), table.columns.size()); ++i2) {
            ImportUtil.ColumnTypePredictorInfo info = new ImportUtil.ColumnTypePredictorInfo(context, (ColumnDescriptor)producers.get(i2), rows);
            table.columns.get((int)i2).dataType = this.getPreferredConsumerColumnType(info);
        }
        ImportUtil.removeUnsupportedObjects(table, context.getCaps());
        ImportUtil.removeUntransferableObjects(table);
        DeTable deTable = table;
        if (deTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "createNewTable"));
        }
        return deTable;
    }

    @NotNull
    private String getPreferredConsumerColumnType(@NotNull ImportUtil.ColumnTypePredictorInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/DatabaseInputType", "getPreferredConsumerColumnType"));
        }
        DatabaseDialectEx producerDialect = DbImplUtil.getDatabaseDialect(this.myProducerLocalDataSource);
        String producerVersion = this.myProducerLocalDataSource.getDatabaseProductVersion();
        Domain producerDomain = DomainRegistry.getDomain(producerDialect, producerVersion, info.column, false);
        DatabaseDialectEx dialect = info.context.getDialect();
        DbDataSource source = info.context.getDataSource();
        String version = source == null ? null : source.getDatabaseProductVersion();
        Domain consumerDomain = producerDomain == null ? null : DomainRegistry.getMostRecentDomain(producerDomain, dialect, version);
        String string = consumerDomain == null ? ImportUtil.getPreferredTypeBasedOnContent(info) : consumerDomain.name();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getPreferredConsumerColumnType"));
        }
        return string;
    }

    @NotNull
    private static String getQueryText(@NotNull DasTable table, @NotNull LocalDataSource localDataSource, @NotNull DatabaseDialectEx dialect) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DatabaseInputType", "getQueryText"));
        }
        if (localDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localDataSource", "com/intellij/database/dbimport/DatabaseInputType", "getQueryText"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/dbimport/DatabaseInputType", "getQueryText"));
        }
        String string = DbImplUtil.createSelectAllQuery(table, dialect, (DatabaseSystem)localDataSource).getStatement();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/DatabaseInputType", "getQueryText"));
        }
        return string;
    }

    @Nullable
    private static SearchPath getSearchPath(@NotNull DbDataSource producerDataSource, @NotNull DasTable table) {
        if (producerDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerDataSource", "com/intellij/database/dbimport/DatabaseInputType", "getSearchPath"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DatabaseInputType", "getSearchPath"));
        }
        return SearchPath.of(ObjectPath.of((DasObject)DbImplUtil.getSearchPathObject(DbImplUtil.getDatabaseDialect((DbElement)producerDataSource), (DasObject)table)));
    }
}

