/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.view.DatabaseView;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbElementDnDTarget
implements DnDTarget {
    private final DbElement myConsumerElement;

    public DbElementDnDTarget(@NotNull DbElement consumerElement) {
        if (consumerElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerElement", "com/intellij/database/dbimport/DbElementDnDTarget", "<init>"));
        }
        this.myConsumerElement = consumerElement;
    }

    public void drop(DnDEvent event) {
        if (!this.dropDbElement(event)) {
            this.dropFile(event);
        }
    }

    private boolean dropDbElement(@NotNull DnDEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/dbimport/DbElementDnDTarget", "dropDbElement"));
        }
        DbTable table = this.getDbTable(event);
        if (table == null) {
            return false;
        }
        DbDataSource source = table.getDataSource();
        LocalDataSource delegate = (LocalDataSource)ObjectUtils.tryCast((Object)source.getDelegate(), LocalDataSource.class);
        if (delegate == null) {
            return true;
        }
        DatabaseInputType type = new DatabaseInputType(delegate, source, (DasTable)table, table.getProject());
        ImportAction.showDialog(this.myConsumerElement.getProject(), this.myConsumerElement, table.getName(), type);
        return true;
    }

    private void dropFile(DnDEvent event) {
        List object = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        if (object.size() != 1) {
            return;
        }
        VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem((List)object);
        ImportAction.showDialog(this.myConsumerElement.getProject(), this.myConsumerElement, (VirtualFile)ObjectUtils.assertNotNull((Object)file));
    }

    public boolean update(DnDEvent event) {
        return ImportUtil.canBeConsumer(this.myConsumerElement) && (this.updateDbElements(event) || this.updateFiles(event));
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    @Nullable
    protected DbTable getDbTable(DnDEvent event) {
        Transferable transferable = (Transferable)ObjectUtils.tryCast((Object)event.getAttachedObject(), Transferable.class);
        try {
            Object object = transferable == null ? null : transferable.getTransferData(DnDEventImpl.ourDataFlavor);
            Object[] data = (Object[])ObjectUtils.tryCast((Object)object, Object[].class);
            DbTable table = data == null || data.length != 1 ? null : (DbTable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])data), DbTable.class);
            return table == null || table == this.myConsumerElement || !ImportUtil.canBeProducer((DbElement)table) ? null : table;
        }
        catch (UnsupportedFlavorException | IOException exception) {
            return null;
        }
    }

    protected boolean updateDbElements(DnDEvent event) {
        return this.getDbTable(event) != null;
    }

    protected boolean updateFiles(DnDEvent event) {
        List object = FileCopyPasteUtil.getVirtualFileListFromAttachedObject((Object)event.getAttachedObject());
        return object.size() == 1 && !((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((List)object))).isDirectory();
    }

    public static class GroupElementDnDTarget
    extends NamespaceDnDTarget {
        private final ObjectKind myKind;

        public GroupElementDnDTarget(@NotNull DbNamespaceImpl namespace, @NotNull ObjectKind kind) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dbimport/DbElementDnDTarget$GroupElementDnDTarget", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dbimport/DbElementDnDTarget$GroupElementDnDTarget", "<init>"));
            }
            super(namespace);
            this.myKind = kind;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myKind == ObjectKind.TABLE;
        }
    }

    public static class NamespaceDnDTarget
    extends DbElementDnDTarget {
        private final DbNamespaceImpl myNamespace;

        public NamespaceDnDTarget(@NotNull DbNamespaceImpl namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/database/dbimport/DbElementDnDTarget$NamespaceDnDTarget", "<init>"));
            }
            super(namespace);
            this.myNamespace = namespace;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myNamespace.getKind() == ObjectKind.SCHEMA;
        }

        @Override
        protected boolean updateDbElements(DnDEvent event) {
            DbTable table = this.getDbTable(event);
            return super.updateDbElements(event) && DatabaseView.getLowestSchema((DbElement)table) != this.myNamespace;
        }
    }

    public static class DataSourceDnDTarget
    extends DbElementDnDTarget {
        private final DbDataSource myDataSource;

        public DataSourceDnDTarget(@NotNull DbDataSource dataSource) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dbimport/DbElementDnDTarget$DataSourceDnDTarget", "<init>"));
            }
            super((DbElement)dataSource);
            this.myDataSource = dataSource;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && DatabaseView.getLowestSchema((DbElement)this.myDataSource) != null;
        }

        @Override
        protected boolean updateDbElements(DnDEvent event) {
            DbTable table = this.getDbTable(event);
            return super.updateDbElements(event) && ((DbTable)ObjectUtils.assertNotNull((Object)table)).getDataSource() != this.myDataSource;
        }
    }

    public static class DbTableDnDTarget
    extends DbElementDnDTarget {
        private final DbTable myTable;

        public DbTableDnDTarget(@NotNull DbTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dbimport/DbElementDnDTarget$DbTableDnDTarget", "<init>"));
            }
            super((DbElement)table);
            this.myTable = table;
        }

        @Override
        public boolean update(DnDEvent event) {
            return super.update(event) && this.myTable.getKind() == ObjectKind.TABLE;
        }
    }
}

