/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.dataSource.AsyncUtil;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.view.DatabaseRefactoringHandler;
import com.intellij.database.view.editors.DatabaseEditorBaseEx;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.GenericEditingResultProcessor;
import com.intellij.database.view.ui.ResultProcessorProvider;
import com.intellij.database.view.ui.TableDialogSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportDialog
extends DialogWrapper
implements ResultProcessorProvider {
    private static final Logger LOG = Logger.getInstance(ImportDialog.class);
    private static final Dimension SIZE = JBUI.size((int)800, (int)600);
    private final ImportPanel myPanel;
    private final ImportInfo.Builder myBuilder;
    private final ImportAction.ImportEditorContext myContext;

    public ImportDialog(@NotNull ImportAction.ImportEditorContext context, @NotNull ImportPanel panel) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/database/dbimport/ImportDialog", "<init>"));
        }
        super(context.getProject());
        this.myBuilder = context.getBuilder();
        this.myContext = context;
        this.setTitle(this.myBuilder.getInputType().getDialogTitle());
        this.myPanel = panel;
        this.myPanel.getContentPanel().setPreferredSize(SIZE);
        this.myPanel.init().whenComplete((o, e) -> {
            this.myOKAction.setEnabled(true);
            this.initValidation();
        });
        this.init();
    }

    @NotNull
    public ImportInfo getImportInfo() throws IOException {
        ImportInfo importInfo = this.myPanel.getImportInfo();
        if (importInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getImportInfo"));
        }
        return importInfo;
    }

    @Override
    public void settingsChanged() {
    }

    @Override
    @NotNull
    public JBIterable<Pair<PsiElement, String>> collectRenames() {
        JBIterable<Pair<PsiElement, String>> jBIterable = this.myBuilder.getImportType().isTableCreated() ? DbRenamePsiElementProcessor.collectRenameElements(this.myContext.getModel()) : JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "collectRenames"));
        }
        return jBIterable;
    }

    @Override
    public Project getProject() {
        return this.myBuilder.getContext().getProject();
    }

    @Override
    public boolean isPreviewUsages() {
        return true;
    }

    @Override
    public void success() {
        this.close(0);
    }

    @Override
    public void error(@NotNull String message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/dbimport/ImportDialog", "error"));
        }
        this.myPanel.reportError(message);
        this.myOKAction.setEnabled(true);
    }

    @Override
    @NotNull
    public String statement() {
        String string = this.myPanel.getDdlComponent().getDdlPreview().getPreviewText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "statement"));
        }
        return string;
    }

    @Override
    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myBuilder.getContext();
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getContext"));
        }
        return databaseEditorContext;
    }

    @Override
    @NotNull
    public DeModel getModel() {
        DeModel deModel = this.myContext.getModel();
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getModel"));
        }
        return deModel;
    }

    @Override
    @NotNull
    public DatabaseEditorBaseEx getEditor() {
        ImportDatabaseTableEditor<?> editor = this.myPanel.getTableEditorComponent().getEditor();
        DatabaseEditorBaseEx databaseEditorBaseEx = (DatabaseEditorBaseEx)ObjectUtils.assertNotNull(editor);
        if (databaseEditorBaseEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog", "getEditor"));
        }
        return databaseEditorBaseEx;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.myOKAction.setEnabled(false);
    }

    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        this.getOKAction().setEnabled(false);
        try {
            ImportType type = this.myContext.getBuilder().getImportType();
            MyResultProcessor processor = new MyResultProcessor(this, type.getCodeGenerationSettings(), null);
            if (!processor.process()) {
                this.error("Failed to process");
            }
        }
        catch (Throwable t) {
            LOG.warn(t);
            this.error(t.getMessage());
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myPanel.validationInfo();
    }

    protected int getErrorTextAlignment() {
        return 4;
    }

    protected boolean shouldAddErrorNearButtons() {
        return !ImportDialog.isMoveHelpButtonLeft();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return this.getClass().getName();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getHelpId() {
        return this.myBuilder.getInputType() instanceof DatabaseInputType ? "import.table.dialog" : (this.myBuilder.getProducers() == null ? "import.file.format.dialog" : "import.file.dialog");
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.disposeAll();
    }

    private void disposeAll() {
        Disposer.dispose((Disposable)this.myContext.getDisposable());
    }

    private void runImport() {
        try {
            this.runImport(this.getImportInfo());
        }
        catch (IOException ex) {
            DataSourceUiUtil.showNotification(this.getProject(), "Can't access file", ex.getMessage(), true);
        }
        finally {
            this.disposeAll();
        }
    }

    private void runImport(@NotNull ImportInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/ImportDialog", "runImport"));
        }
        try {
            if (!info.getType().isTableCreated() && info.getConsumersForInsert().isEmpty()) {
                return;
            }
            new DataImporter(this.getProject(), this.myContext.getElement(), info.getInputType(), info).importData();
        }
        catch (IOException ex) {
            DataSourceUiUtil.showNotification(this.getProject(), "Can't create input", ex.getMessage(), true);
        }
    }

    private class ImportRenameProcessor
    extends DbRenamePsiElementProcessor.MyRenameProcessor {
        private ImportInfo myInfo;

        public ImportRenameProcessor(@NotNull Project project, @NotNull PsiElement element, @NotNull @NonNls DatabaseRefactoringHandler handler, @NotNull String newName, JBIterable<Pair<PsiElement, String>> renames, boolean isSearchInComments, boolean isSearchTextOccurrences) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            if (renames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "<init>"));
            }
            super(project, element, handler, newName, (Iterable<Pair<PsiElement, String>>)renames, isSearchInComments, isSearchTextOccurrences);
        }

        @Override
        @NotNull
        protected CompletionStage<Void> runStatements(@NotNull UsageInfo[] usages) {
            if (usages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            CompletionStage<Void> completionStage = super.runStatements(usages).whenCompleteAsync((r, e) -> {
                if (e == null) {
                    ImportDialog.this.runImport(this.myInfo);
                }
            }, AsyncUtil.EDT_EXECUTOR);
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$ImportRenameProcessor", "runStatements"));
            }
            return completionStage;
        }

        protected void prepareSuccessful() {
            try {
                this.myInfo = ImportDialog.this.getImportInfo();
                ImportDialog.this.disposeAll();
                super.prepareSuccessful();
            }
            catch (Throwable t) {
                LOG.warn(t);
                ImportDialog.this.error(t.getMessage());
            }
        }
    }

    private class MyResultProcessor
    extends GenericEditingResultProcessor {
        public MyResultProcessor(@NotNull ResultProcessorProvider provider, @Nullable TableDialogSettings.Settings settings, RangeMarker insertPos) {
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "<init>"));
            }
            super(provider, settings, insertPos);
        }

        @Override
        @NotNull
        protected RenameProcessor createRenameProcessor(@NotNull JBIterable<Pair<PsiElement, String>> renames, @NotNull DatabaseRefactoringHandler handler) {
            if (renames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renames", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            Pair r = (Pair)renames.first();
            if (r == null) {
                throw new AssertionError((Object)"No renames");
            }
            ImportRenameProcessor importRenameProcessor = new ImportRenameProcessor((Project)ObjectUtils.assertNotNull((Object)ImportDialog.this.getContext().getProject()), (PsiElement)r.first, handler, (String)r.second, renames, true, true);
            if (importRenameProcessor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "createRenameProcessor"));
            }
            return importRenameProcessor;
        }

        @Override
        @NotNull
        protected CompletionStage<Void> processWithoutRenames(@NotNull DatabaseRefactoringHandler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            if (StringUtil.isEmpty((String)ImportDialog.this.statement())) {
                ImportDialog.this.success();
                ImportDialog.this.runImport();
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                if (completableFuture == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
                }
                return completableFuture;
            }
            CompletionStage<Void> completionStage = super.processWithoutRenames(handler).whenComplete((r, e) -> {
                if (e == null) {
                    ImportDialog.this.runImport();
                }
            });
            if (completionStage == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ImportDialog$MyResultProcessor", "processWithoutRenames"));
            }
            return completionStage;
        }
    }
}

