/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.view.editors.DatabaseColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingColumnEditor<T extends ColumnDescriptor>
extends DatabaseColumnEditor {
    private final List<T> myDescriptors;
    private T myDescriptor;
    private TextFieldWithAutoCompletion<T> myField;
    private JBLabel myLabel;
    private JPanel myCustomPanel;

    public MappingColumnEditor(@NotNull ImportEditorState<T> state, @NotNull ColumnEditorModel model, @NotNull DatabaseEditorCapabilities.ColumnEditorCaps caps) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ui/MappingColumnEditor", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ui/MappingColumnEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ui/MappingColumnEditor", "<init>"));
        }
        super(state, model, caps);
        this.myDescriptors = state.getDescriptors();
        this.setCustomComponent(this.myCustomPanel, MappingColumnEditor.createConstraints());
        this.myCustomPanel.add((Component)this.myLabel, "North");
        this.myCustomPanel.add((Component)this.myField, "South");
    }

    @Override
    protected void createUIComponents() {
        super.createUIComponents();
        this.myLabel = new JBLabel("Mapped to: ");
        this.myField = new TextFieldWithAutoCompletion(this.getProject(), new MyCompletionProvider(((ImportEditorState)this.getState()).getDescriptors()), true, null);
        this.myField.addSettingsProvider(RefactoringUIUtil.SELECT_ALL_ON_FOCUS);
        this.myField.addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                MappingColumnEditor.this.myDescriptor = (ColumnDescriptor)ContainerUtil.find((Iterable)MappingColumnEditor.this.myDescriptors, descriptor -> StringUtil.equals((CharSequence)descriptor.getName(), (CharSequence)MappingColumnEditor.this.myField.getText()));
            }
        });
        this.myCustomPanel = new JPanel(new BorderLayout());
    }

    @Override
    public ImportEditorState<T> getState() {
        return (ImportEditorState)super.getState();
    }

    @Override
    @NotNull
    protected JComponent[] getEditorFocusableComponents() {
        JComponent[] jComponentArray = (JComponent[])ArrayUtil.mergeArrays((Object[])super.getEditorFocusableComponents(), (Object[])ContainerUtil.ar((Object[])new JComponent[]{this.myField.getFocusTarget()}));
        if (jComponentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingColumnEditor", "getEditorFocusableComponents"));
        }
        return jComponentArray;
    }

    public void setDescriptor(@Nullable T descriptor) {
        this.myDescriptor = descriptor;
        this.myField.setText(descriptor == null ? "" : descriptor.getName());
    }

    @Nullable
    public T getDescriptor() {
        return this.myDescriptor;
    }

    @NotNull
    private static GridConstraints createConstraints() {
        GridConstraints constraints = new GridConstraints();
        constraints.setVSizePolicy(2);
        constraints.setHSizePolicy(4);
        constraints.setFill(3);
        GridConstraints gridConstraints = constraints;
        if (gridConstraints == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingColumnEditor", "createConstraints"));
        }
        return gridConstraints;
    }

    private static class MyCompletionProvider<T extends ColumnDescriptor>
    extends TextFieldWithAutoCompletionListProvider<T> {
        protected MyCompletionProvider(@Nullable Collection<T> variants) {
            super(variants);
        }

        @NotNull
        protected String getLookupString(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dbimport/ui/MappingColumnEditor$MyCompletionProvider", "getLookupString"));
            }
            String string = item.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingColumnEditor$MyCompletionProvider", "getLookupString"));
            }
            return string;
        }

        @Nullable
        protected Icon getIcon(@NotNull T item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/dbimport/ui/MappingColumnEditor$MyCompletionProvider", "getIcon"));
            }
            return DatabaseIcons.Col;
        }
    }
}

