/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagram;

import com.intellij.database.diagram.DbDiagramDataModel;
import com.intellij.database.diagram.DbDiagramElementManager;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.diagram.AbstractDiagramNodeContentManager;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramCategory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramElementsProvider;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.providers.DiagramDnDProvider;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import icons.DatabaseIcons;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDiagramProvider
extends DiagramProvider<DbElement>
implements DumbAware {
    public static final String ID = "DATABASE";
    private static final DiagramCategory COLUMNS = new DiagramCategory("Columns", DatabaseIcons.Col, true);
    private static final DiagramCategory ID_COLUMNS = new DiagramCategory("Key columns", DatabaseIcons.ColGoldKey, true);
    private static final DiagramCategory[] CATEGORIES = new DiagramCategory[]{ID_COLUMNS, COLUMNS};
    private final EmptyDiagramVisibilityManager myVisibilityManager = new EmptyDiagramVisibilityManager();
    private final DbDiagramElementManager myElementManager = new DbDiagramElementManager();
    private final DiagramNodeContentManager myCategoryManager = new AbstractDiagramNodeContentManager(){

        public DiagramCategory[] getContentCategories() {
            return CATEGORIES;
        }

        public boolean isInCategory(Object element, DiagramCategory category, DiagramState presentation) {
            if (COLUMNS.equals((Object)category)) {
                return element instanceof DbColumn && !DasUtil.isPrimary((DasColumn)((DbColumn)element));
            }
            if (ID_COLUMNS.equals((Object)category)) {
                return element instanceof DbColumn && DasUtil.isPrimary((DasColumn)((DbColumn)element));
            }
            return false;
        }
    };
    private final DiagramVfsResolver<DbElement> myVfsResolver = new DiagramVfsResolver<DbElement>(){

        public String getQualifiedName(DbElement element) {
            return element.getDataSource().getUniqueId() + (element instanceof DbDataSource ? "" : "." + element.getKind().name() + ":" + QNameUtil.getQualifiedName(element));
        }

        public DbElement resolveElementByFQN(String fqn, Project project) {
            int idx = fqn.indexOf(46);
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(idx == -1 ? fqn : fqn.substring(0, idx));
            if (dataSource == null || idx == -1) {
                return dataSource;
            }
            String typedQName = fqn.substring(idx + 1);
            String qname = typedQName.substring(typedQName.indexOf(58) + 1);
            for (DasObject object : QNameUtil.findByQName(dataSource.getModel(), qname, (Function<DasObject, String>)DasUtil.TO_NAME)) {
                if (!typedQName.startsWith(object.getKind().name() + ":")) continue;
                return (DbElement)object;
            }
            return null;
        }
    };
    private final DiagramRelationshipManager<DbElement> myRelationshipManager = new DiagramRelationshipManager<DbElement>(){

        @Nullable
        public DiagramRelationshipInfo getDependencyInfo(DbElement e1, DbElement e2, DiagramCategory category) {
            return null;
        }

        public DiagramCategory[] getContentCategories() {
            return DiagramCategory.EMPTY_ARRAY;
        }
    };
    private final DiagramExtras<DbElement> myExtras = new DiagramExtras<DbElement>(){
        private final DiagramDnDProvider<DbElement> DND_PROVIDER = new DiagramDnDProvider<DbElement>(){

            public boolean isAcceptedForDnD(Object o, Project project) {
                return DbDiagramElementManager.isAcceptedAsNodeImpl(o);
            }

            public DbElement[] wrapToModelObject(Object o, Project project) {
                return new DbElement[]{(DbElement)o};
            }
        };

        public DiagramElementsProvider<DbElement>[] getElementsProviders() {
            return DiagramElementsProvider.EMPTY_ARRAY;
        }

        public DiagramDnDProvider<DbElement> getDnDProvider() {
            return this.DND_PROVIDER;
        }

        @Nullable
        public Object getData(String dataId, List<DiagramNode<DbElement>> nodes2, DiagramBuilder builder) {
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return "reference.persistencediagram";
            }
            return super.getData(dataId, nodes2, builder);
        }
    };

    public DbDiagramProvider() {
        this.myElementManager.setUmlProvider(this);
    }

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.myVisibilityManager;
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return this.myCategoryManager;
    }

    public DiagramElementManager<DbElement> getElementManager() {
        return this.myElementManager;
    }

    public DiagramVfsResolver<DbElement> getVfsResolver() {
        return this.myVfsResolver;
    }

    public DiagramRelationshipManager<DbElement> getRelationshipManager() {
        return this.myRelationshipManager;
    }

    public DiagramDataModel<DbElement> createDataModel(@NotNull Project project, @Nullable DbElement element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/diagram/DbDiagramProvider", "createDataModel"));
        }
        return new DbDiagramDataModel(project, element, this);
    }

    @NotNull
    public DiagramExtras<DbElement> getExtras() {
        DiagramExtras<DbElement> diagramExtras = this.myExtras;
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diagram/DbDiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    public String getActionName(boolean isPopup) {
        return "Visualisation";
    }

    public String getPresentableName() {
        return "DB Diagrams";
    }
}

