/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectWrapper<T> {
    private final T myObject;
    private final HasherAndComparator<T> myHasher;

    public ObjectWrapper(@Nullable T object, @NotNull HasherAndComparator<T> hasher) {
        if (hasher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasher", "com/intellij/database/diff/ObjectWrapper", "<init>"));
        }
        this.myObject = object;
        this.myHasher = hasher;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof ObjectWrapper)) {
            return false;
        }
        ObjectWrapper wrapper = (ObjectWrapper)o;
        return wrapper.myHasher.equals(this.myHasher) && this.myHasher.equals(this.myObject, this.doCast(wrapper.myObject));
    }

    public int hashCode() {
        return this.myHasher.hash(this.myObject);
    }

    @NotNull
    public static <T> List<ObjectWrapper> wrap(@NotNull List<T> objs, @NotNull HasherAndComparator<T> pred) {
        if (objs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objs", "com/intellij/database/diff/ObjectWrapper", "wrap"));
        }
        if (pred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pred", "com/intellij/database/diff/ObjectWrapper", "wrap"));
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)objs.size());
        for (T obj : objs) {
            res.add(new ObjectWrapper<T>(obj, pred));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/ObjectWrapper", "wrap"));
        }
        return arrayList;
    }

    @NotNull
    public static <T> List<List<ObjectWrapper>> wrap2(@NotNull List<List<T>> objs, @NotNull HasherAndComparator<T> pred) {
        if (objs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objs", "com/intellij/database/diff/ObjectWrapper", "wrap2"));
        }
        if (pred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pred", "com/intellij/database/diff/ObjectWrapper", "wrap2"));
        }
        ArrayList res = ContainerUtil.newArrayListWithCapacity((int)objs.size());
        for (List<T> obj : objs) {
            res.add(ObjectWrapper.wrap(obj, pred));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/ObjectWrapper", "wrap2"));
        }
        return arrayList;
    }

    private T doCast(Object obj) {
        return (T)obj;
    }

    public static interface HasherAndComparator<T> {
        public boolean equals(T var1, T var2);

        public int hash(T var1);
    }
}

