/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.database.diff.DiffAlgo;
import com.intellij.database.diff.TableDiffSettingsHolder;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableDiffBuilder {
    @NotNull
    private static List<Object> skip(@NotNull List<Object> list, @NotNull TIntArrayList skip) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/diff/TableDiffBuilder", "skip"));
        }
        if (skip == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skip", "com/intellij/database/diff/TableDiffBuilder", "skip"));
        }
        ArrayList cols3 = ContainerUtil.newArrayListWithCapacity((int)(list.size() - skip.size()));
        int k = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (k < skip.size() && i2 == skip.get(k)) {
                ++k;
                continue;
            }
            cols3.add(list.get(i2));
        }
        ArrayList arrayList = cols3;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffBuilder", "skip"));
        }
        return arrayList;
    }

    @NotNull
    public static TableDiffResult process(@NotNull Data data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "process"));
        }
        TableDiffResult res = new TableDiffResult();
        if (data.table1.isEmpty() || data.table2.isEmpty()) {
            if (!data.table1.isEmpty() || !data.table2.isEmpty()) {
                res.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(0, data.table1.size(), 0, data.table2.size()), (Object)false));
            }
            TableDiffResult tableDiffResult = res;
            if (tableDiffResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffBuilder", "process"));
            }
            return tableDiffResult;
        }
        boolean skip = TableDiffBuilder.findColumnsToSkip(data, res.skippedCols1, res.skippedCols2);
        if (skip) {
            data = data.skipped(res.skippedCols1, res.skippedCols2);
        }
        assert (data.table1.get(0).size() == data.table2.get(0).size());
        TableDiffResult subRes = TableDiffBuilder.processSameCols(data);
        if (!skip) {
            TableDiffResult tableDiffResult = subRes;
            if (tableDiffResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffBuilder", "process"));
            }
            return tableDiffResult;
        }
        TableDiffResult tableDiffResult = res.apply(subRes);
        if (tableDiffResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/diff/TableDiffBuilder", "process"));
        }
        return tableDiffResult;
    }

    private static boolean findColumnsToSkip(@NotNull Data data, @NotNull TIntArrayList cols12, @NotNull TIntArrayList cols22) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "findColumnsToSkip"));
        }
        if (cols12 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols1", "com/intellij/database/diff/TableDiffBuilder", "findColumnsToSkip"));
        }
        if (cols22 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cols2", "com/intellij/database/diff/TableDiffBuilder", "findColumnsToSkip"));
        }
        if (data.table1.get(0).size() == data.table2.get(0).size()) {
            return false;
        }
        if (!data.settings.detectColumnInsertion) {
            int s2;
            int s1 = data.table1.get(0).size();
            if (s1 < (s2 = data.table2.get(0).size())) {
                for (int i2 = s1; i2 < s2; ++i2) {
                    cols22.add(i2);
                }
            } else {
                for (int i3 = s2; i3 < s1; ++i3) {
                    cols12.add(i3);
                }
            }
            return true;
        }
        int m = Math.min(data.table1.get(0).size(), data.table2.get(0).size());
        int shouldMatch = Math.max(1, m - data.settings.columnMismatchThreshold);
        List<List<Object>> fuzzy1 = data.table1.subList(0, Math.min(data.table1.size(), data.settings.columnDetectionSample));
        List<List<Object>> fuzzy2 = data.table2.subList(0, Math.min(data.table2.size(), data.settings.columnDetectionSample));
        DiffIterable diff = DiffAlgo.diff(fuzzy1, fuzzy2, (o1, o2) -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "lambda$findColumnsToSkip$0"));
            }
            FairDiffIterable diff1 = DiffIterableUtil.diff((List)o1, (List)o2, (ProgressIndicator)data.indicator);
            int matched = 0;
            Iterator unchanged = diff1.unchanged();
            while (unchanged.hasNext()) {
                Range range = (Range)unchanged.next();
                matched += range.end1 - range.start1;
            }
            return matched >= shouldMatch ? 0 : 1;
        });
        int[] changes1 = new int[data.table1.get(0).size()];
        int[] changes2 = new int[data.table2.get(0).size()];
        Iterator unchanged = diff.unchanged();
        while (unchanged.hasNext()) {
            Range range = (Range)unchanged.next();
            assert (range.end1 - range.start1 == range.end2 - range.start2);
            for (int i4 = 0; i4 < range.end1 - range.start1; ++i4) {
                FairDiffIterable columnsDiff = DiffIterableUtil.diff(fuzzy1.get(range.start1 + i4), fuzzy2.get(range.start2 + i4), (ProgressIndicator)data.indicator);
                Iterator changes = columnsDiff.changes();
                while (changes.hasNext()) {
                    Range columnsRange = (Range)changes.next();
                    int k = columnsRange.start1;
                    while (k < columnsRange.end1) {
                        int n = k++;
                        changes1[n] = changes1[n] + 1;
                    }
                    k = columnsRange.start2;
                    while (k < columnsRange.end2) {
                        int n = k++;
                        changes2[n] = changes2[n] + 1;
                    }
                }
            }
        }
        int d = data.table1.get(0).size() - data.table2.get(0).size();
        if (d < 0) {
            TableDiffBuilder.findNMax(changes2, -d, cols22);
        } else {
            TableDiffBuilder.findNMax(changes1, d, cols12);
        }
        return true;
    }

    private static void findNMax(@NotNull int[] data, int n, @NotNull TIntArrayList maxIds) {
        int i2;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "findNMax"));
        }
        if (maxIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maxIds", "com/intellij/database/diff/TableDiffBuilder", "findNMax"));
        }
        boolean[] maxes = new boolean[data.length];
        for (i2 = 0; i2 < n; ++i2) {
            int max = Integer.MIN_VALUE;
            int maxi = -1;
            for (int j = 0; j < data.length; ++j) {
                if (maxes[j] || max >= data[j]) continue;
                max = data[j];
                maxi = j;
            }
            assert (maxi != -1);
            maxes[maxi] = true;
        }
        for (i2 = 0; i2 < maxes.length; ++i2) {
            if (!maxes[i2]) continue;
            maxIds.add(i2);
        }
    }

    private static TableDiffResult processSameCols(@NotNull Data data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "processSameCols"));
        }
        TableDiffResult result2 = new TableDiffResult();
        FairDiffIterable diff = DiffIterableUtil.diff(data.table1, data.table2, (ProgressIndicator)data.indicator);
        Iterator it = diff.changes();
        while (it.hasNext()) {
            if (data.settings.columnMismatchThreshold > 0) {
                TableDiffBuilder.appendFuzzyMatch((Range)it.next(), data, result2);
                continue;
            }
            TableDiffBuilder.appendUnmatched(0, 0, (Range)it.next(), false, result2);
        }
        return result2;
    }

    private static void appendUnmatched(int s1, int s2, @NotNull Range rg, boolean fuzzy, @NotNull TableDiffResult result2) {
        if (rg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rg", "com/intellij/database/diff/TableDiffBuilder", "appendUnmatched"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/diff/TableDiffBuilder", "appendUnmatched"));
        }
        result2.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(s1 + rg.start1, s1 + rg.end1, s2 + rg.start2, s2 + rg.end2), (Object)fuzzy));
    }

    private static void appendFuzzyMatch(@NotNull Range rg, @NotNull Data data, @NotNull TableDiffResult result2) {
        if (rg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rg", "com/intellij/database/diff/TableDiffBuilder", "appendFuzzyMatch"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "appendFuzzyMatch"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/diff/TableDiffBuilder", "appendFuzzyMatch"));
        }
        DiffIterable fuzzyDiff = DiffAlgo.diff(data.table1.subList(rg.start1, rg.end1), data.table2.subList(rg.start2, rg.end2), (a, b) -> {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/database/diff/TableDiffBuilder", "lambda$appendFuzzyMatch$1"));
            }
            if (a.size() != b.size()) {
                return -1;
            }
            int mismatches = 0;
            for (int i2 = 0; i2 < a.size(); ++i2) {
                if (!Comparing.equal(a.get(i2), b.get(i2))) {
                    ++mismatches;
                }
                if (mismatches <= data.settings.columnMismatchThreshold) continue;
                return -1;
            }
            return 0;
        });
        Iterator it2 = fuzzyDiff.changes();
        while (it2.hasNext()) {
            TableDiffBuilder.appendUnmatched(rg.start1, rg.start2, (Range)it2.next(), false, result2);
        }
        it2 = fuzzyDiff.unchanged();
        while (it2.hasNext()) {
            Range rg2 = (Range)it2.next();
            TableDiffBuilder.appendUnmatched(rg.start1, rg.start2, rg2, true, result2);
            assert (rg2.end1 - rg2.start1 == rg2.end2 - rg2.start2);
            for (int i2 = 0; i2 < rg2.end1 - rg2.start1; ++i2) {
                int row1 = rg.start1 + rg2.start1 + i2;
                int row2 = rg.start2 + rg2.start2 + i2;
                for (int j = 0; j < data.table1.get(row1).size(); ++j) {
                    if (Comparing.equal((Object)data.table1.get(row1).get(j), (Object)data.table2.get(row2).get(j))) continue;
                    result2.cellDiff.add(new CellDiff(row1, j, row2, j));
                }
            }
        }
    }

    public static class TableDiffResult {
        public final TIntArrayList skippedCols1 = new TIntArrayList();
        public final TIntArrayList skippedCols2 = new TIntArrayList();
        public final TIntArrayList skippedRows1 = new TIntArrayList();
        public final TIntArrayList skippedRows2 = new TIntArrayList();
        public final List<Pair<RowDiffRange, Boolean>> rowDiff = ContainerUtil.newArrayList();
        public final List<CellDiff> cellDiff = ContainerUtil.newArrayList();

        public TableDiffResult apply(@NotNull TableDiffResult res) {
            int i2;
            if (res == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "res", "com/intellij/database/diff/TableDiffBuilder$TableDiffResult", "apply"));
            }
            int[] cmap1 = TableDiffResult.createMapping(this.skippedCols1);
            int[] cmap2 = TableDiffResult.createMapping(this.skippedCols2);
            int[] rmap1 = TableDiffResult.createMapping(this.skippedRows1);
            int[] rmap2 = TableDiffResult.createMapping(this.skippedRows2);
            for (i2 = 0; i2 < res.skippedCols1.size(); ++i2) {
                this.skippedCols1.add(TableDiffResult.map(cmap1, res.skippedCols1.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedCols2.size(); ++i2) {
                this.skippedCols2.add(TableDiffResult.map(cmap2, res.skippedCols2.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedRows1.size(); ++i2) {
                this.skippedRows1.add(TableDiffResult.map(rmap1, res.skippedRows1.get(i2)));
            }
            for (i2 = 0; i2 < res.skippedRows2.size(); ++i2) {
                this.skippedRows2.add(TableDiffResult.map(rmap2, res.skippedRows2.get(i2)));
            }
            this.skippedCols1.sort();
            this.skippedCols2.sort();
            this.skippedRows1.sort();
            this.skippedRows2.sort();
            for (Pair<RowDiffRange, Boolean> pair : res.rowDiff) {
                this.rowDiff.add((Pair<RowDiffRange, Boolean>)Pair.create((Object)new RowDiffRange(TableDiffResult.map(rmap1, ((RowDiffRange)pair.first).begin1), TableDiffResult.map(rmap1, ((RowDiffRange)pair.first).end1), TableDiffResult.map(rmap2, ((RowDiffRange)pair.first).begin2), TableDiffResult.map(rmap2, ((RowDiffRange)pair.first).end2)), (Object)pair.second));
            }
            for (CellDiff diff : res.cellDiff) {
                this.cellDiff.add(new CellDiff(TableDiffResult.map(rmap1, diff.row1), TableDiffResult.map(cmap1, diff.col1), TableDiffResult.map(rmap2, diff.row2), TableDiffResult.map(cmap2, diff.col2)));
            }
            return this;
        }

        private static int map(@Nullable int[] mapping, int idx) {
            if (mapping == null) {
                return idx;
            }
            if (idx < mapping.length) {
                return mapping[idx];
            }
            int last = mapping.length - 1;
            return idx - last + mapping[last];
        }

        @Nullable
        private static int[] createMapping(TIntArrayList skip) {
            if (skip.isEmpty()) {
                return null;
            }
            int end = skip.get(skip.size() - 1) + 1;
            int[] res = new int[end - skip.size() + 1];
            int s = 0;
            for (int i2 = 0; i2 <= end; ++i2) {
                if (s < skip.size() && i2 == skip.get(s)) {
                    ++s;
                    continue;
                }
                res[i2 - s] = i2;
            }
            return res;
        }

        public boolean isEqual() {
            return this.rowDiff.isEmpty();
        }
    }

    public static class CellDiff {
        public final int row1;
        public final int col1;
        public final int row2;
        public final int col2;

        private CellDiff(int row1, int col1, int row2, int col2) {
            this.row1 = row1;
            this.col1 = col1;
            this.row2 = row2;
            this.col2 = col2;
        }
    }

    public static class RowDiffRange {
        public final int begin1;
        public final int end1;
        public final int begin2;
        public final int end2;

        private RowDiffRange(int begin1, int end1, int begin2, int end2) {
            this.begin1 = begin1;
            this.end1 = end1;
            this.begin2 = begin2;
            this.end2 = end2;
        }

        public DiffType getType() {
            if (this.begin1 == this.end1) {
                return DiffType.INSERT;
            }
            if (this.begin2 == this.end2) {
                return DiffType.REMOVE;
            }
            return DiffType.REPLACE;
        }
    }

    public static enum DiffType {
        INSERT,
        REMOVE,
        REPLACE;

    }

    public static class Data {
        public final List<List<Object>> table1;
        public final List<List<Object>> table2;
        public final TableDiffSettingsHolder.Settings settings;
        public final ProgressIndicator indicator;

        public Data(@NotNull List<List<Object>> table1, @NotNull List<List<Object>> table2, @NotNull TableDiffSettingsHolder.Settings settings, @NotNull ProgressIndicator indicator) {
            if (table1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table1", "com/intellij/database/diff/TableDiffBuilder$Data", "<init>"));
            }
            if (table2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table2", "com/intellij/database/diff/TableDiffBuilder$Data", "<init>"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/diff/TableDiffBuilder$Data", "<init>"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/diff/TableDiffBuilder$Data", "<init>"));
            }
            this.table1 = table1;
            this.table2 = table2;
            this.settings = settings;
            this.indicator = indicator;
        }

        public Data skipped(@NotNull TIntArrayList col1, @NotNull TIntArrayList col2) {
            if (col1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col1", "com/intellij/database/diff/TableDiffBuilder$Data", "skipped"));
            }
            if (col2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "col2", "com/intellij/database/diff/TableDiffBuilder$Data", "skipped"));
            }
            Data res = new Data(ContainerUtil.newArrayList(), ContainerUtil.newArrayList(), this.settings, this.indicator);
            if (!col1.isEmpty()) {
                for (List<Object> row : this.table1) {
                    res.table1.add(TableDiffBuilder.skip(row, col1));
                }
            } else {
                res.table1.addAll(this.table1);
            }
            if (!col2.isEmpty()) {
                for (List<Object> row : this.table2) {
                    res.table2.add(TableDiffBuilder.skip(row, col2));
                }
            } else {
                res.table2.addAll(this.table2);
            }
            return res;
        }
    }
}

